/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.epf.web.search.utils.UNCUtil;

public class XSLTProcessor {
    private static boolean cacheXSL = true;
    private static Map cache = new HashMap();

    private XSLTProcessor() {
    }

    public static Map getCache() {
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(Source xslSource, Source xmlSource, Writer output, Properties params, String encoding) throws Exception {
        if (xslSource != null && xmlSource != null) {
            Transformer transformer = null;
            String xslSystemId = xslSource.getSystemId();
            if (cacheXSL && xslSystemId != null) {
                Map map = cache;
                synchronized (map) {
                    transformer = (Transformer)cache.get(xslSystemId);
                    if (transformer == null) {
                        TransformerFactory transformerFactory = TransformerFactory.newInstance();
                        transformer = transformerFactory.newTransformer(xslSource);
                        cache.put(xslSystemId, transformer);
                    }
                }
            } else {
                TransformerFactory factory = TransformerFactory.newInstance();
                transformer = factory.newTransformer(xslSource);
            }
            if (params != null && params.size() > 0) {
                for (String string : params.keySet()) {
                    String paramValue = params.getProperty(string);
                    transformer.setParameter(string, paramValue);
                }
            }
            if (encoding != null && encoding.length() > 0) {
                transformer.setOutputProperty("encoding", encoding);
            } else {
                transformer.setOutputProperty("encoding", "utf-8");
            }
            transformer.transform(xmlSource, new StreamResult(output));
        }
    }

    public static void transform(Source xslSource, Source xmlSource, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslSource, xmlSource, output, null, encoding);
    }

    public static void transform(String xslUri, Source xmlSource, Writer output, Properties params, String encoding) throws Exception {
        InputStream xslInput = XSLTProcessor.getXslInputStream(xslUri);
        if (xslInput != null) {
            StreamSource xslSource = new StreamSource(xslInput);
            xslSource.setSystemId(new File(xslUri));
            XSLTProcessor.transform(xslSource, xmlSource, output, params, encoding);
            try {
                xslInput.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transform(String xslUri, Source xmlSource, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, null, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transform(String xslUri, String xmlStr, Writer output, Properties params, String encoding) throws Exception {
        InputStream xslInput = null;
        if (cacheXSL && xslUri != null) {
            Map map = cache;
            synchronized (map) {
                xslInput = (InputStream)cache.get(xslUri);
                if (xslInput == null) {
                    xslInput = XSLTProcessor.getXslInputStream(xslUri);
                    cache.put(xslUri, xslInput);
                }
            }
        } else {
            xslInput = XSLTProcessor.getXslInputStream(xslUri);
        }
        if (xslInput != null) {
            StreamSource xslSource = new StreamSource(xslInput);
            xslSource.setSystemId(new File(xslUri));
            byte[] xml = xmlStr.getBytes("utf-8");
            ByteArrayInputStream xmlInput = new ByteArrayInputStream(xml);
            StreamSource xmlSource = new StreamSource(xmlInput);
            XSLTProcessor.transform(xslSource, (Source)xmlSource, output, params, encoding);
            try {
                xslInput.close();
            }
            catch (FileNotFoundException fne) {
                fne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new FileNotFoundException(xslUri);
        }
    }

    public static void transform(String xslUri, String xmlStr, Writer output, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, null, encoding);
    }

    public static void transform(String xslUri, String xmlStr, File file, Properties params, String encoding) throws Exception {
        FileWriter output = new FileWriter(file);
        if (output != null) {
            XSLTProcessor.transform(xslUri, xmlStr, (Writer)output, params, encoding);
            try {
                output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transform(String xslUri, String xmlStr, File file, String encoding) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, null, encoding);
    }

    public static void transform(String xslUri, Source xmlSource, Properties params, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, params, null);
    }

    public static void transform(String xslUri, Source xmlSource, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlSource, output, null, null);
    }

    public static void transform(String xslUri, String xmlStr, Properties params, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, params, null);
    }

    public static void transform(String xslUri, String xmlStr, Writer output) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, output, null, null);
    }

    public static void transform(String xslUri, String xmlStr, Properties params, File file) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, params, null);
    }

    public static void transform(String xslUri, String xmlStr, File file) throws Exception {
        XSLTProcessor.transform(xslUri, xmlStr, file, null, null);
    }

    private static InputStream getXslInputStream(String xslUri) {
        InputStream xslInput;
        block2: {
            xslInput = null;
            try {
                xslInput = xslUri.startsWith("http") ? XSLTProcessor.class.getClassLoader().getResourceAsStream(xslUri) : new FileInputStream(UNCUtil.convertFilename(xslUri));
            }
            catch (Exception e) {
                if (xslInput != null) break block2;
                xslInput = XSLTProcessor.class.getClassLoader().getResourceAsStream(xslUri);
            }
        }
        return xslInput;
    }
}

