/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.ad.part.UMLCreationWizardPage;
import org.eclipse.epf.diagram.ad.part.UMLDiagramEditorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class UMLCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected UMLCreationWizardPage diagramModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean bl) {
        this.openNewlyCreatedDiagramEditor = bl;
    }

    public void addPages() {
        this.diagramModelFilePage = new UMLCreationWizardPage("DiagramModelFile", this.getSelection(), "xmi");
        this.diagramModelFilePage.setTitle("Create AD Diagram");
        this.diagramModelFilePage.setDescription("Select file that will contain diagram and domain models.");
        this.addPage((IWizardPage)this.diagramModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException, InterruptedException {
                UMLCreationWizard.this.diagram = UMLDiagramEditorUtil.createDiagram(UMLCreationWizard.this.diagramModelFilePage.getURI(), iProgressMonitor);
                if (UMLCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && UMLCreationWizard.this.diagram != null) {
                    try {
                        UMLDiagramEditorUtil.openDiagram(UMLCreationWizard.this.diagram);
                    }
                    catch (PartInitException partInitException) {
                        ErrorDialog.openError((Shell)UMLCreationWizard.this.getContainer().getShell(), (String)"Error opening diagram editor", null, (IStatus)partInitException.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Creation Problems", null, (IStatus)((CoreException)invocationTargetException.getTargetException()).getStatus());
            } else {
                ActivityDiagramEditorPlugin.getInstance().logError("Error creating diagram", invocationTargetException.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.workbench = iWorkbench;
        this.selection = iStructuredSelection;
        this.setWindowTitle("New AD Diagram");
        this.setDefaultPageImageDescriptor(ActivityDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewUMLWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }
}

