/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.internal.importing;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.dataexchange.importing.PluginService;
import org.eclipse.epf.library.edit.process.command.WBSDropCommand;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Outcome;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Report;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Template;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;

public class PluginServiceImpl
implements PluginService {
    MethodPlugin plugin;

    public PluginServiceImpl(MethodPlugin methodPlugin) {
        this.plugin = methodPlugin;
    }

    public MethodPlugin getPlugin() {
        return this.plugin;
    }

    public ContentPackage getContentPackageRoot() {
        return UmaUtil.findContentPackage((MethodPlugin)this.plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
    }

    public Discipline createDiscipline() {
        Discipline discipline = UmaFactory.eINSTANCE.createDiscipline();
        ContentPackage contentPackage = (ContentPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        contentPackage.getContentElements().add(discipline);
        return discipline;
    }

    public DisciplineGrouping createDisciplineGrouping() {
        DisciplineGrouping disciplineGrouping = UmaFactory.eINSTANCE.createDisciplineGrouping();
        ContentPackage contentPackage = (ContentPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
        contentPackage.getContentElements().add(disciplineGrouping);
        return disciplineGrouping;
    }

    public Tool createTool() {
        Tool tool = UmaFactory.eINSTANCE.createTool();
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.toolPath);
        contentPackage.getContentElements().add(tool);
        return tool;
    }

    public Domain createDomain() {
        Domain domain = UmaFactory.eINSTANCE.createDomain();
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.domainPath);
        contentPackage.getContentElements().add(domain);
        return domain;
    }

    public WorkProductType createWorkProductType() {
        WorkProductType workProductType = UmaFactory.eINSTANCE.createWorkProductType();
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.workProductTypePath);
        contentPackage.getContentElements().add(workProductType);
        return workProductType;
    }

    public RoleSet createRoleSet() {
        RoleSet roleSet = UmaFactory.eINSTANCE.createRoleSet();
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.roleSetPath);
        contentPackage.getContentElements().add(roleSet);
        return roleSet;
    }

    public RoleSetGrouping createRoleSetGrouping() {
        RoleSetGrouping roleSetGrouping = UmaFactory.eINSTANCE.createRoleSetGrouping();
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.roleSetPath);
        contentPackage.getContentElements().add(roleSetGrouping);
        return roleSetGrouping;
    }

    public CustomCategory createCustomCategory(CustomCategory customCategory) {
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.customCategoryPath);
        CustomCategory customCategory2 = UmaFactory.eINSTANCE.createCustomCategory();
        contentPackage.getContentElements().add(customCategory2);
        if (customCategory != null) {
            customCategory.getCategorizedElements().add(customCategory2);
        } else {
            TngUtil.getRootCustomCategory((MethodPlugin)this.getPlugin()).getCategorizedElements().add(customCategory2);
        }
        return customCategory2;
    }

    public CapabilityPattern createCapabilityPattern(MethodConfiguration methodConfiguration) {
        CapabilityPattern capabilityPattern = UmaFactory.eINSTANCE.createCapabilityPattern();
        capabilityPattern.setDefaultContext(methodConfiguration);
        ProcessPackage processPackage = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        List list = processPackage.getChildPackages();
        ProcessComponent processComponent = UmaFactory.eINSTANCE.createProcessComponent();
        processComponent.setGuid(EcoreUtil.generateUUID());
        list.add(processComponent);
        processComponent.setProcess((Process)capabilityPattern);
        return capabilityPattern;
    }

    public DeliveryProcess createDeliveryProcess(MethodConfiguration methodConfiguration) {
        DeliveryProcess deliveryProcess = UmaFactory.eINSTANCE.createDeliveryProcess();
        deliveryProcess.setDefaultContext(methodConfiguration);
        MethodPlugin methodPlugin = this.getPlugin();
        ProcessPackage processPackage = (ProcessPackage)UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        List list = processPackage.getChildPackages();
        ProcessComponent processComponent = UmaFactory.eINSTANCE.createProcessComponent();
        processComponent.setGuid(EcoreUtil.generateUUID());
        list.add(processComponent);
        processComponent.setProcess((Process)deliveryProcess);
        return deliveryProcess;
    }

    public ContentPackage createContentPackage(ContentPackage contentPackage) {
        ContentPackage contentPackage2 = UmaFactory.eINSTANCE.createContentPackage();
        if (contentPackage == null) {
            contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.getPlugin(), (String[])ModelStructure.DEFAULT.coreContentPath);
        }
        contentPackage.getChildPackages().add(contentPackage2);
        return contentPackage2;
    }

    public Artifact createArtifact(ContentPackage contentPackage) {
        Artifact artifact = UmaFactory.eINSTANCE.createArtifact();
        contentPackage.getContentElements().add(artifact);
        return artifact;
    }

    public Checklist createChecklist(ContentPackage contentPackage) {
        Checklist checklist = UmaFactory.eINSTANCE.createChecklist();
        contentPackage.getContentElements().add(checklist);
        return checklist;
    }

    public Concept createConcept(ContentPackage contentPackage) {
        Concept concept = UmaFactory.eINSTANCE.createConcept();
        contentPackage.getContentElements().add(concept);
        return concept;
    }

    public Deliverable createDeliverable(ContentPackage contentPackage) {
        Deliverable deliverable = UmaFactory.eINSTANCE.createDeliverable();
        contentPackage.getContentElements().add(deliverable);
        return deliverable;
    }

    public Example createExample(ContentPackage contentPackage) {
        Example example = UmaFactory.eINSTANCE.createExample();
        contentPackage.getContentElements().add(example);
        return example;
    }

    public Guidance createGuidance(ContentPackage contentPackage) {
        Guideline guideline = UmaFactory.eINSTANCE.createGuideline();
        contentPackage.getContentElements().add(guideline);
        return guideline;
    }

    public Outcome createOutcome(ContentPackage contentPackage) {
        Outcome outcome = UmaFactory.eINSTANCE.createOutcome();
        contentPackage.getContentElements().add(outcome);
        return outcome;
    }

    public Practice createPractice(ContentPackage contentPackage) {
        Practice practice = UmaFactory.eINSTANCE.createPractice();
        contentPackage.getContentElements().add(practice);
        return practice;
    }

    public Report createReport(ContentPackage contentPackage) {
        Report report = UmaFactory.eINSTANCE.createReport();
        contentPackage.getContentElements().add(report);
        return report;
    }

    public ReusableAsset createReusableAsset(ContentPackage contentPackage) {
        ReusableAsset reusableAsset = UmaFactory.eINSTANCE.createReusableAsset();
        contentPackage.getContentElements().add(reusableAsset);
        return reusableAsset;
    }

    public Roadmap createRoadmap(ContentPackage contentPackage) {
        Roadmap roadmap = UmaFactory.eINSTANCE.createRoadmap();
        contentPackage.getContentElements().add(roadmap);
        return roadmap;
    }

    public Role createRole(ContentPackage contentPackage) {
        Role role = UmaFactory.eINSTANCE.createRole();
        contentPackage.getContentElements().add(role);
        return role;
    }

    public SupportingMaterial createSupportingMaterial(ContentPackage contentPackage) {
        SupportingMaterial supportingMaterial = UmaFactory.eINSTANCE.createSupportingMaterial();
        contentPackage.getContentElements().add(supportingMaterial);
        return supportingMaterial;
    }

    public Task createTask(ContentPackage contentPackage) {
        Task task = UmaFactory.eINSTANCE.createTask();
        contentPackage.getContentElements().add(task);
        return task;
    }

    public Template createTemplate(ContentPackage contentPackage) {
        Template template = UmaFactory.eINSTANCE.createTemplate();
        contentPackage.getContentElements().add(template);
        return template;
    }

    public TermDefinition createTermDefinition(ContentPackage contentPackage) {
        TermDefinition termDefinition = UmaFactory.eINSTANCE.createTermDefinition();
        contentPackage.getContentElements().add(termDefinition);
        return termDefinition;
    }

    public ToolMentor createToolMentor(ContentPackage contentPackage) {
        ToolMentor toolMentor = UmaFactory.eINSTANCE.createToolMentor();
        contentPackage.getContentElements().add(toolMentor);
        return toolMentor;
    }

    public Whitepaper createWhitepaper(ContentPackage contentPackage) {
        Whitepaper whitepaper = UmaFactory.eINSTANCE.createWhitepaper();
        contentPackage.getContentElements().add(whitepaper);
        return whitepaper;
    }

    public Activity createActivity(Activity activity) {
        Activity activity2 = UmaFactory.eINSTANCE.createActivity();
        activity.getBreakdownElements().add(activity2);
        this.addActivityToContainer(activity2);
        return activity2;
    }

    public Phase createPhase(Activity activity) {
        Phase phase = UmaFactory.eINSTANCE.createPhase();
        activity.getBreakdownElements().add(phase);
        this.addActivityToContainer((Activity)phase);
        return phase;
    }

    public Iteration createIteration(Activity activity) {
        Iteration iteration = UmaFactory.eINSTANCE.createIteration();
        activity.getBreakdownElements().add(iteration);
        this.addActivityToContainer((Activity)iteration);
        return iteration;
    }

    public Milestone createMilestone(Activity activity) {
        Milestone milestone = UmaFactory.eINSTANCE.createMilestone();
        activity.getBreakdownElements().add(milestone);
        return milestone;
    }

    public void addTaskToActivity(Activity activity, Task task) {
        this.addTasksToActivity(activity, Collections.singletonList(task));
    }

    public void addTasksToActivity(final Activity activity, final List list) {
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        if (methodConfiguration != null) {
            for (Task task : list) {
                MethodPackage methodPackage = (MethodPackage)task.eContainer();
                List list2 = methodConfiguration.getMethodPackageSelection();
                if (list2.contains(methodPackage)) continue;
                list2.add(methodPackage);
            }
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                WBSDropCommand wBSDropCommand = new WBSDropCommand(activity, list);
                try {
                    try {
                        wBSDropCommand.execute();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        wBSDropCommand.dispose();
                    }
                }
                finally {
                    wBSDropCommand.dispose();
                }
            }
        });
    }

    public static ProcessComponent getProcessComponent(BreakdownElement breakdownElement) {
        if (breakdownElement.eContainer() == null) {
            Activity activity = breakdownElement.getSuperActivities();
            if (activity == null) {
                return null;
            }
            return PluginServiceImpl.getProcessComponent((BreakdownElement)activity);
        }
        EObject eObject = breakdownElement.eContainer();
        while (eObject != null && !(eObject instanceof ProcessComponent)) {
            eObject = eObject.eContainer();
        }
        if (eObject != null) {
            return (ProcessComponent)eObject;
        }
        return null;
    }

    private void addActivityToContainer(Activity activity) {
        ProcessComponent processComponent = PluginServiceImpl.getProcessComponent((BreakdownElement)activity);
        if (processComponent != null) {
            ProcessPackage processPackage = UmaFactory.eINSTANCE.createProcessPackage();
            processPackage.setName(activity.getName());
            processPackage.setGuid(EcoreUtil.generateUUID());
            processComponent.getChildPackages().add(processPackage);
            processPackage.getProcessElements().add(activity);
        }
    }
}

