/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.validation.Activator;
import org.eclipse.epf.validation.ValidationResources;
import org.eclipse.epf.validation.util.ValidationStatus;
import org.eclipse.osgi.util.NLS;

public class RelationshipConstraint
extends AbstractModelConstraint {
    private static final boolean DEBUG = Activator.getDefault().isDebugging();
    private static final Collection referencesToCheckForCircularDependency = Arrays.asList(UmaPackage.Literals.METHOD_PLUGIN__BASES, UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT, UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS, UmaPackage.Literals.DELIVERABLE__DELIVERED_WORK_PRODUCTS, UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS);

    public IStatus validate(IValidationContext iValidationContext) {
        NamedElement namedElement;
        if (DependencyChecker.newCheck) {
            return Status.OK_STATUS;
        }
        EObject eObject = iValidationContext.getTarget();
        EMFEventType eMFEventType = iValidationContext.getEventType();
        if (DEBUG && eObject instanceof NamedElement) {
            namedElement = (NamedElement)eObject;
            System.out.println("RelationshipConstraint.validate(): " + TngUtil.getTypeText((EObject)namedElement) + ": '" + namedElement.getName() + "'");
        }
        namedElement = new MultiStatus("org.eclipse.epf.validation", 0, "", null);
        if (eMFEventType == EMFEventType.NULL) {
            ArrayList arrayList = new ArrayList(referencesToCheckForCircularDependency);
            arrayList.retainAll((Collection<?>)eObject.eClass().getEAllReferences());
            for (EReference eReference : arrayList) {
                String string;
                Object object2;
                if (eReference.isMany()) {
                    for (Object object2 : (List)eObject.eGet((EStructuralFeature)eReference)) {
                        string = DependencyChecker.checkCircularDependency((EObject)eObject, (EStructuralFeature)eReference, (Object)object2);
                        if (string.isOK()) continue;
                        String string2 = string.getMessage();
                        if (StrUtil.isBlank((String)string2)) {
                            string2 = NLS.bind((String)ValidationResources.circularDependency_error, (Object)eReference.getEContainingClass().getName(), (Object)eReference.getName());
                        }
                        namedElement.add((IStatus)new ValidationStatus(4, 0, string2, eObject, (EStructuralFeature)eReference));
                    }
                    continue;
                }
                Iterator iterator = eObject.eGet((EStructuralFeature)eReference);
                if (iterator == null || (object2 = DependencyChecker.checkCircularDependency((EObject)eObject, (EStructuralFeature)eReference, iterator)).isOK()) continue;
                string = object2.getMessage();
                if (StrUtil.isBlank((String)string)) {
                    string = NLS.bind((String)ValidationResources.circularDependency_error, (Object)eReference.getEContainingClass().getName(), (Object)eReference.getName());
                }
                namedElement.add((IStatus)new ValidationStatus(4, 0, string, eObject, (EStructuralFeature)eReference));
            }
            if (namedElement.isOK()) {
                return iValidationContext.createSuccessStatus();
            }
            return namedElement;
        }
        return iValidationContext.createSuccessStatus();
    }
}

