/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.TriggeredOperations;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringExecutionListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryListener;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.core.refactoring.history.RefactoringExecutionEvent;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistoryEvent;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.UndoableOperation2ChangeAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringDescriptorProxyAdapter;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryManager;
import org.xml.sax.InputSource;

public final class RefactoringHistoryService
implements IRefactoringHistoryService {
    private static RefactoringHistoryService fInstance = null;
    private static final int MAX_UNDO_STACK = 5;
    public static final String NAME_HISTORY_FILE = "refactorings.history";
    public static final String NAME_HISTORY_FOLDER = ".refactorings";
    public static final String NAME_INDEX_FILE = "refactorings.index";
    public static final String NAME_WORKSPACE_PROJECT = ".workspace";
    private static final NullRefactoringHistory NO_HISTORY = new NullRefactoringHistory();
    private static final RefactoringDescriptor NO_REFACTORING = new NoRefactoringDescriptor();
    private final ListenerList fExecutionListeners = new ListenerList(0);
    private final ListenerList fHistoryListeners = new ListenerList(0);
    private IOperationHistoryListener fOperationListener = null;
    private long fOverrideTimeStamp = -1L;
    private LinkedList fRedoQueue = null;
    private int fReferenceCount = 0;
    private IResourceChangeListener fResourceListener = null;
    private RefactoringDescriptorStack fUndoStack = null;

    private static void filterRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, Set set, boolean resolve, int flags, IProgressMonitor monitor) {
        Assert.isTrue((flags > 0 ? 1 : 0) != 0);
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, proxies.length);
            int offset = 0;
            while (offset < proxies.length) {
                int filter;
                RefactoringDescriptor descriptor = proxies[offset].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (descriptor != null && ((filter = descriptor.getFlags()) | flags) == filter) {
                    if (resolve) {
                        set.add(new RefactoringDescriptorProxyAdapter(descriptor));
                    } else {
                        set.add(proxies[offset]);
                    }
                }
                ++offset;
            }
        }
        finally {
            monitor.done();
        }
    }

    public static RefactoringHistoryService getInstance() {
        if (fInstance == null) {
            fInstance = new RefactoringHistoryService();
        }
        return fInstance;
    }

    public static boolean hasSharedRefactoringHistory(IProject project) {
        Assert.isNotNull((Object)project);
        IScopeContext[] contexts = new IScopeContext[]{new ProjectScope(project)};
        String preference = Platform.getPreferencesService().getString(RefactoringCorePlugin.getPluginId(), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.FALSE.toString(), contexts);
        if (preference != null) {
            return Boolean.valueOf(preference);
        }
        return false;
    }

    public static void setSharedRefactoringHistory(IProject project, boolean enable, IProgressMonitor monitor) throws CoreException {
        block16: {
            Assert.isNotNull((Object)project);
            Assert.isTrue((boolean)project.isAccessible());
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask("", 300);
                String name = project.getName();
                URI uri = project.getLocationURI();
                if (uri == null) break block16;
                try {
                    IFileStore history = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(NAME_HISTORY_FOLDER);
                    if (enable) {
                        IFileStore source = history.getChild(name);
                        if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                            IFileStore destination = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                            if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            }
                            destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                    } else {
                        IFileStore source = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                        if (source.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                            IFileStore destination = history.getChild(name);
                            if (destination.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20)).exists()) {
                                destination.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            }
                            destination.mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.copy(destination, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                            source.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                        }
                    }
                }
                finally {
                    if (enable) {
                        project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                    } else {
                        IFolder folder = project.getFolder(NAME_HISTORY_FOLDER);
                        if (folder.exists()) {
                            folder.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        }
                    }
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private RefactoringHistoryService() {
    }

    public void addExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fExecutionListeners.add((Object)listener);
    }

    public void addHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fHistoryListeners.add((Object)listener);
    }

    public void addRefactoringDescriptor(final RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        Assert.isNotNull((Object)proxy);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Object[] listeners = this.fHistoryListeners.getListeners();
            int size = listeners.length;
            monitor.beginTask("", size);
            int index = 0;
            while (index < size) {
                final IRefactoringHistoryListener listener = (IRefactoringHistoryListener)listeners[index];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        RefactoringCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        listener.historyNotification(new RefactoringHistoryEvent(RefactoringHistoryService.this, 4, proxy));
                    }
                });
                monitor.worked(1);
                ++index;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void connect() {
        ++this.fReferenceCount;
        if (this.fReferenceCount == 1) {
            this.fOperationListener = new RefactoringOperationHistoryListener();
            OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.fOperationListener);
            this.fResourceListener = new WorkspaceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fResourceListener, 3);
            this.fUndoStack = new RefactoringDescriptorStack();
            this.fRedoQueue = new LinkedList();
        }
    }

    public void deleteRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, proxies.length + 300);
            HashMap<String, ArrayList<RefactoringDescriptorProxy>> projects = new HashMap<String, ArrayList<RefactoringDescriptorProxy>>();
            int index = 0;
            while (index < proxies.length) {
                ArrayList<RefactoringDescriptorProxy> collection;
                String project = proxies[index].getProject();
                if (project == null || "".equals(project)) {
                    project = NAME_WORKSPACE_PROJECT;
                }
                if ((collection = (ArrayList<RefactoringDescriptorProxy>)projects.get(project)) == null) {
                    collection = new ArrayList<RefactoringDescriptorProxy>();
                    projects.put(project, collection);
                }
                collection.add(proxies[index]);
                monitor.worked(1);
                ++index;
            }
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 300);
            try {
                Set entries = projects.entrySet();
                subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, entries.size());
                Iterator iterator = entries.iterator();
                while (iterator.hasNext()) {
                    RefactoringHistoryManager manager;
                    Map.Entry entry = iterator.next();
                    Collection collection = (Collection)entry.getValue();
                    String project = (String)entry.getKey();
                    if (project.equals(NAME_WORKSPACE_PROJECT)) {
                        project = null;
                    }
                    if ((manager = this.fUndoStack.getManager(project)) != null) {
                        manager.removeRefactoringDescriptors(collection.toArray(new RefactoringDescriptorProxy[collection.size()]), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1), RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings);
                        continue;
                    }
                    subMonitor.worked(1);
                }
            }
            finally {
                subMonitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void deleteRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, IRefactoringDescriptorDeleteQuery query, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)query);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, proxies.length + 300);
            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>(proxies.length);
            int index = 0;
            while (index < proxies.length) {
                if (query.proceed(proxies[index]).isOK()) {
                    set.add(proxies[index]);
                }
                monitor.worked(1);
                ++index;
            }
            if (!set.isEmpty()) {
                RefactoringDescriptorProxy[] delete = set.toArray(new RefactoringDescriptorProxy[set.size()]);
                this.deleteRefactoringDescriptors(delete, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                int index2 = 0;
                while (index2 < delete.length) {
                    this.fireRefactoringDeletedEvent(delete[index2]);
                    ++index2;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void deleteRefactoringHistory(IProject project, IProgressMonitor monitor) throws CoreException {
        block8: {
            Assert.isNotNull((Object)project);
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_deleting_refactorings, 100);
                String name = project.getName();
                IFileStore stateStore = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation());
                if (name.equals(NAME_WORKSPACE_PROJECT)) {
                    IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                    metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    break block8;
                }
                URI uri = project.getLocationURI();
                if (uri == null || !project.isAccessible()) break block8;
                try {
                    IFileStore metaStore = stateStore.getChild(NAME_HISTORY_FOLDER).getChild(name);
                    metaStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    IFileStore projectStore = EFS.getStore((URI)uri).getChild(NAME_HISTORY_FOLDER);
                    projectStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                }
                finally {
                    project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    public void disconnect() {
        if (this.fReferenceCount > 0) {
            this.fUndoStack.fManagerCache.clear();
            --this.fReferenceCount;
        }
        if (this.fReferenceCount == 0) {
            if (this.fOperationListener != null) {
                OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.fOperationListener);
            }
            if (this.fResourceListener != null) {
                ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
            }
            this.fUndoStack = null;
            this.fRedoQueue = null;
            this.fOperationListener = null;
        }
    }

    void fireAboutToPerformEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public final void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 4, proxy));
                }
            });
            ++index;
        }
    }

    void fireAboutToRedoEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 6, proxy));
                }
            });
            ++index;
        }
    }

    void fireAboutToUndoEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 5, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringDeletedEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fHistoryListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringHistoryListener listener = (IRefactoringHistoryListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.historyNotification(new RefactoringHistoryEvent(RefactoringHistoryService.this, 3, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringPerformedEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 1, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringRedoneEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 3, proxy));
                }
            });
            ++index;
        }
    }

    void fireRefactoringUndoneEvent(final RefactoringDescriptorProxy proxy) {
        Assert.isNotNull((Object)proxy);
        Object[] listeners = this.fExecutionListeners.getListeners();
        int index = 0;
        while (index < listeners.length) {
            final IRefactoringExecutionListener listener = (IRefactoringExecutionListener)listeners[index];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable throwable) {
                    RefactoringCorePlugin.log(throwable);
                }

                public void run() throws Exception {
                    listener.executionNotification(new RefactoringExecutionEvent(RefactoringHistoryService.this, 2, proxy));
                }
            });
            ++index;
        }
    }

    public RefactoringHistory getProjectHistory(IProject project, IProgressMonitor monitor) {
        return this.getProjectHistory(project, 0L, Long.MAX_VALUE, 0, monitor);
    }

    public RefactoringHistory getProjectHistory(IProject project, long start, long end, int flags, IProgressMonitor monitor) {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.exists());
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= 0L ? 1 : 0) != 0);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (project.isOpen()) {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 120);
                String name = project.getName();
                RefactoringHistoryManager manager = this.fUndoStack.getManager(name);
                if (manager != null) {
                    RefactoringHistory history = manager.readRefactoringHistory(start, end, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    if (flags > 0) {
                        HashSet set = new HashSet();
                        RefactoringHistoryService.filterRefactoringDescriptors(history.getDescriptors(), set, false, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        history = new RefactoringHistoryImplementation(set.toArray(new RefactoringDescriptorProxy[set.size()]));
                    }
                    RefactoringHistory refactoringHistory = history;
                    return refactoringHistory;
                }
            }
            finally {
                monitor.done();
            }
        }
        return NO_HISTORY;
    }

    public RefactoringHistory getRefactoringHistory(IProject[] projects, IProgressMonitor monitor) {
        return this.getRefactoringHistory(projects, 0L, Long.MAX_VALUE, 0, monitor);
    }

    public RefactoringHistory getRefactoringHistory(IProject[] projects, long start, long end, int flags, IProgressMonitor monitor) {
        Assert.isNotNull((Object)projects);
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int index;
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 3 * projects.length);
            HashSet<RefactoringDescriptorProxy> set = new HashSet<RefactoringDescriptorProxy>();
            if (flags > 0) {
                index = 0;
                while (index < projects.length) {
                    IProject project = projects[index];
                    if (project.isAccessible()) {
                        RefactoringDescriptorProxy[] proxies = this.getProjectHistory(project, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 1)).getDescriptors();
                        RefactoringHistoryService.filterRefactoringDescriptors(proxies, set, false, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                    ++index;
                }
            } else {
                index = 0;
                while (index < projects.length) {
                    IProject project = projects[index];
                    if (project.isAccessible()) {
                        RefactoringDescriptorProxy[] proxies = this.getProjectHistory(project, start, end, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 3)).getDescriptors();
                        int offset = 0;
                        while (offset < proxies.length) {
                            set.add(proxies[offset]);
                            ++offset;
                        }
                    }
                    ++index;
                }
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            RefactoringHistoryImplementation refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            return refactoringHistoryImplementation;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringHistory getWorkspaceHistory(IProgressMonitor monitor) {
        return this.getWorkspaceHistory(0L, Long.MAX_VALUE, monitor);
    }

    public RefactoringHistory getWorkspaceHistory(long start, long end, IProgressMonitor monitor) {
        return this.getRefactoringHistory(ResourcesPlugin.getWorkspace().getRoot().getProjects(), start, end, 0, monitor);
    }

    public RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream) throws CoreException {
        Assert.isNotNull((Object)stream);
        try {
            return RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, null, 0L, Long.MAX_VALUE);
        }
        catch (IOException exception) {
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
        }
    }

    public RefactoringHistory readRefactoringHistory(InputStream stream, int flags) throws CoreException {
        int index;
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>();
        RefactoringSessionDescriptor descriptor = new RefactoringSessionReader(true).readSession(new InputSource(stream));
        if (descriptor != null) {
            RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
            if (flags > 0) {
                index = 0;
                while (index < descriptors.length) {
                    int current = descriptors[index].getFlags();
                    if ((current | flags) == current) {
                        list.add(descriptors[index]);
                    }
                    ++index;
                }
            } else {
                list.addAll(Arrays.asList(descriptors));
            }
        }
        RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[list.size()];
        index = 0;
        while (index < list.size()) {
            proxies[index] = new RefactoringDescriptorProxyAdapter((RefactoringDescriptor)list.get(index));
            ++index;
        }
        return new RefactoringHistoryImplementation(proxies);
    }

    public void removeExecutionListener(IRefactoringExecutionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fExecutionListeners.remove((Object)listener);
    }

    public void removeHistoryListener(IRefactoringHistoryListener listener) {
        Assert.isNotNull((Object)listener);
        this.fHistoryListeners.remove((Object)listener);
    }

    public RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        Assert.isNotNull((Object)proxy);
        Assert.isNotNull((Object)this.fUndoStack);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.fUndoStack.requestDescriptor(proxy, monitor);
    }

    public void setOverrideTimeStamp(long stamp) {
        Assert.isTrue((stamp == -1L || stamp >= 0L ? 1 : 0) != 0);
        this.fOverrideTimeStamp = stamp;
    }

    public void setRefactoringComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxy);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fUndoStack.setComment(proxy, comment, monitor);
    }

    public void writeRefactoringDescriptors(RefactoringDescriptorProxy[] proxies, OutputStream stream, int flags, boolean time, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)proxies);
        Assert.isNotNull((Object)stream);
        Assert.isTrue((flags >= 0 ? 1 : 0) != 0);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 100 * proxies.length);
            this.connect();
            ArrayList<RefactoringDescriptor> list = new ArrayList<RefactoringDescriptor>(proxies.length);
            int index = 0;
            while (index < proxies.length) {
                int current;
                RefactoringDescriptor descriptor = proxies[index].requestDescriptor((IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (descriptor != null && ((current = descriptor.getFlags()) | flags) == current) {
                    list.add(descriptor);
                }
                ++index;
            }
            RefactoringDescriptor[] descriptors = new RefactoringDescriptor[list.size()];
            list.toArray(descriptors);
            RefactoringHistoryManager.writeRefactoringSession(stream, new RefactoringSessionDescriptor(descriptors, "1.0", null), time);
        }
        finally {
            this.disconnect();
        }
    }

    public void writeRefactoringSession(RefactoringSessionDescriptor descriptor, OutputStream stream, boolean time) throws CoreException {
        Assert.isNotNull((Object)descriptor);
        Assert.isNotNull((Object)stream);
        RefactoringHistoryManager.writeRefactoringSession(stream, descriptor, time);
    }

    private static final class NoRefactoringDescriptor
    extends RefactoringDescriptor {
        private NoRefactoringDescriptor() {
            super("org.eclipse.ltk.core.refactoring.none", null, "N/A", null, 0);
        }

        public Refactoring createRefactoring(RefactoringStatus status) throws CoreException {
            return null;
        }
    }

    private static final class NullRefactoringHistory
    extends RefactoringHistory {
        private static final RefactoringDescriptorProxy[] NO_PROXIES = new RefactoringDescriptorProxy[0];

        private NullRefactoringHistory() {
        }

        public RefactoringDescriptorProxy[] getDescriptors() {
            return NO_PROXIES;
        }

        public boolean isEmpty() {
            return true;
        }

        public RefactoringHistory removeAll(RefactoringHistory history) {
            return this;
        }
    }

    private final class RefactoringDescriptorStack {
        private static final int MAX_MANAGERS = 2;
        private final LinkedList fImplementation = new LinkedList();
        private final Map fManagerCache = new LinkedHashMap(this, 2, 0.75f, true){
            private static final long serialVersionUID = 1L;
            final /* synthetic */ RefactoringDescriptorStack this$1;
            {
                this.this$1 = refactoringDescriptorStack;
            }

            protected final boolean removeEldestEntry(Map.Entry entry) {
                return this.size() > 2;
            }
        };

        private RefactoringDescriptorStack() {
        }

        private void checkDescriptor(RefactoringDescriptor descriptor) throws CoreException {
            Map arguments = RefactoringHistoryManager.getArgumentMap(descriptor);
            if (arguments != null) {
                RefactoringHistoryManager.checkArgumentMap(arguments);
            }
        }

        private RefactoringHistoryManager getManager(IFileStore store, String name) {
            Assert.isNotNull((Object)store);
            RefactoringHistoryManager manager = (RefactoringHistoryManager)this.fManagerCache.get(store);
            if (manager == null) {
                manager = new RefactoringHistoryManager(store, name);
                this.fManagerCache.put(store, manager);
            }
            return manager;
        }

        private RefactoringHistoryManager getManager(String name) {
            block6: {
                IFileStore store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER);
                if (name != null && !"".equals(name)) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!project.isAccessible()) break block6;
                        if (RefactoringHistoryService.hasSharedRefactoringHistory(project)) {
                            URI uri = project.getLocationURI();
                            if (uri != null) {
                                return this.getManager(EFS.getStore((URI)uri).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER), name);
                            }
                            break block6;
                        }
                        return this.getManager(store.getChild(name), name);
                    }
                    catch (CoreException coreException) {}
                } else {
                    return this.getManager(store.getChild(RefactoringHistoryService.NAME_WORKSPACE_PROJECT), null);
                }
            }
            return null;
        }

        private RefactoringDescriptor peek() throws EmptyStackException {
            if (!this.fImplementation.isEmpty()) {
                return (RefactoringDescriptor)this.fImplementation.getFirst();
            }
            throw new EmptyStackException();
        }

        private void pop() throws EmptyStackException {
            RefactoringDescriptor descriptor = this.peek();
            if (this.fImplementation.isEmpty()) {
                throw new EmptyStackException();
            }
            this.fImplementation.removeFirst();
            Object[] listeners = RefactoringHistoryService.this.fHistoryListeners.getListeners();
            int index = 0;
            while (index < listeners.length) {
                IRefactoringHistoryListener listener = (IRefactoringHistoryListener)listeners[index];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, listener, descriptor){
                    final /* synthetic */ RefactoringDescriptorStack this$1;
                    private final /* synthetic */ IRefactoringHistoryListener val$listener;
                    private final /* synthetic */ RefactoringDescriptor val$descriptor;
                    {
                        this.this$1 = refactoringDescriptorStack;
                        this.val$listener = iRefactoringHistoryListener;
                        this.val$descriptor = refactoringDescriptor;
                    }

                    public void handleException(Throwable throwable) {
                        RefactoringCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        this.val$listener.historyNotification(new RefactoringHistoryEvent(RefactoringDescriptorStack.access$9(this.this$1), 2, new RefactoringDescriptorProxyAdapter(this.val$descriptor)));
                    }
                });
                ++index;
            }
        }

        private void push(RefactoringDescriptor descriptor) throws CoreException {
            Assert.isNotNull((Object)descriptor);
            try {
                this.checkDescriptor(descriptor);
            }
            catch (CoreException exception) {
                IStatus status = exception.getStatus();
                if (status.getCode() == 10007) {
                    String time = DateFormat.getDateTimeInstance().format(new Date(descriptor.getTimeStamp()));
                    String message = "The refactoring executed at " + time + " contributed a refactoring descriptor with invalid format:";
                    Status comment = new Status(4, RefactoringCorePlugin.getPluginId(), descriptor.getComment());
                    RefactoringCorePlugin.log((IStatus)new MultiStatus(RefactoringCorePlugin.getPluginId(), 0, new IStatus[]{comment}, message, null));
                }
                throw exception;
            }
            this.fImplementation.addFirst(descriptor);
            int size = this.fImplementation.size();
            if (size > 5) {
                this.fImplementation.removeLast();
            }
            Object[] listeners = RefactoringHistoryService.this.fHistoryListeners.getListeners();
            int index = 0;
            while (index < listeners.length) {
                IRefactoringHistoryListener listener = (IRefactoringHistoryListener)listeners[index];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, listener, descriptor){
                    final /* synthetic */ RefactoringDescriptorStack this$1;
                    private final /* synthetic */ IRefactoringHistoryListener val$listener;
                    private final /* synthetic */ RefactoringDescriptor val$descriptor;
                    {
                        this.this$1 = refactoringDescriptorStack;
                        this.val$listener = iRefactoringHistoryListener;
                        this.val$descriptor = refactoringDescriptor;
                    }

                    public void handleException(Throwable throwable) {
                        RefactoringCorePlugin.log(throwable);
                    }

                    public void run() throws Exception {
                        this.val$listener.historyNotification(new RefactoringHistoryEvent(RefactoringDescriptorStack.access$9(this.this$1), 1, new RefactoringDescriptorProxyAdapter(this.val$descriptor)));
                    }
                });
                ++index;
            }
        }

        private RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
            Assert.isNotNull((Object)proxy);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_resolving_information, 6);
                long stamp = proxy.getTimeStamp();
                RefactoringDescriptor descriptor = null;
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 4);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_resolving_information, this.fImplementation.size());
                    Iterator iterator = this.fImplementation.iterator();
                    while (iterator.hasNext()) {
                        subMonitor.worked(1);
                        RefactoringDescriptor existing = (RefactoringDescriptor)iterator.next();
                        long time = existing.getTimeStamp();
                        if (time < 0L || time != stamp) continue;
                        descriptor = existing;
                        break;
                    }
                }
                finally {
                    subMonitor.done();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                monitor.worked(1);
                if (descriptor == null) {
                    RefactoringHistoryManager manager = this.getManager(proxy.getProject());
                    if (manager != null) {
                        descriptor = manager.requestDescriptor(proxy, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        monitor.worked(1);
                    }
                } else {
                    monitor.worked(1);
                }
                RefactoringDescriptor refactoringDescriptor = descriptor;
                return refactoringDescriptor;
            }
            finally {
                monitor.done();
            }
        }

        private void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
            Assert.isNotNull((Object)proxy);
            Assert.isNotNull((Object)comment);
            Assert.isNotNull((Object)monitor);
            try {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 5);
                long stamp = proxy.getTimeStamp();
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 4);
                try {
                    subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, this.fImplementation.size());
                    Iterator iterator = this.fImplementation.iterator();
                    while (iterator.hasNext()) {
                        RefactoringDescriptor descriptor = (RefactoringDescriptor)iterator.next();
                        subMonitor.worked(1);
                        if (descriptor.getTimeStamp() != stamp) continue;
                        descriptor.setComment(comment);
                        break;
                    }
                }
                finally {
                    subMonitor.done();
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                String name = proxy.getProject();
                RefactoringHistoryManager manager = this.getManager(name);
                if (manager != null) {
                    manager.setComment(proxy, comment, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
            }
            finally {
                monitor.done();
            }
        }

        static /* synthetic */ RefactoringHistoryService access$9(RefactoringDescriptorStack refactoringDescriptorStack) {
            return refactoringDescriptorStack.RefactoringHistoryService.this;
        }
    }

    private final class RefactoringOperationHistoryListener
    implements IOperationHistoryListener {
        private RefactoringDescriptor fDescriptor = null;

        private RefactoringOperationHistoryListener() {
        }

        public void historyNotification(OperationHistoryEvent event) {
            IUndoableOperation operation = event.getOperation();
            if (operation instanceof TriggeredOperations) {
                operation = ((TriggeredOperations)operation).getTriggeringOperation();
            }
            UndoableOperation2ChangeAdapter adapter = null;
            if (operation instanceof UndoableOperation2ChangeAdapter) {
                adapter = (UndoableOperation2ChangeAdapter)operation;
            }
            if (adapter != null) {
                Change change = adapter.getChange();
                switch (event.getEventType()) {
                    case 1: {
                        this.fDescriptor = null;
                        ChangeDescriptor changeDescriptor = change.getDescriptor();
                        if (!(changeDescriptor instanceof RefactoringChangeDescriptor)) break;
                        this.fDescriptor = ((RefactoringChangeDescriptor)changeDescriptor).getRefactoringDescriptor();
                        RefactoringHistoryService.this.fireAboutToPerformEvent(new RefactoringDescriptorProxyAdapter(this.fDescriptor));
                        break;
                    }
                    case 4: {
                        try {
                            if (this.fDescriptor != null) {
                                if (!this.fDescriptor.getID().equals("org.eclipse.ltk.core.refactoring.unknown")) {
                                    if (RefactoringHistoryService.this.fOverrideTimeStamp >= 0L) {
                                        this.fDescriptor.setTimeStamp(RefactoringHistoryService.this.fOverrideTimeStamp);
                                    } else {
                                        this.fDescriptor.setTimeStamp(System.currentTimeMillis());
                                    }
                                }
                                RefactoringHistoryService.this.fUndoStack.push(this.fDescriptor);
                                RefactoringHistoryService.this.fireRefactoringPerformedEvent(new RefactoringDescriptorProxyAdapter(this.fDescriptor));
                                this.fDescriptor = null;
                                break;
                            }
                            RefactoringHistoryService.this.fUndoStack.push(NO_REFACTORING);
                        }
                        catch (CoreException exception) {
                            try {
                                RefactoringHistoryService.this.fUndoStack.push(NO_REFACTORING);
                            }
                            catch (CoreException coreException) {
                                Assert.isLegal((boolean)false);
                            }
                            RefactoringCorePlugin.log(exception);
                        }
                        break;
                    }
                    case 3: {
                        RefactoringDescriptor descriptor = RefactoringHistoryService.this.fUndoStack.peek();
                        if (descriptor == NO_REFACTORING) break;
                        RefactoringHistoryService.this.fireAboutToUndoEvent(new RefactoringDescriptorProxyAdapter(descriptor));
                        break;
                    }
                    case 10: {
                        RefactoringHistoryService.this.fRedoQueue.addFirst(RefactoringHistoryService.this.fUndoStack.peek());
                        RefactoringHistoryService.this.fUndoStack.pop();
                        RefactoringDescriptor descriptor = (RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.getFirst();
                        if (descriptor == NO_REFACTORING) break;
                        RefactoringHistoryService.this.fireRefactoringUndoneEvent(new RefactoringDescriptorProxyAdapter(descriptor));
                        break;
                    }
                    case 2: {
                        RefactoringDescriptor descriptor = (RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.getFirst();
                        if (descriptor == NO_REFACTORING) break;
                        RefactoringHistoryService.this.fireAboutToRedoEvent(new RefactoringDescriptorProxyAdapter(descriptor));
                        break;
                    }
                    case 9: {
                        try {
                            RefactoringHistoryService.this.fUndoStack.push((RefactoringDescriptor)RefactoringHistoryService.this.fRedoQueue.removeFirst());
                            RefactoringDescriptor descriptor = RefactoringHistoryService.this.fUndoStack.peek();
                            if (descriptor == NO_REFACTORING) break;
                            RefactoringHistoryService.this.fireRefactoringRedoneEvent(new RefactoringDescriptorProxyAdapter(descriptor));
                            break;
                        }
                        catch (CoreException coreException) {}
                    }
                }
            }
        }
    }

    private final class WorkspaceChangeListener
    implements IResourceChangeListener {
        private WorkspaceChangeListener() {
        }

        private void moveHistory(IProject oldProject, IProject newProject, IProgressMonitor monitor) {
            try {
                try {
                    RefactoringDescriptor descriptor;
                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 60);
                    IFileStore historyStore = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(RefactoringHistoryService.NAME_HISTORY_FOLDER);
                    String oldName = oldProject.getName();
                    String newName = newProject.getName();
                    IFileStore oldStore = historyStore.getChild(oldName);
                    if (oldStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                        IFileStore newStore = historyStore.getChild(newName);
                        if (newStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 10, 2)).exists()) {
                            newStore.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
                        }
                        oldStore.move(newStore, 2, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2));
                    }
                    Iterator iterator = RefactoringHistoryService.this.fUndoStack.fImplementation.iterator();
                    while (iterator.hasNext()) {
                        descriptor = (RefactoringDescriptor)iterator.next();
                        if (!oldName.equals(descriptor.getProject())) continue;
                        descriptor.setProject(newName);
                    }
                    iterator = RefactoringHistoryService.this.fRedoQueue.iterator();
                    while (iterator.hasNext()) {
                        descriptor = (RefactoringDescriptor)iterator.next();
                        if (!oldName.equals(descriptor.getProject())) continue;
                        descriptor.setProject(newName);
                    }
                }
                catch (CoreException exception) {
                    RefactoringCorePlugin.log(exception);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta[] deltas;
            IResourceDelta delta;
            int type = event.getType();
            if ((type & 1) != 0 && (delta = event.getDelta()) != null && (deltas = delta.getAffectedChildren()).length == 2) {
                IPath toPath = deltas[0].getMovedToPath();
                IPath fromPath = deltas[1].getMovedFromPath();
                if (fromPath != null && toPath != null) {
                    IResource oldResource = deltas[0].getResource();
                    IResource newResource = deltas[1].getResource();
                    if (oldResource.getType() == 4 && newResource.getType() == 4) {
                        this.moveHistory((IProject)oldResource, (IProject)newResource, (IProgressMonitor)new NullProgressMonitor());
                    }
                } else if (deltas[0].getKind() == 1 && deltas[1].getKind() == 2) {
                    IResource newResource = deltas[0].getResource();
                    IResource oldResource = deltas[1].getResource();
                    if (oldResource.getType() == 4 && newResource.getType() == 4) {
                        this.moveHistory((IProject)oldResource, (IProject)newResource, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }
    }
}

