/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.JoinNode;

public final class BridgeHelper {
    public static final String UMA_ELEMENT = "uma_element";
    public static final String UMA_URI = "uri";
    public static final String UMA_TYPE = "type";
    public static final String UMA_PHASE = "Phase";
    public static final String UMA_ITERATION = "Iteration";
    public static final String UMA_ACTIVITY = "Activity";
    public static final String UMA_TASK_DESCRIPTOR = "Task";
    public static final String UMA_MILESTONE = "Milestone";
    public static final String ANNOTATION_INHERIRED = "inherited";
    public static List<IElementType> elementTypes = new ArrayList<IElementType>();
    public static Map<String, EClass> typeStringToEClass = new HashMap<String, EClass>();
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();

    static {
        typeStringToEClass.put(UMA_PHASE, UmaPackage.Literals.PHASE);
        typeStringToEClass.put(UMA_ITERATION, UmaPackage.Literals.ITERATION);
        typeStringToEClass.put(UMA_ACTIVITY, UmaPackage.Literals.ACTIVITY);
        typeStringToEClass.put(UMA_TASK_DESCRIPTOR, UmaPackage.Literals.TASK_DESCRIPTOR);
        typeStringToEClass.put(UMA_MILESTONE, UmaPackage.Literals.MILESTONE);
    }

    public static void setSemanticModel(ActivityEdge activityEdge, WorkOrder workOrder) {
    }

    public static boolean isReadOnly(View view) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(view.getElement());
        if (nodeAdapter != null) {
            return nodeAdapter.isTargetReadOnly();
        }
        if (view.getElement() instanceof Node) {
            return ((Node)view.getElement()).isReadOnly();
        }
        return false;
    }

    public static MethodElement getMethodElement(View view) {
        return BridgeHelper.getMethodElement(view.getElement());
    }

    public static MethodElement getMethodElement(EObject eObject) {
        if (eObject instanceof LinkedObject) {
            return ((LinkedObject)eObject).getLinkedElement();
        }
        if (eObject instanceof EModelElement) {
            return BridgeHelper.getMethodElement((EModelElement)eObject);
        }
        return null;
    }

    public static MethodElement getMethodElement(View view, org.eclipse.epf.uma.Activity activity) {
        Resource resource;
        EObject eObject = view.getElement();
        if (eObject instanceof LinkedObject) {
            return ((LinkedObject)eObject).getLinkedElement();
        }
        if (eObject instanceof EModelElement && (resource = activity.eResource()) != null && resource.getResourceSet() != null) {
            return BridgeHelper.getMethodElementFromAnnotation((EModelElement)eObject, resource.getResourceSet());
        }
        return null;
    }

    public static boolean isSuppressed(View view) {
        NodeAdapter nodeAdapter;
        EObject eObject = view.getElement();
        if (eObject instanceof NamedNode) {
            return ((NamedNode)eObject).isSuppressed();
        }
        if (eObject instanceof EModelElement && (nodeAdapter = BridgeHelper.getNodeAdapter(eObject)) != null) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = nodeAdapter.getWrapper();
            if (breakdownElementWrapperItemProvider == null) {
                breakdownElementWrapperItemProvider = nodeAdapter.getElement();
            }
            org.eclipse.epf.uma.Activity activity = (org.eclipse.epf.uma.Activity)BridgeHelper.getMethodElement((View)view.getDiagram());
            Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
            Suppression suppression = Suppression.getSuppression((Process)process);
            return suppression.isSuppressed((Object)breakdownElementWrapperItemProvider);
        }
        return false;
    }

    public static void removeLink(ActivityEdge activityEdge) {
        Activity activity = activityEdge.getActivity();
        ActivityNode activityNode = activityEdge.getSource();
        ActivityNode activityNode2 = activityEdge.getTarget();
        boolean bl = activityNode != null ? activityNode.eDeliver() : false;
        boolean bl2 = activityNode2 != null ? activityNode2.eDeliver() : false;
        try {
            if (activityNode != null) {
                activityNode.eSetDeliver(false);
            }
            if (activityNode2 != null) {
                activityNode2.eSetDeliver(false);
            }
            activityEdge.setSource(null);
            activityEdge.setTarget(null);
            if (activity != null) {
                activity.getEdges().remove((Object)activityEdge);
            }
        }
        finally {
            if (activityNode != null) {
                activityNode.eSetDeliver(bl);
            }
            if (activityNode2 != null) {
                activityNode2.eSetDeliver(bl2);
            }
        }
    }

    public static ActivityNode findNode(Activity activity, Object object, boolean bl) {
        for (ActivityNode activityNode : activity.getNodes()) {
            MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode);
            if (object == methodElement) {
                return activityNode;
            }
            if (!bl || !(methodElement instanceof VariabilityElement)) continue;
            VariabilityElement variabilityElement = ((VariabilityElement)methodElement).getVariabilityBasedOnElement();
            while (variabilityElement != null) {
                if (variabilityElement == object) {
                    return activityNode;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
        }
        return null;
    }

    public static boolean isSynchBar(ActivityNode activityNode) {
        return activityNode instanceof ForkNode || activityNode instanceof JoinNode;
    }

    public static ActivityNode findNode(Activity activity, Object object) {
        for (ActivityNode activityNode : activity.getNodes()) {
            if (object != BridgeHelper.getMethodElement((EModelElement)activityNode)) continue;
            return activityNode;
        }
        return null;
    }

    public static URI getProxyURI(MethodElement methodElement) {
        Resource resource = methodElement.eResource();
        if (resource instanceof ILibraryResource) {
            return ((ILibraryResource)resource).getProxyURI((EObject)methodElement);
        }
        if (resource != null) {
            return resource.getURI().appendFragment(methodElement.getGuid());
        }
        return null;
    }

    public static boolean associate(EModelElement eModelElement, MethodElement methodElement) {
        EAnnotation eAnnotation = BridgeHelper.addEAnnotation(eModelElement, methodElement);
        if (eAnnotation != null) {
            String string = BridgeHelper.getType(methodElement);
            if (string != null) {
                eAnnotation.getDetails().put((Object)UMA_TYPE, (Object)string);
            }
            return true;
        }
        return false;
    }

    public static EClass getType(String string) {
        return typeStringToEClass.get(string);
    }

    public static String getType(MethodElement methodElement) {
        if (methodElement instanceof Phase) {
            return UMA_PHASE;
        }
        if (methodElement instanceof Iteration) {
            return UMA_ITERATION;
        }
        if (methodElement instanceof Milestone) {
            return UMA_MILESTONE;
        }
        if (methodElement instanceof org.eclipse.epf.uma.Activity) {
            return UMA_ACTIVITY;
        }
        if (methodElement instanceof TaskDescriptor) {
            return UMA_TASK_DESCRIPTOR;
        }
        return null;
    }

    public static EAnnotation addEAnnotation(EModelElement eModelElement, MethodElement methodElement) {
        URI uRI = BridgeHelper.getProxyURI(methodElement);
        if (uRI != null) {
            EAnnotation eAnnotation = eModelElement.getEAnnotation(UMA_ELEMENT);
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(UMA_ELEMENT);
                eModelElement.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getDetails().put((Object)UMA_URI, (Object)uRI.toString());
            return eAnnotation;
        }
        return null;
    }

    private static Activity getActivity(EModelElement eModelElement) {
        EModelElement eModelElement2 = eModelElement;
        while (eModelElement2 != null && !(eModelElement2 instanceof Activity)) {
            eModelElement2 = eModelElement2.eContainer();
        }
        return (Activity)eModelElement2;
    }

    public static MethodElement getMethodElementFromAnnotation(EModelElement eModelElement, ResourceSet resourceSet) {
        String string;
        EAnnotation eAnnotation = eModelElement.getEAnnotation(UMA_ELEMENT);
        if (eAnnotation != null && (string = (String)eAnnotation.getDetails().get((Object)UMA_URI)) != null) {
            EObject eObject = resourceSet.getEObject(URI.createURI((String)string), false);
            if (eObject instanceof MethodElement) {
                return (MethodElement)eObject;
            }
            if (DEBUG) {
                System.err.println("Not a method element: " + eObject);
            }
        }
        return null;
    }

    public static MethodElement getMethodElementFromAnnotation(EModelElement eModelElement) {
        Activity activity = BridgeHelper.getActivity(eModelElement);
        if (activity == null) {
            return null;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activity);
        if (nodeAdapter == null || nodeAdapter.getElement() == null) {
            return null;
        }
        Resource resource = nodeAdapter.getElement().eResource();
        if (resource != null && resource.getResourceSet() != null) {
            return BridgeHelper.getMethodElementFromAnnotation(eModelElement, resource.getResourceSet());
        }
        return null;
    }

    public static MethodElement getMethodElement(EModelElement eModelElement) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)eModelElement);
        return nodeAdapter != null ? nodeAdapter.getElement() : BridgeHelper.getMethodElementFromAnnotation(eModelElement);
    }

    public static NodeAdapter getNodeAdapter(EObject eObject) {
        if (eObject != null) {
            for (Object e : eObject.eAdapters()) {
                if (!(e instanceof NodeAdapter)) continue;
                return (NodeAdapter)((Object)e);
            }
        }
        return null;
    }

    public static DiagramAdapter getDiagramAdapter(EObject eObject) {
        for (Object e : eObject.eAdapters()) {
            if (!(e instanceof DiagramAdapter)) continue;
            return (DiagramAdapter)((Object)e);
        }
        return null;
    }

    public static void getSyncBarSourceNodes(ActivityNode activityNode, Collection collection) {
        for (ActivityEdge activityEdge : activityNode.getIncomings()) {
            ActivityNode activityNode2 = activityEdge.getSource();
            if (BridgeHelper.getMethodElement((EModelElement)activityNode2) instanceof WorkBreakdownElement) {
                collection.add(activityNode2);
                continue;
            }
            if (!BridgeHelper.isSynchBar(activityNode2)) continue;
            BridgeHelper.getSyncBarSourceNodes(activityNode2, collection);
        }
    }

    public static void getTargetNodes(Collection collection, ActivityNode activityNode, Class clazz) {
        if (activityNode != null) {
            for (ActivityEdge activityEdge : activityNode.getOutgoings()) {
                ActivityNode activityNode2 = activityEdge.getTarget();
                if (clazz.isInstance(BridgeHelper.getMethodElement((EModelElement)activityNode2))) {
                    collection.add(activityNode2);
                    continue;
                }
                if (!(activityNode2 instanceof ControlNode)) continue;
                BridgeHelper.getTargetNodes(collection, activityNode2, clazz);
            }
        }
    }

    public static void getSourceNodes(Collection collection, ActivityNode activityNode, Class clazz) {
        if (activityNode != null) {
            for (ActivityEdge activityEdge : activityNode.getIncomings()) {
                ActivityNode activityNode2 = activityEdge.getSource();
                if (clazz.isInstance(BridgeHelper.getMethodElement((EModelElement)activityNode2))) {
                    collection.add(activityNode2);
                    continue;
                }
                if (!(activityNode2 instanceof ControlNode)) continue;
                BridgeHelper.getSourceNodes(collection, activityNode2, clazz);
            }
        }
    }

    public static void getSyncBarTargetNodes(ActivityNode activityNode, Collection collection) {
        for (ActivityEdge activityEdge : activityNode.getOutgoings()) {
            ActivityNode activityNode2 = activityEdge.getTarget();
            if (BridgeHelper.getMethodElement((EModelElement)activityNode2) instanceof WorkBreakdownElement) {
                collection.add(activityNode2);
                continue;
            }
            if (!BridgeHelper.isSynchBar(activityNode2)) continue;
            BridgeHelper.getSyncBarTargetNodes(activityNode2, collection);
        }
    }

    public static boolean canRemoveAllPreds(ActivityEdge activityEdge, ActivityNode activityNode, ActivityNode activityNode2) {
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode2);
        if (methodElement instanceof WorkBreakdownElement) {
            EList eList = activityNode2.getIncomings();
            for (ActivityEdge activityEdge2 : eList) {
                if (BridgeHelper.isSynchBar(activityEdge2.getSource())) {
                    ArrayList arrayList = new ArrayList();
                    BridgeHelper.getSourceNodes(arrayList, activityEdge2.getSource(), WorkBreakdownElement.class);
                    if (!arrayList.contains(activityNode)) continue;
                    return false;
                }
                if (activityEdge2.getSource() == null || !(BridgeHelper.getMethodElement((EModelElement)activityEdge2.getSource()) instanceof WorkBreakdownElement) || !activityEdge2.getSource().equals(activityNode)) continue;
                return false;
            }
        }
        return true;
    }

    public static void markInherited(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(ANNOTATION_INHERIRED);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(ANNOTATION_INHERIRED);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        }
    }

    public static void unmarkInHerited(EModelElement eModelElement) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(ANNOTATION_INHERIRED);
        if (eAnnotation != null) {
            eModelElement.getEAnnotations().remove((Object)eAnnotation);
        }
    }

    public static Diagram copyDiagram(Diagram diagram) {
        Diagram diagram2 = (Diagram)EcoreUtil.copy((EObject)diagram);
        EList eList = diagram2.getChildren();
        int n = eList.size();
        int n2 = 0;
        while (n2 < n) {
            View view = (View)eList.get(n2);
            BridgeHelper.markInherited((EModelElement)view);
            ++n2;
        }
        return diagram2;
    }

    public static EList addEAnnotationDetail(EModelElement eModelElement, String string, String string2) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(UMA_ELEMENT);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(UMA_ELEMENT);
            eAnnotation.getDetails().put((Object)UMA_TYPE, (Object)string2);
            eModelElement.getEAnnotations().add((Object)eAnnotation);
        } else {
            eAnnotation.getDetails().put((Object)UMA_TYPE, (Object)string2);
        }
        return eModelElement.getEAnnotations();
    }

    public static EList addEAnnotationType(EModelElement eModelElement, String string) {
        EClass eClass;
        ActivityNode activityNode;
        MethodElement methodElement;
        EList eList = BridgeHelper.addEAnnotationDetail(eModelElement, UMA_TYPE, string);
        if (eModelElement instanceof ActivityNode && (methodElement = BridgeHelper.getMethodElement((EModelElement)(activityNode = (ActivityNode)eModelElement))) instanceof BreakdownElement && string != null && !string.equals(BridgeHelper.getType(methodElement)) && (eClass = BridgeHelper.getType(string)) != null) {
            BreakdownElement breakdownElement = (BreakdownElement)UmaFactory.eINSTANCE.create(eClass);
            org.eclipse.epf.uma.Activity activity = ((BreakdownElement)methodElement).getSuperActivities();
            if (activity != null) {
                Object object;
                List list = activity.getBreakdownElements();
                list.set(list.indexOf(methodElement), breakdownElement);
                ProcessPackage processPackage = (ProcessPackage)activity.eContainer();
                if (processPackage != null) {
                    processPackage.getProcessElements().add(breakdownElement);
                    object = processPackage.getChildPackages();
                    if (!object.isEmpty()) {
                        for (ProcessPackage processPackage2 : processPackage.getChildPackages()) {
                            List list2 = processPackage2.getProcessElements();
                            if (list2.isEmpty() || !list2.contains(methodElement)) continue;
                            list2.set(list2.indexOf(methodElement), breakdownElement);
                        }
                    }
                }
                BridgeHelper.associate((EModelElement)activityNode, (MethodElement)breakdownElement);
                object = BridgeHelper.getNodeAdapter((EObject)activityNode);
                if (object != null) {
                    ((NodeAdapter)((Object)object)).dispose();
                }
                DiagramAdapter diagramAdapter = (DiagramAdapter)BridgeHelper.getNodeAdapter((EObject)activityNode.getActivity());
                diagramAdapter.addNodeAdapterTo(activityNode);
            }
        }
        return eList;
    }

    public static String getEAnnotationType(EModelElement eModelElement, String string) {
        return BridgeHelper.getEAnnotationDetail(eModelElement, string);
    }

    public static String getEAnnotationDetail(EModelElement eModelElement, String string) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(UMA_ELEMENT);
        if (eAnnotation != null) {
            return (String)eAnnotation.getDetails().get((Object)string);
        }
        return null;
    }

    public static String getType(ActivityNode activityNode) {
        return BridgeHelper.getEAnnotationDetail((EModelElement)activityNode, UMA_TYPE);
    }

    public static String getType(BreakdownElement breakdownElement) {
        if (breakdownElement instanceof Iteration) {
            return UMA_ITERATION;
        }
        if (breakdownElement instanceof Phase) {
            return UMA_PHASE;
        }
        if (breakdownElement instanceof org.eclipse.epf.uma.Activity) {
            return UMA_ACTIVITY;
        }
        if (breakdownElement instanceof Milestone) {
            return UMA_MILESTONE;
        }
        if (breakdownElement instanceof TaskDescriptor) {
            return UMA_TASK_DESCRIPTOR;
        }
        return null;
    }

    public static boolean isInherited(EModelElement eModelElement) {
        String string;
        EAnnotation eAnnotation = eModelElement.getEAnnotation(ANNOTATION_INHERIRED);
        return eAnnotation != null && (string = eAnnotation.getSource()) != null && string.length() > 0;
    }

    private static EClass getEClassFromType(String string) {
        if (UMA_ACTIVITY.equals(string)) {
            return UmaPackage.eINSTANCE.getActivity();
        }
        if (UMA_ITERATION.equals(string)) {
            return UmaPackage.eINSTANCE.getIteration();
        }
        if (UMA_MILESTONE.equals(string)) {
            return UmaPackage.eINSTANCE.getMilestone();
        }
        if (UMA_PHASE.equals(string)) {
            return UmaPackage.eINSTANCE.getPhase();
        }
        if (UMA_TASK_DESCRIPTOR.equals(string)) {
            return UmaPackage.eINSTANCE.getTaskDescriptor();
        }
        return null;
    }

    public static void setDefaultName(ActivityNode activityNode) {
        Activity activity = activityNode.getActivity();
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activity);
        MethodElement methodElement2 = BridgeHelper.getMethodElement((EModelElement)activityNode);
        int n = methodElement2.eClass().getClassifierID();
        org.eclipse.epf.uma.Activity activity2 = (org.eclipse.epf.uma.Activity)methodElement;
        ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>();
        for (BreakdownElement breakdownElement : activity2.getBreakdownElements()) {
            if (breakdownElement.eClass().getClassifierID() != n) continue;
            arrayList.add(breakdownElement);
        }
        String string = MessageFormat.format(DiagramResources.defaultBaseName, TngUtil.getTypeText((String)methodElement2.eClass().getName()));
        TngUtil.setDefaultName(arrayList, (MethodElement)methodElement2, (String)string);
        activityNode.setName(methodElement2.getName());
    }

    public static View getView(View view, Object object) {
        for (View view2 : view.getChildren()) {
            if (view2.getElement() == object) {
                return view2;
            }
            if (!(view2.getElement() instanceof ActivityPartition)) continue;
            for (View view3 : view2.getChildren()) {
                if (view3.getElement() != object) continue;
                return view2;
            }
        }
        return null;
    }

    public static String getNodeName(MethodElement methodElement) {
        if (methodElement instanceof BreakdownElement) {
            return ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)methodElement));
        }
        if (methodElement instanceof DescribableElement) {
            return ((DescribableElement)methodElement).getPresentationName();
        }
        return methodElement.getName();
    }
}

