/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.StructuredActivityNode;

public class CopyDiagramCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection elements;
    private Map copyToOriginalMap;
    private Collection<Diagram> copiedElements;
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private Process targetProcess;
    private DiagramManager mgr;
    private InternalTransactionalEditingDomain domain;
    private boolean forDeepCopy;

    public CopyDiagramCommand(Collection collection, Map map, Process process) {
        this(collection, map, process, false);
    }

    public CopyDiagramCommand(Collection collection, Map map, Process process, boolean bl) {
        this.elements = collection;
        this.copyToOriginalMap = map;
        this.targetProcess = process;
        this.forDeepCopy = bl;
        this.mgr = DiagramManager.getInstance(process, (Object)this);
        this.domain = this.mgr.getEditingDomain();
    }

    public void execute() {
        try {
            TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                public void run() {
                    CopyDiagramCommand.this.doExecute();
                }
            });
        }
        catch (ExecutionException executionException) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)executionException);
        }
    }

    public void redo() {
        this.execute();
    }

    private void doExecute() {
        if (this.copiedElements == null) {
            this.copiedElements = new ArrayList<Diagram>();
        } else {
            this.copiedElements.clear();
        }
        DiagramService diagramService = new DiagramService();
        try {
            try {
                for (Object e : this.elements) {
                    Object v = this.copyToOriginalMap.get(e);
                    if (v == null || !(v instanceof Activity) || e == null || !(e instanceof Activity)) continue;
                    Activity activity = (Activity)e;
                    Activity activity2 = (Activity)v;
                    Collection<Diagram> collection = diagramService.getDiagrams(activity2);
                    if (collection == null || collection.isEmpty()) continue;
                    for (Diagram diagram : collection) {
                        if (diagram == null) continue;
                        Diagram diagram2 = DiagramHelper.copyDiagram((EditingDomain)this.domain, diagram);
                        this.updateReferences(diagram2);
                        int n = DiagramHelper.getDiagramType(diagram2);
                        this.mgr.associate(diagram2, n, activity);
                        this.copiedElements.add(diagram2);
                    }
                }
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                if (DEBUG) {
                    exception.printStackTrace();
                }
                diagramService.dispose();
            }
        }
        finally {
            diagramService.dispose();
        }
    }

    private void clearReadOnly(Node node) {
        node.setReadOnly(false);
        if (node instanceof NodeContainer) {
            for (Node node2 : ((NodeContainer)node).getNodes()) {
                node2.setReadOnly(false);
            }
        }
    }

    public void updateReferences(Diagram diagram) {
        int n = DiagramHelper.getDiagramType(diagram);
        for (org.eclipse.gmf.runtime.notation.Node node : diagram.getChildren()) {
            EModelElement eModelElement;
            MethodElement methodElement;
            Object object;
            EObject eObject = node.getElement();
            if (n == 0) {
                if (!(eObject instanceof StructuredActivityNode) && !(eObject instanceof ActivityParameterNode) || (object = this.getCopiedElement(this.copyToOriginalMap, methodElement = BridgeHelper.getMethodElementFromAnnotation(eModelElement = (EModelElement)eObject, this.targetProcess.eResource().getResourceSet()))) == null) continue;
                BridgeHelper.addEAnnotation(eModelElement, (MethodElement)object);
                continue;
            }
            if (n == 2) {
                if (this.forDeepCopy && eObject instanceof Node) {
                    this.clearReadOnly((Node)eObject);
                }
                if (!(eObject instanceof NodeContainer)) continue;
                eModelElement = (NodeContainer)eObject;
                methodElement = eModelElement.getLinkedElement();
                object = this.getCopiedElement(this.copyToOriginalMap, methodElement);
                if (object != null) {
                    eModelElement.setLinkedElement((MethodElement)object);
                }
                EList eList = eModelElement.getNodes();
                int n2 = 0;
                while (n2 < eList.size()) {
                    NamedNode namedNode = (NamedNode)eList.get(n2);
                    methodElement = namedNode.getLinkedElement();
                    object = this.getCopiedElement(this.copyToOriginalMap, methodElement);
                    if (object != null) {
                        namedNode.setLinkedElement((MethodElement)object);
                    }
                    ++n2;
                }
                continue;
            }
            if (n != 1) continue;
            if (this.forDeepCopy && eObject instanceof Node) {
                this.clearReadOnly((Node)eObject);
            }
            if (!(eObject instanceof NamedNode) || (object = this.getCopiedElement(this.copyToOriginalMap, methodElement = (eModelElement = (NamedNode)eObject).getLinkedElement())) == null) continue;
            eModelElement.setLinkedElement((MethodElement)object);
        }
    }

    private Object getCopiedElement(Map map, Object object) {
        Set set = map.keySet();
        for (Object k : set) {
            Object v = map.get(k);
            if (!v.equals(object)) continue;
            return k;
        }
        return null;
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        block3: {
            if (this.copiedElements != null && !this.copiedElements.isEmpty()) {
                try {
                    TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                for (Diagram diagram : CopyDiagramCommand.this.copiedElements) {
                                    CopyDiagramCommand.this.mgr.getResource().getContents().remove((Object)diagram.getElement());
                                    CopyDiagramCommand.this.mgr.getResource().getContents().remove((Object)diagram);
                                }
                            }
                            catch (CoreException coreException) {
                                throw new WrappedException((Exception)((Object)coreException));
                            }
                        }
                    });
                    this.copiedElements.clear();
                }
                catch (Exception exception) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                    if (!DEBUG) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    public Collection getModifiedResources() {
        if (this.copiedElements == null || this.copiedElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Resource> hashSet = new HashSet<Resource>();
        for (Diagram diagram : this.copiedElements) {
            if (diagram == null || diagram.eResource() == null) continue;
            hashSet.add(diagram.eResource());
        }
        return hashSet;
    }

    public void dispose() {
        if (this.mgr != null) {
            this.mgr.removeConsumer((Object)this);
        }
        super.dispose();
    }
}

