/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.DiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.diagram.core.resources.IDiagramStorage;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DiagramEditorUtil {
    private static final String AD_EDITOR_ID = "org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorID";
    private static final String ADD_EDITOR_ID = "org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorID";
    private static final String WPDD_EDITOR_ID = "org.eclipse.epf.diagram.wpdd.part.WorkProductDependencyDiagramEditorID";

    private static String getEditorId(int n) {
        switch (n) {
            case 0: {
                return AD_EDITOR_ID;
            }
            case 2: {
                return ADD_EDITOR_ID;
            }
            case 1: {
                return WPDD_EDITOR_ID;
            }
        }
        return null;
    }

    public static IEditorPart openDiagramEditor(IWorkbenchPage iWorkbenchPage, DiagramEditorInput diagramEditorInput, PreferencesHint preferencesHint, IProgressMonitor iProgressMonitor) {
        DiagramEditorInputProxy diagramEditorInputProxy = new DiagramEditorInputProxy(diagramEditorInput, preferencesHint);
        IEditorPart iEditorPart = null;
        try {
            iEditorPart = iWorkbenchPage.openEditor((IEditorInput)diagramEditorInputProxy, DiagramEditorUtil.getEditorId(diagramEditorInput.getDiagramType()), true);
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
        if (iEditorPart instanceof AbstractDiagramEditor) {
            DiagramManager diagramManager;
            if (diagramEditorInput.getDiagramType() == 2) {
                ((AbstractDiagramEditor)iEditorPart).resetLayout();
            }
            IDocumentProvider iDocumentProvider = ((DiagramDocumentEditor)iEditorPart).getDocumentProvider();
            Process process = TngUtil.getOwningProcess((Object)diagramEditorInput.getMethodElement());
            if (process != null) {
                diagramManager = null;
                Object object = new Object();
                try {
                    diagramManager = DiagramManager.getInstance(process, object);
                    if (diagramManager != null && diagramEditorInputProxy.isNewDiagram()) {
                        iDocumentProvider.setCanSaveDocument((Object)diagramEditorInputProxy);
                    }
                }
                finally {
                    if (diagramManager != null) {
                        diagramManager.removeConsumer(object);
                    }
                }
            }
            if (iDocumentProvider instanceof SharedResourceDiagramDocumentProvider && iEditorPart.isDirty() && !diagramEditorInputProxy.isNewDiagram()) {
                ((SharedResourceDiagramDocumentProvider)iDocumentProvider).markDocumentAsSaved(diagramEditorInputProxy);
            }
            if (!DiagramEditorUtil.isModifiable(diagramEditorInputProxy)) {
                ((SharedResourceDiagramDocumentProvider)((AbstractDiagramEditor)iEditorPart).getDocumentProvider()).lock(true);
                diagramManager = ((IDiagramWorkbenchPart)iEditorPart).getDiagramEditPart();
                diagramManager.disableEditMode();
            }
        }
        return iEditorPart;
    }

    public static void refreshVisual(DiagramEditPart diagramEditPart) {
        AbstractTreeIterator<Object> abstractTreeIterator = new AbstractTreeIterator<Object>((Object)diagramEditPart, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<?> getChildren(Object object) {
                if (object instanceof EditPart) {
                    return ((EditPart)object).getChildren().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            Object e = abstractTreeIterator.next();
            if (!(e instanceof ITextAwareEditPart) && !(e instanceof ConnectionNodeEditPart)) continue;
            ((EditPart)e).refresh();
        }
    }

    public static void refreshLabels(DiagramEditPart diagramEditPart) {
        AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(diagramEditPart, false){

            protected Iterator getChildren(Object object) {
                if (object instanceof EditPart) {
                    return ((EditPart)object).getChildren().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (abstractTreeIterator.hasNext()) {
            Object e = abstractTreeIterator.next();
            if (!(e instanceof ITextAwareEditPart)) continue;
            ((ITextAwareEditPart)e).refresh();
        }
    }

    private static Diagram getDiagram(DiagramEditorInputProxy diagramEditorInputProxy) throws CoreException {
        IStorage iStorage = diagramEditorInputProxy.getStorage();
        return iStorage instanceof IDiagramStorage ? ((IDiagramStorage)iStorage).getDiagram() : null;
    }

    private static boolean doInitialize(final DiagramEditorInputProxy diagramEditorInputProxy, IProgressMonitor iProgressMonitor) throws CoreException {
        final Diagram diagram = DiagramEditorUtil.getDiagram(diagramEditorInputProxy);
        if (diagram == null) {
            return false;
        }
        if ("AD".equals(diagram.getType())) {
            ActivityDiagramAdapter activityDiagramAdapter = (ActivityDiagramAdapter)BridgeHelper.getNodeAdapter(diagram.getElement());
            if (activityDiagramAdapter == null) {
                activityDiagramAdapter = new ActivityDiagramAdapter((Activity)diagramEditorInputProxy.getDiagramEditorInput().getMethodElement());
                activityDiagramAdapter.setEditingDomain((InternalTransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)diagram));
                activityDiagramAdapter.setSuppression(diagramEditorInputProxy.getDiagramEditorInput().getSuppression());
                activityDiagramAdapter.setView((View)diagram);
                diagram.getElement().eAdapters().add((Object)activityDiagramAdapter);
            }
            activityDiagramAdapter.populateDiagram();
            return true;
        }
        if ("ADD".equals(diagram.getType()) || "WPDD".equals(diagram.getType())) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            AbstractEMFOperation abstractEMFOperation = new AbstractEMFOperation(transactionalEditingDomain, ""){

                protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    org.eclipse.epf.diagram.model.Diagram diagram2 = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                    DiagramEditorInput diagramEditorInput = diagramEditorInputProxy.getDiagramEditorInput();
                    diagram2.setSuppression(diagramEditorInput.getSuppression());
                    diagram2.setLinkedElement(diagramEditorInput.getMethodElement());
                    diagram2.setObject((Object)diagram2.getLinkedElement());
                    return Status.OK_STATUS;
                }
            };
            try {
                abstractEMFOperation.execute(iProgressMonitor, null);
                return true;
            }
            catch (ExecutionException executionException) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
            }
        }
        return false;
    }

    public static void initializeOnActivate(DiagramEditPart diagramEditPart) {
        IEditorPart iEditorPart;
        if (diagramEditPart.getViewer() instanceof IDiagramEditorInputProvider && (iEditorPart = ((IDiagramEditorInputProvider)diagramEditPart.getViewer()).getEditor()).getEditorInput() instanceof DiagramEditorInputProxy) {
            DiagramEditorInputProxy diagramEditorInputProxy = (DiagramEditorInputProxy)iEditorPart.getEditorInput();
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            try {
                if (DiagramEditorUtil.doInitialize(diagramEditorInputProxy, (IProgressMonitor)nullProgressMonitor)) {
                    DiagramEditorUtil.doRefresh(diagramEditPart, (IProgressMonitor)nullProgressMonitor, false);
                    DiagramEditorUtil.refreshVisual(diagramEditPart);
                }
            }
            catch (CoreException coreException) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
    }

    public static void initialize(DiagramEditPart diagramEditPart, DiagramEditorInputProxy diagramEditorInputProxy, IProgressMonitor iProgressMonitor) {
        try {
            if (DiagramEditorUtil.doInitialize(diagramEditorInputProxy, iProgressMonitor)) {
                DiagramEditorUtil.refresh(diagramEditPart, iProgressMonitor);
                DiagramEditorUtil.refreshLabels(diagramEditPart);
            }
        }
        catch (CoreException coreException) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)coreException);
        }
    }

    private static void updateEdges(View view) {
        boolean bl = false;
        for (View view2 : view.getChildren()) {
            FontStyle fontStyle;
            if (!(view2.getElement() instanceof NodeImpl)) continue;
            NodeImpl nodeImpl = (NodeImpl)view2.getElement();
            if (!nodeImpl.isVisible()) {
                DiagramEditorUtil.setEdgeVisibility(view, nodeImpl.isVisible());
            } else {
                view2.setVisible(nodeImpl.isVisible());
                DiagramEditorUtil.setEdgeVisibility(view2, true);
            }
            if (nodeImpl instanceof NamedNode && (fontStyle = (FontStyle)view2.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
                fontStyle = (FontStyle)view2.createStyle(NotationPackage.Literals.FONT_STYLE);
            }
            if (view2.isVisible() && view2.getElement() instanceof NodeContainer) {
                DiagramEditorUtil.updateEdges(view2);
            }
            if (!nodeImpl.isVisible()) continue;
            bl = true;
        }
        if (view.getElement() instanceof NodeContainer && !(view.getElement() instanceof ActivityDetailDiagram) && !(view.getElement() instanceof WorkProductDependencyDiagram)) {
            DiagramEditorUtil.setEdgeVisibility(view, bl);
        }
    }

    private static void setEdgeVisibility(View view, boolean bl) {
        Diagram diagram = view.getDiagram();
        for (Edge edge : diagram.getEdges()) {
            if (edge.getSource() != view && edge.getTarget() != view) continue;
            if (bl) {
                view.setVisible(true);
            }
            edge.setVisible(bl);
        }
    }

    private static void updateView(View view) {
        boolean bl = false;
        for (View view2 : view.getChildren()) {
            FontStyle fontStyle;
            if (!(view2.getElement() instanceof NodeImpl)) continue;
            NodeImpl nodeImpl = (NodeImpl)view2.getElement();
            view2.setVisible(nodeImpl.isVisible());
            if (nodeImpl instanceof NamedNode && (fontStyle = (FontStyle)view2.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
                fontStyle = (FontStyle)view2.createStyle(NotationPackage.Literals.FONT_STYLE);
            }
            if (view2.isVisible() && view2.getElement() instanceof NodeContainer) {
                DiagramEditorUtil.updateView(view2);
            }
            if (!nodeImpl.isVisible()) continue;
            bl = true;
        }
        if (view.getElement() instanceof NodeContainer && !(view.getElement() instanceof ActivityDetailDiagram) && !(view.getElement() instanceof WorkProductDependencyDiagram)) {
            view.setVisible(bl);
        }
    }

    public static boolean isInherited(EditPart editPart) {
        EditPartViewer editPartViewer = editPart.getViewer();
        if (editPartViewer instanceof IDiagramEditorInputProvider) {
            DiagramEditorInput diagramEditorInput = ((IDiagramEditorInputProvider)editPartViewer).getDiagramEditorInput();
            return DiagramEditorUtil.isInherited(diagramEditorInput);
        }
        return false;
    }

    private static boolean isInherited(DiagramEditorInput diagramEditorInput) {
        return diagramEditorInput != null && diagramEditorInput.getWrapper() != null && diagramEditorInput.getWrapper().isInherited();
    }

    private static Collection getSemanticChildren(DiagramEditPart diagramEditPart) {
        Object object;
        DiagramEditorInput diagramEditorInput;
        EditPartViewer editPartViewer = diagramEditPart.getViewer();
        if (editPartViewer instanceof IDiagramEditorInputProvider && (diagramEditorInput = ((IDiagramEditorInputProvider)editPartViewer).getDiagramEditorInput()) != null && diagramEditorInput.getWrapper() != null && diagramEditorInput.getWrapper().isInherited() && (object = diagramEditPart.getModel()) instanceof View) {
            Collection collection = null;
            Diagram diagram = diagramEditPart.getDiagramView();
            String string = diagram.getType();
            if ("AD".equals(string)) {
                DiagramAdapter diagramAdapter = (DiagramAdapter)BridgeHelper.getNodeAdapter(diagram.getElement());
                if (diagramAdapter != null) {
                    Object object2;
                    BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = diagramEditorInput.getWrapper();
                    if (TngUtil.getBestAdapterFactory((AdapterFactory)breakdownElementWrapperItemProvider.getAdapterFactory()) != TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()) {
                        object2 = ProcessUtil.getWrappers((BreakdownElementWrapperItemProvider)breakdownElementWrapperItemProvider, (AdapterFactory[])new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()});
                        breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object2.get(0);
                    }
                    object2 = null;
                    try {
                        object2 = new ActivityDiagramAdapter(breakdownElementWrapperItemProvider);
                        ((DiagramAdapter)((Object)object2)).setFilter(diagramAdapter.getFilter());
                        ((DiagramAdapter)((Object)object2)).setSuppression(Suppression.getSuppression((Process)TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)breakdownElementWrapperItemProvider)));
                        collection = ((ActivityDiagramAdapter)((Object)object2)).getChildren();
                    }
                    finally {
                        if (object2 != null) {
                            ((DiagramAdapter)((Object)object2)).dispose();
                        }
                    }
                }
            } else if ("ADD".equals(string) || "WPDD".equals(string)) {
                DiagramImpl diagramImpl = "ADD".equals(string) ? (DiagramImpl)ModelFactory.eINSTANCE.createActivityDetailDiagram() : (DiagramImpl)ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
                DiagramImpl diagramImpl2 = (DiagramImpl)diagram.getElement();
                Suppression suppression = diagramImpl2.getSuppression();
                if (suppression != null) {
                    diagramImpl.setWrapper(diagramEditorInput.getWrapper());
                    diagramImpl.setFilter(diagramImpl2.getFilter());
                    diagramImpl.setSuppression(diagramImpl2.getSuppression());
                    collection = diagramImpl.getChildren();
                }
            }
            return collection;
        }
        return null;
    }

    public static void refreshConnections(DiagramEditPart diagramEditPart) {
        Diagram diagram = diagramEditPart.getDiagramView();
        for (Edge edge : diagram.getEdges()) {
            boolean bl;
            boolean bl2 = bl = edge.getSource() != null && edge.getSource().isVisible() && edge.getTarget() != null && edge.getTarget().isVisible();
            if (edge.isVisible() == bl) continue;
            edge.setVisible(bl);
        }
    }

    private static void refreshChildren(DiagramEditPart diagramEditPart) {
        Collection collection = DiagramEditorUtil.getSemanticChildren(diagramEditPart);
        if (collection != null) {
            DiagramEditorUtil.refreshChildren((EditPart)diagramEditPart, collection);
            DiagramEditorUtil.refreshConnections(diagramEditPart);
        }
    }

    public static void filterChildren(EditPart editPart, Collection collection) {
        DiagramEditPart diagramEditPart = DiagramCoreUtil.getDiagramEditPart(editPart);
        Collection collection2 = DiagramEditorUtil.getSemanticChildren(diagramEditPart);
        if (collection2 == null) {
            collection.clear();
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                MethodElement methodElement = BridgeHelper.getMethodElement(eObject);
                if (DiagramEditorUtil.getWrapper(methodElement, collection2) != null) continue;
                iterator.remove();
            }
        }
    }

    private static Object getWrapper(MethodElement methodElement, Collection collection) {
        for (Object e : collection) {
            if (TngUtil.unwrap(e) != methodElement) continue;
            return e;
        }
        return null;
    }

    private static void refreshChildren(EditPart editPart, Collection collection) {
        for (Object e : editPart.getChildren()) {
            View view;
            MethodElement methodElement;
            if (!(e instanceof EditPart)) continue;
            boolean bl = true;
            EditPart editPart2 = (EditPart)e;
            Object object = editPart2.getModel();
            if (object instanceof View && (methodElement = BridgeHelper.getMethodElement(view = (View)object)) != null) {
                boolean bl2;
                Object object2 = DiagramEditorUtil.getWrapper(methodElement, collection);
                boolean bl3 = bl2 = object2 != null;
                if (view.isVisible() != bl2) {
                    view.setVisible(bl2);
                }
                if (!bl2) {
                    bl = false;
                }
            }
            if (!bl) continue;
            DiagramEditorUtil.refreshChildren(editPart2, collection);
        }
    }

    private static void doRefresh(final DiagramEditPart diagramEditPart, IProgressMonitor iProgressMonitor, final boolean bl) {
        final boolean bl2 = DiagramEditorUtil.isInherited((EditPart)diagramEditPart);
        final Diagram diagram = (Diagram)diagramEditPart.getModel();
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            AbstractEMFOperation abstractEMFOperation = new AbstractEMFOperation(transactionalEditingDomain, ""){

                protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    if (bl) {
                        org.eclipse.epf.diagram.model.Diagram diagram2 = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                        diagram2.setObject((Object)diagram2.getLinkedElement());
                    }
                    if (bl2) {
                        DiagramEditorUtil.refreshChildren(diagramEditPart);
                    } else {
                        DiagramEditorUtil.updateEdges((View)diagram);
                        DiagramEditorUtil.updateView((View)diagram);
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                abstractEMFOperation.execute(iProgressMonitor, null);
            }
            catch (ExecutionException executionException) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
            }
        } else {
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(diagram.getElement());
            if (nodeAdapter instanceof DiagramAdapter) {
                if (bl) {
                    ((DiagramAdapter)nodeAdapter).populateDiagram();
                }
                if (bl2) {
                    try {
                        new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)diagram), ""){

                            protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                                DiagramEditorUtil.refreshChildren(diagramEditPart);
                                return Status.OK_STATUS;
                            }
                        }.execute(iProgressMonitor, null);
                    }
                    catch (ExecutionException executionException) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)executionException);
                    }
                }
            }
        }
    }

    public static void refresh(DiagramEditPart diagramEditPart, IProgressMonitor iProgressMonitor) {
        IDiagramEditorInputProvider iDiagramEditorInputProvider = (IDiagramEditorInputProvider)diagramEditPart.getViewer();
        boolean bl = iDiagramEditorInputProvider.getEditor().isDirty();
        boolean bl2 = false;
        IEditorPart iEditorPart = null;
        boolean bl3 = DiagramEditorUtil.isInherited((EditPart)diagramEditPart);
        if (bl3) {
            MethodElement methodElement = BridgeHelper.getMethodElement((View)diagramEditPart.getDiagramView());
            String string = diagramEditPart.getDiagramView().getType();
            IEditorReference[] iEditorReferenceArray = iDiagramEditorInputProvider.getEditor().getSite().getPage().getEditorReferences();
            int n = 0;
            while (n < iEditorReferenceArray.length) {
                IEditorReference iEditorReference = iEditorReferenceArray[n];
                try {
                    IEditorPart iEditorPart2;
                    DiagramEditorInput diagramEditorInput;
                    if (iEditorReference.getEditorInput() instanceof IDiagramFileEditorInputProxy && (diagramEditorInput = ((IDiagramFileEditorInputProxy)iEditorReference.getEditorInput()).getDiagramEditorInput()).getWrapper() == null && diagramEditorInput.getMethodElement() == methodElement && DiagramManager.getDiagramType(string) == diagramEditorInput.getDiagramType() && (iEditorPart2 = iEditorReference.getEditor(false)) != null) {
                        bl2 = iEditorPart2.isDirty();
                        iEditorPart = iEditorPart2;
                        break;
                    }
                }
                catch (PartInitException partInitException) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)partInitException);
                }
                ++n;
            }
        }
        DiagramEditorUtil.doRefresh(diagramEditPart, iProgressMonitor, true);
        if (!bl && iDiagramEditorInputProvider.getEditor().isDirty()) {
            ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)iDiagramEditorInputProvider.getEditor()).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)iDiagramEditorInputProvider.getEditor().getEditorInput());
        }
        if (iEditorPart != null && !bl2) {
            ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)iEditorPart).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)iEditorPart.getEditorInput());
        }
    }

    public static void refresh(final DiagramEditPart diagramEditPart, IProgressMonitor iProgressMonitor, boolean bl) {
        final boolean bl2 = DiagramEditorUtil.isInherited((EditPart)diagramEditPart);
        final Diagram diagram = (Diagram)diagramEditPart.getModel();
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
            AbstractEMFOperation abstractEMFOperation = new AbstractEMFOperation(transactionalEditingDomain, ""){

                protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                    org.eclipse.epf.diagram.model.Diagram diagram2 = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                    diagram2.setObject((Object)diagram2.getLinkedElement());
                    if (bl2) {
                        DiagramEditorUtil.refreshChildren(diagramEditPart);
                    } else {
                        DiagramEditorUtil.updateEdges((View)diagram);
                        DiagramEditorUtil.updateView((View)diagram);
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                abstractEMFOperation.execute(iProgressMonitor, null);
            }
            catch (ExecutionException executionException) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)executionException);
            }
        } else {
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter(diagram.getElement());
            if (nodeAdapter instanceof DiagramAdapter) {
                ((DiagramAdapter)nodeAdapter).populateDiagram();
                if (bl2) {
                    try {
                        new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)diagram), ""){

                            protected IStatus doExecute(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                                DiagramEditorUtil.refreshChildren(diagramEditPart);
                                return Status.OK_STATUS;
                            }
                        }.execute(iProgressMonitor, null);
                    }
                    catch (ExecutionException executionException) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)executionException);
                    }
                }
            }
        }
    }

    public static void resetEditor(AbstractDiagramEditor abstractDiagramEditor) {
        if (abstractDiagramEditor.isEditable()) {
            DiagramEditPart diagramEditPart = abstractDiagramEditor.getDiagramEditPart();
            IEditorInput iEditorInput = abstractDiagramEditor.getEditorInput();
            if (iEditorInput instanceof DiagramEditorInputProxy) {
                DiagramEditorUtil.initialize(diagramEditPart, (DiagramEditorInputProxy)iEditorInput, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public static boolean isModifiable(Object object) {
        DiagramEditorInput diagramEditorInput;
        DiagramFileEditorInputProxy diagramFileEditorInputProxy;
        if (object instanceof DiagramFileEditorInputProxy && (diagramFileEditorInputProxy = (DiagramFileEditorInputProxy)object) != null && (diagramEditorInput = diagramFileEditorInputProxy.getDiagramEditorInput()) != null) {
            MethodElement methodElement = diagramEditorInput.getMethodElement();
            if (methodElement != null && TngUtil.isLocked((EObject)methodElement)) {
                return false;
            }
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = diagramEditorInput.getWrapper();
            if (breakdownElementWrapperItemProvider != null && breakdownElementWrapperItemProvider.isReadOnly()) {
                return false;
            }
        }
        return true;
    }

    public static void refreshConnectionEditParts(DiagramEditPart diagramEditPart) {
        block9: {
            org.eclipse.gef.ConnectionEditPart connectionEditPart;
            GraphicalViewer graphicalViewer = (GraphicalViewer)diagramEditPart.getViewer();
            Diagram diagram = (Diagram)diagramEditPart.getModel();
            EList eList = diagram.getEdges();
            for (Edge edge : eList) {
                Object object;
                if (!edge.isVisible() || (connectionEditPart = (org.eclipse.gef.ConnectionEditPart)graphicalViewer.getEditPartRegistry().get(edge)) == null) continue;
                if (connectionEditPart.getSource() == null) {
                    for (EditPart editPart : diagramEditPart.getChildren()) {
                        object = editPart.getModel();
                        if (edge.getSource() != object || !(editPart instanceof GraphicalEditPart)) continue;
                        if (((GraphicalEditPart)editPart).getFigure().isVisible()) {
                            connectionEditPart.setSource(editPart);
                            continue;
                        }
                        connectionEditPart.setSource(null);
                    }
                }
                if (connectionEditPart.getTarget() != null) continue;
                for (EditPart editPart : diagramEditPart.getChildren()) {
                    object = editPart.getModel();
                    if (edge.getTarget() != object || !(editPart instanceof GraphicalEditPart)) continue;
                    if (((GraphicalEditPart)editPart).getFigure().isVisible()) {
                        connectionEditPart.setTarget(editPart);
                        continue;
                    }
                    connectionEditPart.setTarget(null);
                }
            }
            try {
                for (Edge edge : eList) {
                    connectionEditPart = (ConnectionEditPart)graphicalViewer.getEditPartRegistry().get(edge);
                    if (connectionEditPart == null || connectionEditPart.getSource() != null && connectionEditPart.getTarget() != null || connectionEditPart.getFigure() == null) continue;
                    connectionEditPart.getFigure().setVisible(false);
                    connectionEditPart.getFigure().revalidate();
                    connectionEditPart.deactivate();
                }
            }
            catch (Exception exception) {
                if (!DiagramCorePlugin.getDefault().isDebugging()) break block9;
                DiagramCorePlugin.getDefault().getLogger().logError("Error occured while refresh the connection: " + exception);
                exception.printStackTrace();
            }
        }
    }
}

