/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.epf.export.msp.ExportMSPOptions;
import org.eclipse.epf.export.msp.ExportMSPService;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.IExportMSPService;
import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.export.msp.ui.ExportMSPUIResources;
import org.eclipse.epf.export.msp.ui.wizards.SelectExportDirectoryPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectExportOptionsPage;
import org.eclipse.epf.export.msp.ui.wizards.SelectPublishingOptionsPage;
import org.eclipse.epf.library.ui.wizards.SelectProcessPage;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportMSPWizard
extends BaseWizard
implements IExportWizard {
    public static final String WIZARD_ID = ExportMSPWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.export.msp.ui.exportMSPWizard";
    protected SelectProcessPage selectProcessPage;
    protected SelectExportOptionsPage selectExportOptionsPage;
    protected SelectPublishingOptionsPage selectPublishingOptionsPage;
    protected SelectExportDirectoryPage selectExportDirPage;
    protected ExportMSPOptions exportOptions = new ExportMSPOptions();

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(ExportMSPUIResources.exportMSPWizard_title);
    }

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.selectProcessPage = new SelectProcessPage();
            this.selectExportOptionsPage = new SelectExportOptionsPage();
            this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
            this.selectExportDirPage = new SelectExportDirectoryPage();
            super.addPage((IWizardPage)this.selectProcessPage);
            super.addPage((IWizardPage)this.selectExportOptionsPage);
            super.addPage((IWizardPage)this.selectPublishingOptionsPage);
            super.addPage((IWizardPage)this.selectExportDirPage);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IWizardPage iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectProcessPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectProcessPage = new SelectProcessPage();
                arrayList.add(this.selectProcessPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectExportOptionsPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectExportOptionsPage = new SelectExportOptionsPage();
                arrayList.add((Object)this.selectExportOptionsPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectPublishingOptionsPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectPublishingOptionsPage = new SelectPublishingOptionsPage();
                arrayList.add((Object)this.selectPublishingOptionsPage);
            }
            iWizardPage = this.wizardExtender.getReplaceWizardPage(SelectExportDirectoryPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.selectExportDirPage = new SelectExportDirectoryPage();
                arrayList.add((Object)this.selectExportDirPage);
            }
            super.getNewWizardPages(arrayList);
            for (IWizardPage iWizardPage2 : arrayList) {
                super.addPage(iWizardPage2);
            }
            this.wizardExtender.initWizardPages(arrayList);
        }
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(ExportMSPUIPlugin.getDefault().getSharedImage("full/obj16/MSProject.gif"));
    }

    public boolean canFinish() {
        if (this.wizardExtender != null) {
            return this.wizardExtender.canFinish();
        }
        return this.getContainer().getCurrentPage() == this.selectExportDirPage && this.selectExportDirPage.isPageComplete();
    }

    public boolean doFinish() {
        return this.exportMSP(this.selectProcessPage.getProcess(), this.getExportOptions(), (IExportMSPService)ExportMSPService.getInstance());
    }

    public boolean exportMSP(Process process, ExportMSPOptions exportMSPOptions, IExportMSPService iExportMSPService) {
        boolean bl;
        Object object;
        block12: {
            if (process == null || exportMSPOptions == null || iExportMSPService == null) {
                throw new IllegalArgumentException();
            }
            try {
                boolean bl2;
                object = exportMSPOptions.getMethodConfiguration();
                if (object == null) {
                    throw new IllegalArgumentException("exportOptions.getMethodConfiguration()");
                }
                if (!exportMSPOptions.getPublishWebSite()) break block12;
                if (this.selectPublishingOptionsPage != null) {
                    this.selectPublishingOptionsPage.savePreferences();
                }
                if (PublishingUtil.hasValidProcessView((MethodConfiguration)object, (Process)process) || (bl2 = ExportMSPUIPlugin.getDefault().getMsgDialog().displayPrompt(ExportMSPUIResources.exportMSPWizard_title, ExportMSPUIResources.missingProcessContentWarning_msg))) break block12;
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.displayIllegalArgumentError(illegalArgumentException.getMessage());
                return true;
            }
        }
        File file = exportMSPOptions.getExportDir();
        if (file == null) {
            throw new IllegalArgumentException("exportOptions.getExportDir()");
        }
        String string = exportMSPOptions.getMSProjectName();
        if (string == null) {
            throw new IllegalArgumentException("exportOptions.getMSProjectName()");
        }
        object = String.valueOf(string) + ".xml";
        File file2 = new File(file, (String)object);
        if (file2.exists() && !(bl = ExportMSPUIPlugin.getDefault().getMsgDialog().displayPrompt(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.overwriteText_msg, (Object[])new String[]{object, file.getAbsolutePath()})))) {
            return false;
        }
        try {
            bl = iExportMSPService.exportMSProject(process, exportMSPOptions);
            if (bl) {
                ExportMSPUIPlugin.getDefault().getMsgDialog().displayInfo(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.completedText_msg, (Object[])new String[]{process.getName(), file2.getAbsolutePath()}));
            }
        }
        catch (ExportMSPServiceException exportMSPServiceException) {
            ExportMSPUIPlugin.getDefault().getMsgDialog().displayError(ExportMSPUIResources.exportMSPWizard_title, NLS.bind((String)ExportMSPUIResources.exportMSPError_msg, (Object[])new String[]{process.getName(), file2.getAbsolutePath()}), ExportMSPUIResources.exportMSPError_reason, (Throwable)exportMSPServiceException);
        }
        return true;
    }

    public SelectProcessPage getSelectProcessPage() {
        return this.selectProcessPage;
    }

    public SelectExportOptionsPage getExportOptionsPage() {
        return this.selectExportOptionsPage;
    }

    public SelectPublishingOptionsPage selectPublishingOptionsPage() {
        return this.selectPublishingOptionsPage;
    }

    public SelectExportDirectoryPage getSelectExportDirectoryPage() {
        return this.selectExportDirPage;
    }

    public ExportMSPOptions getExportOptions() {
        this.exportOptions.setMethodConfiguration(this.selectExportOptionsPage.getMethodConfiguration());
        this.exportOptions.setExportDir(new File(this.selectExportDirPage.getExportDirectory()));
        this.exportOptions.setMSProjectName(this.selectExportDirPage.getMSProjectName());
        this.exportOptions.setExportOnlyPlannedWBSElements(this.selectExportOptionsPage.getExportOnlyPlannedWBSElementsSelection());
        if (this.selectExportOptionsPage.getPublishWebSiteSelection()) {
            PublishOptions publishOptions = this.selectPublishingOptionsPage.getPublishingOptions();
            boolean bl = this.selectExportOptionsPage.getPublishConfigSelection();
            boolean bl2 = this.selectExportOptionsPage.getPublishProcessSelection();
            publishOptions.setPublishConfiguration(bl);
            publishOptions.setPublishProcess(bl2);
            this.exportOptions.setPublishWebSite(publishOptions != null && (bl || bl2));
            this.exportOptions.setPublishingOptions(publishOptions);
        } else {
            this.exportOptions.setPublishWebSite(false);
            this.exportOptions.setPublishingOptions(null);
        }
        return this.exportOptions;
    }

    protected void displayIllegalArgumentError(String string) {
        String string2 = NLS.bind((String)ExportMSPUIResources.illegalArgument_msg, (Object[])new String[]{string});
        ExportMSPUIPlugin.getDefault().getMsgDialog().displayError(ExportMSPUIResources.exportMSPWizard_title, ExportMSPUIResources.exportMSPInternalError_msg, ExportMSPUIResources.exportMSPError_reason, (Throwable)new IllegalArgumentException(string2));
    }
}

