/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final int LINE_SEP_LENGTH = LINE_SEP.length();
    public static final String UNC_PATH_PREFIX = "\\\\";
    public static final int UNC_PATH_PREFIX_LENGTH = "\\\\".length();
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";

    private FileUtil() {
    }

    public static String getAbsolutePath(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    public static String getAbsolutePath(String string) {
        return FileUtil.getAbsolutePath(new File(string));
    }

    public static String getAbsolutePath(URL uRL) {
        String string = uRL.getFile().substring(1);
        String string2 = NetUtil.decodeUrl(string, null);
        return string2;
    }

    public static String getParentDirectory(String string) {
        return new File(string).getParent();
    }

    public static String getFileName(String string) {
        return FileUtil.getFileName(string, true);
    }

    public static String getFileName(String string, boolean bl) {
        String string2 = string.replace('\\', '/');
        int n = 0;
        if (string2.startsWith("file:/")) {
            n = NetUtil.FILE_URI_PREFIX_LENGTH;
        } else if (string2.startsWith("http://")) {
            n = NetUtil.HTTP_URI_PREFIX_LENGTH;
        }
        int n2 = string2.lastIndexOf("/");
        String string3 = n2 < n ? string2.substring(n) : string.substring(n2 + 1);
        if (bl) {
            return string3;
        }
        n2 = string3.indexOf(".");
        return n2 > 0 ? string3.substring(0, n2) : string3;
    }

    public static String getRelativePathToBase(File file, File file2) {
        try {
            String string = file.toURL().toExternalForm();
            String string2 = file2.toURL().toExternalForm();
            StringBuffer stringBuffer = new StringBuffer();
            if (string.indexOf(string2) == 0) {
                String string3 = string.substring(string2.length());
                int n = 0;
                while (n < string3.length()) {
                    if (string3.charAt(n) == '/') {
                        stringBuffer.append("../");
                    }
                    ++n;
                }
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getRelativePath(File file, File file2) {
        try {
            String string = file.toURL().toExternalForm();
            String string2 = FileUtil.appendSeparator(file2.toURL().toExternalForm(), "/");
            StringBuffer stringBuffer = new StringBuffer();
            while (string.indexOf(string2) == -1) {
                file2 = file2.getParentFile();
                string2 = FileUtil.appendSeparator(file2.toURL().toExternalForm(), "/");
                stringBuffer.append("../");
            }
            if (string.indexOf(string2) == 0) {
                String string3 = string.substring(string2.length());
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String appendSeparator(String string) {
        return FileUtil.appendSeparator(string, File.separator);
    }

    public static String appendSeparator(String string, String string2) {
        return string.endsWith(string2) ? string : String.valueOf(string) + string2;
    }

    public static String removeSeparator(String string) {
        return string.endsWith(File.separator) ? string.substring(0, string.length() - 1) : string;
    }

    public static String removeAllSeparator(String string) {
        return string.endsWith("/") || string.endsWith("\\") ? string.substring(0, string.length() - 1) : string;
    }

    public static String removeSeparator(String string, String string2) {
        return string.endsWith(string2) ? string.substring(0, string.length() - 1) : string;
    }

    public static String replaceFileName(String string, String string2, String string3) {
        int n = string.lastIndexOf(string2);
        return String.valueOf(string.substring(0, n)) + string3;
    }

    public static String replaceExtension(String string, String string2, String string3) {
        int n = string.lastIndexOf(string2);
        return String.valueOf(string.substring(0, n)) + string3;
    }

    public static String getLocalePath(String string, String string2) {
        if (StrUtil.isBlank(string2)) {
            return string;
        }
        String string3 = FileUtil.getFileName(string);
        return FileUtil.replaceFileName(string, string3, String.valueOf(string2) + "/" + string3);
    }

    public static String getLocalePath(String string, Locale locale) {
        return locale == null ? string : FileUtil.getLocalePath(string, locale.toString());
    }

    public static boolean writeFile(String string, String string2) {
        block14: {
            FileWriter fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(string);
                    fileWriter.write(string2);
                    fileWriter.flush();
                }
                catch (IOException iOException) {
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean writeUTF8File(String string, String string2) {
        return FileUtil.writeUTF8File(string, string2, false);
    }

    public static boolean writeUTF8File(String string, String string2, boolean bl) {
        block23: {
            OutputStreamWriter outputStreamWriter = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    fileOutputStream = new FileOutputStream(string, bl);
                    outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, ENCODING_UTF_8);
                    outputStreamWriter.write(string2);
                    outputStreamWriter.flush();
                    fileOutputStream.flush();
                }
                catch (IOException iOException) {
                    CommonPlugin.getDefault().getLogger().logError(iOException);
                    if (outputStreamWriter != null) {
                        try {
                            outputStreamWriter.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                    return true;
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static void writeFile(String string, OutputStream outputStream) throws IOException {
        if (string == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            int n;
            inputStream = NetUtil.getInputStream(string);
            byte[] byArray = new byte[4096];
            while ((n = inputStream.read(byArray, 0, 4096)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeFile(String string, PrintWriter printWriter) throws IOException {
        if (string == null) {
            return;
        }
        InputStreamReader inputStreamReader = null;
        try {
            int n;
            inputStreamReader = new InputStreamReader(NetUtil.getInputStream(string));
            char[] cArray = new char[4096];
            while ((n = inputStreamReader.read(cArray, 0, 4096)) > 0) {
                printWriter.write(cArray, 0, n);
            }
            printWriter.flush();
        }
        catch (Throwable throwable) {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (inputStreamReader != null) {
            try {
                inputStreamReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean deleteAllFiles(String string) {
        boolean bl = true;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    bl = bl && FileUtil.deleteAllFiles(fileArray[n].getAbsolutePath());
                }
                bl = bl && fileArray[n].delete();
                ++n;
            }
        }
        return bl;
    }

    public static boolean deleteAllFiles(String string, List<File> list) {
        boolean bl = true;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (!list.contains(fileArray[n])) {
                    if (fileArray[n].isDirectory()) {
                        bl = bl && FileUtil.deleteAllFiles(fileArray[n].getAbsolutePath(), list);
                    }
                    bl = bl && fileArray[n].delete();
                }
                ++n;
            }
        }
        return bl;
    }

    public static boolean copyFile(File file, File file2) {
        try {
            return FileUtil.copyfile(file, file2);
        }
        catch (IOException iOException) {
            CommonPlugin.getDefault().getLogger().logError(iOException);
            return false;
        }
    }

    public static boolean copyFile(String string, String string2) {
        return FileUtil.copyFile(new File(string), new File(string2));
    }

    private static boolean copyfile(File file, File file2) throws IOException {
        if (file.equals(file2)) {
            return false;
        }
        if (!file.exists() || !file.canRead()) {
            return false;
        }
        if (file2.exists() && !file2.canWrite()) {
            return false;
        }
        if (file.isDirectory()) {
            if (file2.isFile()) {
                return false;
            }
            return FileUtil.copydirectory(file, file2);
        }
        if (file2.isDirectory()) {
            String string = file.getName();
            return FileUtil.copyfile(file, new File(file2, string));
        }
        boolean bl = true;
        if (file2.exists()) {
            boolean bl2 = bl = file2.lastModified() != file.lastModified() || file2.length() != file.length();
        }
        if (bl) {
            FileOutputStream fileOutputStream;
            block22: {
                FileInputStream fileInputStream = null;
                fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(file);
                    FileChannel fileChannel = fileInputStream.getChannel();
                    if (!file2.exists()) {
                        file2.getParentFile().mkdirs();
                    }
                    fileOutputStream = new FileOutputStream(file2);
                    FileChannel fileChannel2 = fileOutputStream.getChannel();
                    fileChannel2.transferFrom(fileChannel, 0L, file.length());
                    file2.setLastModified(file.lastModified());
                    if (fileInputStream == null) break block22;
                }
                catch (Throwable throwable) {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return true;
    }

    public static boolean copyDir(File file, File file2) {
        try {
            return FileUtil.copydirectory(file, file2);
        }
        catch (IOException iOException) {
            CommonPlugin.getDefault().getLogger().logError(iOException);
            return false;
        }
    }

    public static boolean copyDir(String string, String string2) {
        return FileUtil.copyDir(new File(string), new File(string2));
    }

    private static boolean copydirectory(File file, File file2) throws IOException {
        if (!file.exists() || !file2.exists()) {
            return false;
        }
        if (!file.isDirectory() || !file2.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                String string = file2 + File.separator + fileArray[n].getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
                if (fileArray[n].isFile()) {
                    FileUtil.copyfile(fileArray[n], new File(string));
                } else if (fileArray[n].isDirectory()) {
                    File file3 = new File(string);
                    file3.mkdirs();
                    FileUtil.copydirectory(fileArray[n], file3);
                }
                ++n;
            }
        }
        return true;
    }

    public static CharBuffer readFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        CharBuffer charBuffer = null;
        try {
            fileInputStream = new FileInputStream(file);
            FileChannel fileChannel = fileInputStream.getChannel();
            int n = (int)fileChannel.size();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            Charset charset = Charset.forName(ENCODING_ISO_8859_1);
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charBuffer = charsetDecoder.decode(mappedByteBuffer);
        }
        catch (Throwable throwable) {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
        return charBuffer;
    }

    public static StringBuffer readFile(File file, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                int n;
                Charset charset = Charset.forName(string);
                CharsetDecoder charsetDecoder = charset.newDecoder();
                charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
                char[] cArray = new char[1024];
                fileInputStream = new FileInputStream(file);
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charsetDecoder);
                while ((n = inputStreamReader.read(cArray, 0, 1024)) > 0) {
                    stringBuffer.append(cArray, 0, n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
        }
        return stringBuffer;
    }

    /*
     * Loose catch block
     */
    public static long getSize(File file) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        long l = fileInputStream.getChannel().size();
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {}
        return l;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
        return -1L;
    }

    public static boolean isFileLocked(File file) {
        boolean bl;
        block17: {
            bl = false;
            FileOutputStream fileOutputStream = null;
            FileLock fileLock = null;
            if (!file.exists()) {
                return false;
            }
            try {
                try {
                    fileOutputStream = new FileOutputStream(file);
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    fileLock = fileChannel.tryLock();
                    if (fileLock == null) {
                        bl = true;
                    } else {
                        fileLock.release();
                    }
                }
                catch (Exception exception) {
                    bl = exception instanceof SecurityException ? true : (exception instanceof FileNotFoundException ? false : (exception instanceof IOException ? true : !(exception instanceof OverlappingFileLockException)));
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public static FileLock lockFile(File file) {
        FileLock fileLock;
        FileOutputStream fileOutputStream;
        block16: {
            fileOutputStream = null;
            fileLock = null;
            fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileLock = fileChannel.tryLock();
            if (!fileLock.isValid()) break block16;
            FileLock fileLock2 = fileLock;
            try {
                if (!(fileOutputStream == null || fileLock != null && fileLock.isValid())) {
                    fileOutputStream.close();
                }
            }
            catch (Exception exception) {}
            return fileLock2;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (!(fileOutputStream == null || fileLock != null && fileLock.isValid())) {
                            fileOutputStream.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (!(fileOutputStream == null || fileLock != null && fileLock.isValid())) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception3) {}
                return null;
            }
        }
        try {
            if (!(fileOutputStream == null || fileLock != null && fileLock.isValid())) {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static void getAllFiles(File file, List<File> list, boolean bl) {
        File[] fileArray;
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    list.add(fileArray[n]);
                } else if (bl) {
                    FileUtil.getAllFiles(fileArray[n], list, bl);
                }
                ++n;
            }
        }
    }

    public static List<File> fileList(File file, String string) {
        string = string.toUpperCase();
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file.getPath(), stringArray[n]);
                    arrayList.addAll(FileUtil.fileList(file2, string));
                    ++n;
                }
            } else if (string != null) {
                String string2 = file.getName().toUpperCase();
                if (string2.lastIndexOf(".") != -1 && string2.substring(string2.lastIndexOf(".") + 1).startsWith(string)) {
                    arrayList.add(file);
                }
            } else {
                arrayList.add(file);
            }
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError(exception);
        }
        return arrayList;
    }

    public static List<File> fileListExcludeExt(File file, String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                int n = 0;
                while (n < stringArray.length) {
                    File file2 = new File(file.getPath(), stringArray[n]);
                    arrayList.addAll(FileUtil.fileListExcludeExt(file2, string));
                    ++n;
                }
            } else if (string != null) {
                String string2 = file.getName();
                if (string2.lastIndexOf(".") != -1 && !string2.substring(string2.lastIndexOf(".") + 1).startsWith(string)) {
                    arrayList.add(file);
                }
            } else {
                arrayList.add(file);
            }
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError(exception);
        }
        return arrayList;
    }

    public static ArrayList<String> getAllFileAbsolutePaths(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        FileUtil.getAllFiles(file, arrayList, bl);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n = 0;
        while (n < arrayList.size()) {
            String string = arrayList.get(n).getAbsolutePath();
            arrayList2.add(string);
            ++n;
        }
        return arrayList2;
    }

    public static boolean moveFile(File file, File file2) {
        try {
            FileUtil.doMoveFile(file, file2);
            return true;
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError(exception);
            return false;
        }
    }

    public static void doMoveFile(File file, File file2) throws IOException {
        if (!file.renameTo(file2)) {
            FileUtil.copyfile(file, file2);
            file.delete();
        }
    }
}

