/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.StringTokenizer;
import java.net.URI;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.CommonPlugin;

public class StrUtil {
    public static final String TAB = "\t";
    private static final String REGEXP_ANY_SPECIAL_CHARS = "(`|~|!|@|#|\\$|%|\\^|&|\\*|\\(|\\)|\\+|=|\\[|\\]|\\||\\:|\"|<|>|\\?|/|'|\\s|\\\\)+";
    private static final String REGEXP_INVALID_PUBLISHED_PATH_CHARS = "(\\[|#|\\*|\\?|\"|<|>|\\||!|%|/|\\])+";
    private static final String REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX = "(\\[|#|\\*|\\?|\"|<|>|\\||!|%|\\])+";
    private static final String REGEXP_INVALID_FILENAME_CHARS = "(\\[|#|/|\\\\|\\:|\\*|\\?|\"|<|>|\\||\\]|\\s)+";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String LINE_FEED = System.getProperty("line.separator");
    public static final String ESCAPED_LF = "&#xA;";
    public static final String ESCAPED_CR = "&#xD;";
    public static final String ESCAPED_LINE_FEED = LINE_FEED.replace("\n", "&#xA;").replace("\r", "&#xD;");
    public static final String LINE_FEED_REGEX = LINE_FEED.replaceAll("\\\\", "\\\\");
    public static final String ESCAPED_LINE_FEED_REGEX = ESCAPED_LINE_FEED;
    public static final String HTML_BREAK = "<br/>";
    public static final String HTML_COPY = "&copy;";
    public static final String HTML_EURO = "&euro;";
    public static final String HTML_REG = "&reg;";
    public static final String HTML_TRADEMARK = "&trade;";

    private StrUtil() {
    }

    public static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String removeWhiteSpaceChars(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            switch (string.charAt(n2)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n2;
        }
        return "";
    }

    public static String[] split(String string, String string2, int n) {
        if (string == null || n == 0 || n < -1) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, n != -1);
        if (n == -1) {
            n = stringTokenizer.countTokens();
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (n2 < n) {
                if (string3.length() == 1 && string2.indexOf(string3) != -1) continue;
                stringArray[n2++] = string3;
                continue;
            }
            int n3 = n - 1;
            stringArray[n3] = String.valueOf(stringArray[n3]) + string3;
        }
        return stringArray;
    }

    public static String[] split(String string, String string2) {
        return StrUtil.split(string, string2, -1);
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return string;
        }
        String string4 = string;
        while ((n = string4.indexOf(string2)) != -1) {
            string4 = String.valueOf(string4.substring(0, n)) + string3 + string4.substring(n + string2.length());
        }
        return string4;
    }

    public static int getIntValue(String string, int n) {
        if (StrUtil.isBlank(string)) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static byte[] getUTF8Bytes(String string) {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n = cArray[n4];
            n3 = n <= 127 ? ++n3 : (n <= 2047 ? (n3 += 2) : (n3 += 3));
            ++n4;
        }
        byte[] byArray = new byte[n3];
        n = 0;
        int n5 = 0;
        while (n5 < n2) {
            char c = cArray[n5];
            if (c <= '\u007f') {
                byArray[n++] = (byte)c;
            } else if (c <= '\u07ff') {
                byArray[n++] = (byte)(c >> 6 | 0xC0);
                byArray[n++] = (byte)(c & 0x3F | 0x80);
            } else {
                byArray[n++] = (byte)(c >> 12 | 0xE0);
                byArray[n++] = (byte)(c >> 6 & 0x3F | 0x80);
                byArray[n++] = (byte)(c & 0x3F | 0x80);
            }
            ++n5;
        }
        return byArray;
    }

    private static char toHex(int n) {
        return HEX_DIGITS[n & 0xF];
    }

    public static String toEscapedUnicode(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl && c < '~') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("\\u");
                stringBuffer.append(StrUtil.toHex(c >> 12 & 0xF));
                stringBuffer.append(StrUtil.toHex(c >> 8 & 0xF));
                stringBuffer.append(StrUtil.toHex(c >> 4 & 0xF));
                stringBuffer.append(StrUtil.toHex(c & 0xF));
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getEscapedHTML(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '%': {
                    if (n2 + 4 < n) {
                        String string2 = string.substring(n2 + 1, n2 + 5);
                        boolean bl = true;
                        int n3 = 0;
                        while (n3 < string2.length()) {
                            char c2 = string2.charAt(n3);
                            if (c2 < '0' || c2 > '9' || c2 >= 'a' && c2 <= 'f') {
                                bl = false;
                                break;
                            }
                            ++n3;
                        }
                        if (bl) {
                            try {
                                n3 = Integer.parseInt(string2, 16);
                                char[] cArray = UCharacter.toChars((int)n3);
                                stringBuffer.append(cArray);
                                n2 += 4;
                                break;
                            }
                            catch (Exception exception) {}
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case '\u00a9': {
                    stringBuffer.append(HTML_COPY);
                    break;
                }
                case '\u00ae': {
                    stringBuffer.append(HTML_REG);
                    break;
                }
                case '\u20ac': {
                    stringBuffer.append(HTML_EURO);
                    break;
                }
                case '\u2122': {
                    stringBuffer.append(HTML_TRADEMARK);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getPlainText(String string) {
        if (string == null) {
            return "";
        }
        Pattern pattern = Pattern.compile("<[^>]*?>", 34);
        Pattern pattern2 = Pattern.compile("&.{1,5}[^;];", 34);
        Pattern pattern3 = Pattern.compile("\\s+", 34);
        String string2 = string.replaceAll(pattern.pattern(), " ").replaceAll(pattern2.pattern(), " ").replaceAll(pattern3.pattern(), " ");
        return string2;
    }

    public static String makeValidFileName(String string) {
        if (string == null) {
            return "";
        }
        return StrUtil.getPlainText(string).replaceAll(REGEXP_INVALID_FILENAME_CHARS, " ").trim();
    }

    public static String removeSpecialCharacters(String string) {
        if (string == null) {
            return "";
        }
        return StrUtil.getPlainText(string).replaceAll(REGEXP_ANY_SPECIAL_CHARS, " ").trim();
    }

    public static boolean isValidPublishPath(String string) {
        if (Platform.getOS().equals("win32")) {
            return string.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS, "").equals(string);
        }
        return string.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX, "").equals(string);
    }

    public static String toLower(String string) {
        if (Platform.getNL().startsWith("de")) {
            return string;
        }
        return string.toLowerCase();
    }

    public static String escape(String string) {
        return string.replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"");
    }

    public static String[] convertListToStrArray(List list) {
        if (list != null) {
            int n = list.size();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                String string = (String)list.get(n2);
                stringArray[n2] = new String(string);
                ++n2;
            }
            return stringArray;
        }
        return null;
    }

    public static boolean isValidName(String string) {
        return string.replaceAll(REGEXP_ANY_SPECIAL_CHARS, "").equals(string);
    }

    public static void main(String[] stringArray) {
        String string = "A&%      `&#           $~!@#$%^&*()_-+={}[\"]:|\\:;\"'<,>.?/ \t\r\nZ";
        System.out.println("[" + string + "] <== text");
        System.out.println("[" + string.replaceAll(REGEXP_ANY_SPECIAL_CHARS, " ") + "] <== All");
        System.out.println("[" + string.replaceAll(REGEXP_INVALID_FILENAME_CHARS, " ") + "] <== File Name");
        System.out.println("[" + string.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS, " ") + "] <== path");
        System.out.println("[" + string.replaceAll(REGEXP_INVALID_PUBLISHED_PATH_CHARS_LINUX, " ") + "] <== path, Linux");
        System.out.println("");
    }

    public static String convertNewlinesToHTML(String string) {
        if (string != null) {
            string = string.replaceAll(LINE_FEED_REGEX, HTML_BREAK + LINE_FEED);
            string = string.replaceAll(ESCAPED_LINE_FEED_REGEX, HTML_BREAK + ESCAPED_LINE_FEED);
        }
        return string;
    }

    public static URI toURI(String string) {
        if (string != null && string.length() > 0) {
            IPath iPath = Path.fromOSString((String)string);
            try {
                return iPath.toFile().toURI();
            }
            catch (Exception exception) {
                CommonPlugin.getDefault().getLogger().logError(exception);
            }
        }
        return null;
    }
}

