/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.epf.search.SearchPlugin;
import org.eclipse.epf.search.SearchResources;
import org.eclipse.epf.search.SearchServiceException;
import org.eclipse.epf.search.analysis.TextAnalyzer;
import org.eclipse.epf.search.utils.JarCreator;
import org.eclipse.epf.search.utils.LHTMLParser;
import org.eclipse.epf.search.utils.UNCUtil;

public class IndexBuilder {
    static final String VERSION_FILE_NAME = "version.txt";
    static final String VERSION_DELIMITER = "*";
    public static final String BRIEF_DESCRIPTION_FIELD = "briefDescription";
    public static final String CONTENT_FIELD = "contents";
    public static final String ID_FIELD = "id";
    public static final String MODIFIED_FIELD = "modified";
    public static final String NAME_FIELD = "name";
    public static final String ROLE_FIELD = "role";
    public static final String SUMMARY_FIELD = "summary";
    public static final String TYPE_FIELD = "type";
    public static final String URL_FIELD = "url";
    public static final String TITLE_FIELD = "title";
    public static final String UMA_ELEMENT_TYPE_FIELD = "uma.type";
    public static final String GENERAL_CONTENT = "general_content";
    private static List NO_SEARCHEABLE_UMA_ELEMENTS = new ArrayList();
    public static List dirsToSkip;
    public static String pDirectory;
    private StringBuffer indexFolder = null;
    private String productName = null;
    private List filesToSkip = new ArrayList();

    static {
        NO_SEARCHEABLE_UMA_ELEMENTS.add(SUMMARY_FIELD);
        NO_SEARCHEABLE_UMA_ELEMENTS.add("workproductdescriptor");
        NO_SEARCHEABLE_UMA_ELEMENTS.add("taskdescriptor");
        NO_SEARCHEABLE_UMA_ELEMENTS.add("roledescriptor");
        dirsToSkip = new ArrayList();
        pDirectory = null;
    }

    public IndexBuilder(String string) {
        int n = -1;
        if (string == null) {
            return;
        }
        n = string.indexOf(String.valueOf(File.separator) + "applet");
        pDirectory = UNCUtil.convertFilename(n > -1 ? string.substring(0, n + 1) : string);
        String string2 = pDirectory.replace(File.separatorChar, '/');
        int n2 = string2.length();
        if (string2.endsWith("/")) {
            --n2;
        }
        int n3 = string2.lastIndexOf("/", n2 - 1);
        this.productName = string2.substring(n3 + 1, n2);
        StringBuffer stringBuffer = new StringBuffer(pDirectory);
        if (!stringBuffer.toString().endsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append("search");
        this.indexFolder = new StringBuffer(stringBuffer.toString());
        this.indexFolder.append(File.separator).append("index");
        dirsToSkip.add(String.valueOf(pDirectory) + "applet");
        dirsToSkip.add(String.valueOf(pDirectory) + "css");
        dirsToSkip.add(String.valueOf(pDirectory) + "ext_help");
        dirsToSkip.add(String.valueOf(pDirectory) + "icons");
        dirsToSkip.add(String.valueOf(pDirectory) + "images");
        dirsToSkip.add(String.valueOf(pDirectory) + "index");
        dirsToSkip.add(String.valueOf(pDirectory) + "logs");
        dirsToSkip.add(String.valueOf(pDirectory) + "manuals");
        dirsToSkip.add(String.valueOf(pDirectory) + "noapplet");
        dirsToSkip.add(String.valueOf(pDirectory) + "pages_not_installed");
        dirsToSkip.add(String.valueOf(pDirectory) + "process");
        dirsToSkip.add(String.valueOf(pDirectory) + "scripts");
        dirsToSkip.add(String.valueOf(pDirectory) + "stylesheets");
        dirsToSkip.add(String.valueOf(pDirectory) + "xml");
        dirsToSkip.add(String.valueOf(pDirectory) + "search");
        this.filesToSkip.add("_desc.htm");
        this.filesToSkip.add("_wbs.htm");
        this.filesToSkip.add("_tbs.htm");
        this.filesToSkip.add("_wpbs.htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(boolean bl) throws SearchServiceException {
        Class<IndexBuilder> clazz = IndexBuilder.class;
        synchronized (IndexBuilder.class) {
            block16: {
                long l;
                block15: {
                    Date date;
                    if (this.indexFolder == null || pDirectory == null) {
                        throw new IllegalStateException("Invalid indexFolder or pDirectory");
                    }
                    try {
                        date = new IndexWriter((Directory)FSDirectory.getDirectory((String)this.indexFolder.toString(), (boolean)true), (Analyzer)new TextAnalyzer(), true);
                        if (date != null) {
                            date.setMaxFieldLength(1000000);
                            this.indexDocs(new File(pDirectory), (IndexWriter)date);
                            date.optimize();
                            date.close();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    date = new Date();
                    l = date.getTime();
                    if (bl) break block15;
                    try {
                        FileWriter fileWriter = new FileWriter(this.indexFolder + File.separator + VERSION_FILE_NAME);
                        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                        bufferedWriter.write(String.valueOf(this.productName) + VERSION_DELIMITER + l + "\n");
                        bufferedWriter.close();
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        throw new SearchServiceException(SearchResources.createSearchIndexError);
                    }
                    return true;
                }
                JarCreator.jarFolder(this.indexFolder.toString());
                System.out.println("index Jarred successfully");
                try {
                    Object object;
                    File file = new File(this.indexFolder.toString());
                    File[] fileArray = file.listFiles();
                    int n = 0;
                    while (n < fileArray.length) {
                        object = fileArray[n];
                        if (!((File)object).getName().equals("index.jar")) {
                            ((File)object).delete();
                        }
                        ++n;
                    }
                    File file2 = new File(this.indexFolder + File.separator + "index.jar");
                    if (file2.exists()) {
                        object = "" + file2.length();
                        FileWriter fileWriter = new FileWriter(this.indexFolder + File.separator + VERSION_FILE_NAME);
                        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                        bufferedWriter.write(String.valueOf(this.productName) + VERSION_DELIMITER + l + VERSION_DELIMITER + (String)object + "\n");
                        bufferedWriter.close();
                        fileWriter.close();
                        break block16;
                    }
                    throw new SearchServiceException(SearchResources.createSearchIndexError);
                }
                catch (IOException iOException) {
                    throw new SearchServiceException(SearchResources.createSearchIndexError);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexDocs(File file, IndexWriter indexWriter) throws Exception {
        Document document;
        if (dirsToSkip.contains(file.getAbsolutePath())) {
            return;
        }
        if (file.isFile()) {
            for (String string : this.filesToSkip) {
                if (file.getName().indexOf(string) <= -1) continue;
                return;
            }
        }
        if (file.isDirectory()) {
            document = file.list();
            int n = 0;
            while (n < ((String[])document).length) {
                this.indexDocs(new File(file, (String)document[n]), indexWriter);
                ++n;
            }
            return;
        } else {
            if (!IndexBuilder.isHtmlDoc(file)) return;
            if (this.shouldBeExcluded(file)) {
                return;
            }
            try {
                document = this.getHTMLDocument(file);
                if (document == null) return;
                indexWriter.addDocument(document);
                return;
            }
            catch (Exception exception) {
                System.out.println(file.getName());
                System.out.println("indexDocs");
                exception.printStackTrace();
            }
        }
    }

    private boolean shouldBeExcluded(File file) {
        String string = file.getParentFile().getAbsolutePath();
        return pDirectory.startsWith(string);
    }

    private static boolean isHtmlDoc(File file) {
        String string = file.getPath();
        return string.endsWith(".html") || string.endsWith(".htm");
    }

    /*
     * Unable to fully structure code
     */
    private Document getHTMLDocument(File var1_1) {
        block28: {
            block26: {
                block25: {
                    var2_2 = new Document();
                    var3_3 = var1_1.getPath().replace(File.pathSeparatorChar, '/');
                    var2_2.add(Field.UnIndexed((String)"url", (String)var3_3));
                    var4_4 = null;
                    var4_4 = new InputStreamReader((InputStream)new FileInputStream(var1_1), "UTF-8");
                    var5_5 = new LHTMLParser(var4_4);
                    var6_7 = var5_5.getReader();
                    if (var6_7 == null) break block25;
                    var2_2.add(Field.Text((String)"contents", (Reader)var6_7));
                    break block26;
                }
lbl13:
                // 3 sources

                while (true) {
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (Exception v0) {}
                    }
                    return null;
                }
            }
            try {
                try {
                    var7_8 = var5_5.getTitle();
                    if (var7_8 == null || var7_8.length() <= 0) ** GOTO lbl13
                    var7_8 = var7_8.replaceAll("\\xa0", " ");
                    var2_2.add(Field.Keyword((String)"title", (String)var7_8));
                    var8_9 = var5_5.getSummary();
                    if (var8_9.startsWith(var7_8) && var8_9.length() > var7_8.length()) {
                        var2_2.add(Field.Keyword((String)"summary", (String)var8_9.substring(var7_8.length() + 1)));
                    } else {
                        var2_2.add(Field.Keyword((String)"summary", (String)var5_5.getSummary()));
                    }
                    var9_10 = var5_5.getMetaTags();
                    var10_11 = var9_10.propertyNames();
                    while (var10_11.hasMoreElements()) {
                        var11_12 = (String)var10_11.nextElement();
                        if (var11_12 == null) continue;
                        if (var11_12.equals("role")) {
                            var12_13 = var9_10.getProperty(var11_12);
                            if (var12_13 == null) continue;
                            var2_2.add(Field.Text((String)var11_12, (String)var12_13));
                            continue;
                        }
                        var12_13 = var9_10.getProperty(var11_12);
                        if (var12_13 == null) continue;
                        var2_2.add(Field.Text((String)var11_12, (String)var12_13));
                    }
                    if (var2_2.getField("role") == null) {
                        var2_2.add(Field.Text((String)"role", (String)"NORUPROLE"));
                    }
                    if ((var10_11 = var2_2.getField("uma.type")) == null) {
                        var2_2.add(Field.Text((String)"uma.type", (String)"general_content"));
                    } else {
                        if (!IndexBuilder.NO_SEARCHEABLE_UMA_ELEMENTS.contains(var10_11.stringValue())) ** break;
                        ** continue;
                    }
                    var5_5 = null;
                }
                catch (Exception var5_6) {
                    var2_2 = null;
                    SearchPlugin.getDefault().getLogger().logError((Throwable)var5_6);
                    if (var4_4 != null) {
                        try {
                            var4_4.close();
                        }
                        catch (Exception v1) {}
                    }
                    break block28;
                }
            }
            catch (Throwable var13_14) {
                if (var4_4 != null) {
                    try {
                        var4_4.close();
                    }
                    catch (Exception v2) {}
                }
                throw var13_14;
            }
            if (var4_4 != null) {
                try {
                    var4_4.close();
                }
                catch (Exception v3) {}
            }
        }
        return var2_2;
    }
}

