/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.utils;

import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class UNCUtil {
    public static final String UNC_FILE_PREFIX = "file:/";
    public static final String ALTERNATE_UNC_FILE_PREFIX = "file://";
    public static final String NETSCAPE_UNC_FILE_PREFIX = "file:///";
    public static final String UNC_FILE_ONLY = "file:";
    public static final String UNC_SEPARATOR = "/";

    public static String handleNetscapeFilePrefix(String string) {
        String string2 = null;
        string2 = string.startsWith(NETSCAPE_UNC_FILE_PREFIX) ? ALTERNATE_UNC_FILE_PREFIX + string.substring(NETSCAPE_UNC_FILE_PREFIX.length(), string.length()) : string;
        return string2;
    }

    public static URL handleURLForUNC(URL uRL) {
        URL uRL2 = null;
        try {
            if (uRL.toString().startsWith(ALTERNATE_UNC_FILE_PREFIX)) {
                String string = uRL.toString().substring(5);
                uRL2 = new URL("file", "", "///" + string);
            } else {
                uRL2 = uRL;
            }
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static String convertFilename(String string) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith(UNC_FILE_PREFIX)) {
            string3 = string.substring(UNC_FILE_PREFIX.length(), string.length());
            int n = string3.indexOf(":");
            if (n == -1) {
                string3 = UNC_SEPARATOR + string3;
            }
        } else {
            string3 = string;
        }
        string2 = string3.replace(UNC_SEPARATOR.charAt(0), File.separator.charAt(0));
        return string2;
    }

    public static String convertFilenameToUNC(String string) {
        String string2 = string.replace(File.separator.charAt(0), UNC_SEPARATOR.charAt(0));
        String string3 = UNCUtil.convertFileSeparator(string2);
        return string3;
    }

    public static String convertToUNC(String string) {
        String string2 = null;
        string2 = string.startsWith(ALTERNATE_UNC_FILE_PREFIX) ? UNC_FILE_PREFIX + string.substring(ALTERNATE_UNC_FILE_PREFIX.length(), string.length()) : string;
        return string2;
    }

    public static String convertFileSpacing(String string) {
        int n = 0;
        String string2 = "";
        while (n < string.length()) {
            int n2 = string.indexOf("%20", n);
            if (n2 == -1) {
                n2 = string.length();
            }
            string2 = String.valueOf(string2) + string.substring(n, n2);
            string2 = String.valueOf(string2) + " ";
            n = n2 + 3;
        }
        string2 = string2.trim();
        return string2;
    }

    public static String convertFileSeparator(String string) {
        int n = 0;
        String string2 = "";
        while (n < string.length()) {
            int n2 = string.indexOf("%5C", n);
            if (n2 == -1) {
                string2 = string.trim();
                break;
            }
            string2 = String.valueOf(string2) + string.substring(n, n2);
            string2 = String.valueOf(string2) + UNC_SEPARATOR;
            n = n2 + 3;
        }
        string2 = string2.trim();
        String string3 = "\\";
        if (!File.separator.equals(string3) && File.separator.equals(UNC_SEPARATOR)) {
            string2 = string2.replace(string3.charAt(0), UNC_SEPARATOR.charAt(0));
        }
        return string2;
    }

    public static Vector getFileList(String string, String string2) {
        if (string.startsWith("http")) {
            return UNCUtil.getFileListFromRemote(string, string2);
        }
        String string3 = UNCUtil.convertFilename(string);
        File file = new File(UNCUtil.convertFileSpacing(string3));
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(string2)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        return vector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Vector getFileListFromRemote(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        try {
            int n;
            Vector<String> vector2;
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n2;
                if ((n2 = inputStream.read()) == -1) {
                    inputStream.close();
                    String string3 = stringBuffer.toString();
                    string3 = string3.replaceAll("href", "HREF");
                    string3 = string3.replaceAll("</a", "</A");
                    string3 = string3.replaceAll("<tt>", "");
                    string3 = string3.replaceAll("</tt>", "");
                    string3 = string3.replaceAll("<TT>", "");
                    string3 = string3.replaceAll("</TT>", "");
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    vector2 = new Vector<String>();
                    try {
                        while (true) {
                            stringTokenizer.nextToken("REF");
                            stringTokenizer.nextToken("\"");
                            String string4 = stringTokenizer.nextToken("\"");
                            int n3 = string4.indexOf("</A");
                            if (n3 != -1 && n3 != 0) {
                                String string5 = string4.substring(0, n3);
                                vector2.addElement(string5);
                                continue;
                            }
                            vector2.addElement(string4);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        n = 0;
                        break;
                    }
                }
                stringBuffer.append((char)n2);
            }
            while (true) {
                if (n >= vector2.size()) {
                    return vector;
                }
                String string6 = (String)vector2.elementAt(n);
                if (string6.endsWith(string2)) {
                    vector.addElement(string6);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }
}

