/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.wizards;

import java.io.File;
import java.util.List;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class OpenLibraryMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = OpenLibraryMainPage.class.getName();
    protected static final String TYPE_ID = "typeId";
    protected Shell shell;
    protected Composite composite;
    protected Label pathLabel;
    protected Combo libraryPathCombo;
    protected Button browseButton;
    protected String libraryType;

    public OpenLibraryMainPage(String string) {
        super(string);
        this.setTitle(LibraryUIResources.openLibraryWizard_title);
        this.setDescription(LibraryUIResources.openLibraryMainWizardPage_title);
        this.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
    }

    public OpenLibraryMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.shell = composite.getShell();
        this.composite = OpenLibraryMainPage.createGridLayoutComposite((Composite)composite, (int)3);
        this.pathLabel = OpenLibraryMainPage.createLabel((Composite)this.composite, (String)LibraryUIResources.pathLabel_text);
        this.libraryPathCombo = OpenLibraryMainPage.createCombobox((Composite)this.composite);
        this.browseButton = OpenLibraryMainPage.createButton((Composite)this.composite, (String)LibraryUIResources.browseButton_text);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        List<String> list = LibraryUIPreferences.getOpenLibraryPathsList();
        if (list.size() > 0) {
            String[] stringArray = LibraryUIPreferences.getOpenLibraryPaths();
            this.libraryPathCombo.setItems(stringArray);
            if (stringArray.length > 0) {
                this.libraryPathCombo.setText(stringArray[0]);
            }
        } else {
            String string = String.valueOf(LibraryUIPreferences.getDefaultLibraryPath()) + FileUtil.FILE_SEP + "Library1";
            list.add(0, string);
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.libraryPathCombo.setItems(stringArray);
            this.libraryPathCombo.setText(stringArray[0]);
        }
    }

    protected void addListeners() {
        this.libraryPathCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                OpenLibraryMainPage.this.setPageComplete(OpenLibraryMainPage.this.isPageComplete());
                OpenLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.libraryPathCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                OpenLibraryMainPage.this.setPageComplete(OpenLibraryMainPage.this.isPageComplete());
                OpenLibraryMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(OpenLibraryMainPage.this.shell, 0);
                directoryDialog.setFilterPath(OpenLibraryMainPage.this.getLibraryPath());
                String string = directoryDialog.open();
                if (string != null) {
                    OpenLibraryMainPage.this.libraryPathCombo.add(string, 0);
                    OpenLibraryMainPage.this.libraryPathCombo.setText(string);
                }
            }
        });
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0;
    }

    public String getLibraryName() {
        String string;
        String string2 = this.getLibraryPath();
        if (!string2.equals(string = new File(string2).getName())) {
            return string;
        }
        return "";
    }

    public String getLibraryPath() {
        return this.libraryPathCombo.getText().trim();
    }

    public String getLibraryType() {
        return this.libraryType;
    }
}

