/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.I18nUtil;
import org.eclipse.epf.common.utils.ImageUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.layout.elements.RoleLayout;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.swt.SWT;

public class RoleDiagramPublisher {
    private static final String DEFAULT_FONT_NAME = "Arial";
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final int DEFAULT_X_MARGIN = 200;
    private int maxImageWidth = 1024;
    private int maxImageHeight = 1024;
    private int borderWidth = 10;
    private int borderHeight = 10;
    private int xMargin = 240;
    private int xSpacing;
    private int ySpacing;
    private int maxTextLines;
    private int linePadding = 12;
    private Font textFont = null;

    public RoleDiagramPublisher() {
        String string = this.getFontName();
        int n = SWT.getPlatform().equals("win32") ? I18nUtil.getInt((String)LibraryResources.roleDiagramFont_size_win32, (int)10) : I18nUtil.getInt((String)LibraryResources.roleDiagramFont_size, (int)10);
        if (string.startsWith("[")) {
            string = DEFAULT_FONT_NAME;
        }
        this.textFont = new Font(string, 0, n);
        this.xMargin = I18nUtil.getInt((String)LibraryResources.roleDiagram_xMargin, (int)200);
        this.xSpacing = LibraryPreferences.getRoleDiagramHorizontalSpacing();
        this.ySpacing = LibraryPreferences.getRoleDiagramVerticalSpacing();
        this.maxTextLines = LibraryPreferences.getRoleDiagramMaximumTextLines();
    }

    private String getFontName() {
        String string = Platform.getNL().startsWith("ja") ? (SWT.getPlatform().equals("win32") ? LibraryResources.roleDiagramFont_name_win32_ja : LibraryResources.roleDiagramFont_name_ja) : (Platform.getNL().startsWith("ko") ? (SWT.getPlatform().equals("win32") ? LibraryResources.roleDiagramFont_name_win32_ko : LibraryResources.roleDiagramFont_name_ko) : (Platform.getNL().startsWith("zh_TW") ? (SWT.getPlatform().equals("win32") ? LibraryResources.roleDiagramFont_name_win32_zh_TW : LibraryResources.roleDiagramFont_name_zh_TW) : (Platform.getNL().startsWith("zh") ? (SWT.getPlatform().equals("win32") ? LibraryResources.roleDiagramFont_name_win32_zh : LibraryResources.roleDiagramFont_name_zh) : (SWT.getPlatform().equals("win32") ? LibraryResources.roleDiagramFont_name_win32 : LibraryResources.roleDiagramFont_name))));
        return string;
    }

    public MethodElementDiagram publish(RoleLayout roleLayout, File file) {
        Role role = (Role)roleLayout.getElement();
        if (role == null) {
            throw new IllegalArgumentException();
        }
        try {
            List list;
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            MethodElementDiagram methodElementDiagram = new MethodElementDiagram((MethodElement)role);
            String string = roleLayout.getLayoutMgr().getPublishDir();
            String string2 = roleLayout.getDisplayName();
            string2 = string2 == null || string2.length() == 0 ? "Unknown" : string2.replace(' ', '_');
            HTMLMap hTMLMap = new HTMLMap(string2);
            methodElementDiagram.setHTMLMap(hTMLMap);
            JPanel jPanel = new JPanel();
            BufferedImage bufferedImage = new BufferedImage(this.maxImageWidth, this.maxImageHeight, 1);
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fillRect(0, 0, this.maxImageWidth, this.maxImageHeight);
            graphics2D.setStroke(new BasicStroke(1.25f));
            graphics2D.setColor(Color.BLACK);
            int n2 = this.xSpacing / 2;
            List list2 = roleLayout.getPerforms();
            int n3 = list2 != null ? list2.size() : 0;
            Point point = new Point(this.borderWidth + this.xMargin, this.borderHeight);
            Point point2 = new Point(this.borderWidth + this.xMargin, this.borderHeight);
            int n4 = point.x;
            int n5 = point.y;
            int n6 = 0;
            if (n3 > 0) {
                int n7 = 1;
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    object7 = (Task)iterator.next();
                    object6 = roleLayout.getLayoutMgr().getLayout((MethodElement)object7, true);
                    String string3 = object6.getDisplayName();
                    String string4 = String.valueOf(string) + object6.getDiagramiconUrl();
                    try {
                        object5 = ImageUtil.getBufferedImage((String)string4, (Component)jPanel);
                        int n8 = ((BufferedImage)object5).getWidth();
                        int n9 = ((BufferedImage)object5).getHeight();
                        if (n7 == 1) {
                            point2.x += n8;
                            point2.y += n9;
                            n6 = point2.x;
                        }
                        object4 = new Rectangle(n4, n5, n8, n9);
                        object3 = new TexturePaint((BufferedImage)object5, (Rectangle2D)object4);
                        graphics2D.setPaint((Paint)object3);
                        graphics2D.fill((Shape)object4);
                        if (string3 != null) {
                            ImageUtil.drawText((Graphics2D)graphics2D, (String)string3, (Font)this.textFont, (Color)Color.BLACK, (int)(n4 - n2), (int)point2.y, (float)(n8 + this.xSpacing), (int)this.maxTextLines);
                        }
                        object2 = String.valueOf(object6.getFilePath(roleLayout)) + object6.getFileName(".html");
                        object = new HTMLArea(object7.getGuid(), (String)object2, "rect", (Rectangle)object4, string3);
                        hTMLMap.addArea((HTMLArea)object);
                        if (n4 + n8 > n6) {
                            n6 = n4 + n8;
                        }
                        if (iterator.hasNext()) {
                            n = n8 + this.xSpacing;
                            point2.x += n;
                            if ((n4 += n) + n + n2 + this.borderWidth > this.maxImageWidth) {
                                n4 = point.x;
                                int n10 = n9 + this.ySpacing;
                                n5 += n10;
                                point2.y += n10;
                                point2.x = point.x + n8;
                            }
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n7;
                }
            }
            int n11 = (list = roleLayout.getResponsibleFor()) != null ? list.size() : 0;
            object7 = new Point(point.x, this.borderHeight);
            object6 = new Point(point.x, this.borderHeight);
            if (n3 > 0 && n11 > 0) {
                ((Point)object6).y = object7.y = point2.y + this.ySpacing + this.ySpacing / 2;
            } else if (n3 > 0) {
                ((Point)object6).y = point2.y + this.borderHeight;
            }
            n4 = object7.x;
            n5 = object7.y;
            int n12 = 0;
            if (n11 > 0) {
                int n13 = 1;
                object5 = list.iterator();
                while (object5.hasNext()) {
                    WorkProduct workProduct = (WorkProduct)object5.next();
                    IElementLayout iElementLayout = roleLayout.getLayoutMgr().getLayout((MethodElement)workProduct, true);
                    object4 = iElementLayout.getDisplayName();
                    object3 = String.valueOf(string) + iElementLayout.getDiagramiconUrl();
                    try {
                        object2 = ImageUtil.getBufferedImage((String)object3, (Component)jPanel);
                        int n14 = ((BufferedImage)object2).getWidth();
                        n = ((BufferedImage)object2).getHeight();
                        if (n13 == 1) {
                            ((Point)object6).x += n14;
                            ((Point)object6).y += n;
                            n12 = ((Point)object6).x;
                        }
                        Rectangle rectangle = new Rectangle(n4, n5, n14, n);
                        TexturePaint texturePaint = new TexturePaint((BufferedImage)object2, rectangle);
                        graphics2D.setPaint(texturePaint);
                        graphics2D.fill(rectangle);
                        if (object4 != null) {
                            ImageUtil.drawText((Graphics2D)graphics2D, (String)object4, (Font)this.textFont, (Color)Color.BLACK, (int)(n4 - n2), (int)((Point)object6).y, (float)(n14 + this.xSpacing), (int)this.maxTextLines);
                        }
                        String string5 = String.valueOf(iElementLayout.getFilePath(roleLayout)) + iElementLayout.getFileName(".html");
                        HTMLArea hTMLArea = new HTMLArea(workProduct.getGuid(), string5, "rect", rectangle, (String)object4);
                        hTMLMap.addArea(hTMLArea);
                        if (n4 + n14 > n12) {
                            n12 = n4 + n14;
                        }
                        if (object5.hasNext()) {
                            int n15 = n14 + this.xSpacing;
                            ((Point)object6).x += n15;
                            if ((n4 += n15) + n15 + n2 + this.borderWidth > this.maxImageWidth) {
                                n4 = object7.x;
                                int n16 = n + this.ySpacing;
                                n5 += n16;
                                ((Point)object6).y += n16;
                                ((Point)object6).x = object7.x + n14;
                            }
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n13;
                }
            }
            Point point3 = new Point(n2 - 5, this.borderHeight);
            object5 = point3;
            try {
                String string6 = roleLayout.getDisplayName();
                String string7 = String.valueOf(string) + roleLayout.getDiagramiconUrl();
                object4 = ImageUtil.getBufferedImage((String)string7, (Component)jPanel);
                int n17 = ((BufferedImage)object4).getWidth();
                int n18 = ((BufferedImage)object4).getHeight();
                n4 = n2 - 5;
                n5 = this.borderHeight;
                ((Point)object5).x += n17;
                ((Point)object5).y += n18;
                if (n11 > 0) {
                    n5 = this.borderHeight + (((Point)object6).y - point.y - n18) / 2;
                    object = new Point(n4 + n17 + this.linePadding / 2, n5 + n18 / 2);
                    n = object7.x - this.linePadding;
                    if (n > 200 - this.xSpacing / 2) {
                        n = 200 - this.xSpacing / 2;
                    }
                    Point point4 = new Point(object7.x - this.linePadding, object7.y + (((Point)object6).y - object7.y) / 2);
                    this.renderAssociation(graphics2D, (Point)object, point4, LibraryResources.roleDiagramResponsibleFor_text, this.textFont, Color.BLACK);
                } else if (n3 > 0) {
                    n5 = this.borderHeight + (point2.y - point.y - n18) / 2;
                }
                point3.y = n5;
                ((Point)object5).y = n5 + n18;
                if (n3 > 0) {
                    object = new Point(n4 + n17 + this.linePadding / 2, n5 + n18 / 2);
                    n = point.x - this.linePadding;
                    if (n > 200 - this.xSpacing / 2) {
                        n = 200 - this.xSpacing / 2;
                    }
                    Point point5 = new Point(n, this.borderHeight + (point2.y - point.y) / 2);
                    this.renderAssociation(graphics2D, (Point)object, point5, LibraryResources.roleDiagramPerforms_text, this.textFont, Color.BLACK);
                }
                object = new Rectangle(n4, n5, n17, n18);
                TexturePaint texturePaint = new TexturePaint((BufferedImage)object4, (Rectangle2D)object);
                graphics2D.setPaint(texturePaint);
                graphics2D.fill((Shape)object);
                if (string6 != null) {
                    ImageUtil.drawText((Graphics2D)graphics2D, (String)string6, (Font)this.textFont, (Color)Color.BLACK, (int)(n4 - n2), (int)(n5 + n18), (float)(n17 + this.xSpacing), (int)this.maxTextLines);
                }
            }
            catch (Exception exception) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
            int n19 = Math.max(n6, n12) + this.borderWidth;
            n19 = Math.max(n19, ((Point)object5).x + this.borderWidth);
            n19 = Math.min(n19, this.maxImageWidth);
            int n20 = ((Point)object6).y + this.borderHeight;
            n20 = Math.max(n20, ((Point)object5).y + this.borderHeight);
            n20 += this.maxTextLines * 10;
            n20 = Math.min(n20, this.maxImageHeight);
            object4 = bufferedImage.getSubimage(0, 0, n19 += n2, n20);
            File file2 = new File(file, String.valueOf(roleLayout.getFilePath()) + roleLayout.getFileName(".jpg"));
            File file3 = file2.getParentFile();
            if (!file3.exists()) {
                file3.mkdirs();
            }
            ImageIO.write((RenderedImage)object4, "jpg", file2);
            methodElementDiagram.setImageFileName(file2.getName());
            return methodElementDiagram;
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }

    protected void renderAssociation(Graphics2D graphics2D, Point point, Point point2, String string, Font font, Color color) {
        graphics2D.draw(new Line2D.Double(point.x, point.y, point2.x, point2.y));
        int n = point.x + (point2.x - point.x) / 2 - 40;
        int n2 = point.y + (point2.y - point.y) / 2 - 5;
        if (point.y != point2.y) {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(n, n2, 80, 10);
        } else {
            n2 -= 10;
        }
        ImageUtil.drawText((Graphics2D)graphics2D, (String)string, (Font)font, (Color)color, (int)n, (int)n2, (float)80.0f, (int)3);
    }
}

