/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;

public abstract class AbstractProcessElementLayout
extends AbstractElementLayout {
    protected Process owningProcess = null;
    protected String elementProcessPath = null;
    protected String relProcessPath = null;
    protected String[] paths = null;
    protected String displayName = null;

    public void init(ElementLayoutManager elementLayoutManager, MethodElement methodElement, Process process, String string) {
        this.init(elementLayoutManager, methodElement);
        this.owningProcess = process;
        this.elementProcessPath = string;
        if (this.owningProcess == null) {
            this.owningProcess = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)this.element));
        }
        if (LibraryUtil.isProcess((EObject)methodElement)) {
            this.owningProcess = (Process)methodElement;
            this.relProcessPath = this.elementProcessPath = AbstractProcessElementLayout.makePath(null, methodElement);
        }
        if (this.elementProcessPath == null && this.element instanceof BreakdownElement) {
            this.elementProcessPath = AbstractProcessElementLayout.getPath((BreakdownElement)this.element);
        }
        this.paths = AbstractProcessElementLayout.getPathArray(this.elementProcessPath);
    }

    public void setRelativeProcessPath(String string) {
        this.relProcessPath = string;
    }

    public String getRelativeProcessPath() {
        return this.relProcessPath;
    }

    public String getQueryString() {
        return ElementLayoutManager.getQueryString(this.owningProcess.getGuid(), this.elementProcessPath);
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            ConfigurableComposedAdapterFactory configurableComposedAdapterFactory;
            Process process = this.getOwningProcess();
            Suppression suppression = this.getSuppression(process);
            Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)(configurableComposedAdapterFactory = this.layoutManager.getCBSAdapterFactory()));
            if (object == null) {
                object = this.element;
            }
            IBSItemProvider iBSItemProvider = (IBSItemProvider)configurableComposedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
            this.displayName = ProcessUtil.getAttribute((Object)this.element, (String)"presentation_name", (Object)iBSItemProvider);
        }
        return this.displayName;
    }

    protected Suppression getSuppression(Process process) {
        return this.layoutManager.getSuppression(process);
    }

    protected XmlElement getXmlElement() {
        XmlElement xmlElement = super.getXmlElement();
        xmlElement.setAttribute("queryString", this.getQueryString()).setAttribute("relProcessPath", this.relProcessPath);
        return xmlElement;
    }

    protected Process getOwningProcess() {
        return this.owningProcess;
    }

    protected IElementLayout getLayout(ProcessElementItem processElementItem) {
        IElementLayout iElementLayout = this.layoutManager.createLayout(processElementItem.element, this.owningProcess, processElementItem.path);
        if (iElementLayout instanceof AbstractProcessElementLayout) {
            String string = AbstractProcessElementLayout.getRelativePath(processElementItem.path, this.elementProcessPath);
            ((AbstractProcessElementLayout)iElementLayout).setRelativeProcessPath(string);
        }
        return iElementLayout;
    }

    public static String makePath(String string, MethodElement methodElement) {
        if (string == null || string.length() == 0) {
            return methodElement.getGuid();
        }
        return String.valueOf(string) + "," + methodElement.getGuid();
    }

    public static String getPath(BreakdownElement breakdownElement) {
        String string = breakdownElement.getGuid();
        BreakdownElement breakdownElement2 = breakdownElement;
        Process process = TngUtil.getOwningProcess((BreakdownElement)breakdownElement);
        while (breakdownElement2 != process) {
            Activity activity = breakdownElement2.getSuperActivities();
            if (activity == null) break;
            breakdownElement2 = activity;
            string = String.valueOf(breakdownElement2.getGuid()) + "," + string;
        }
        return string;
    }

    public static String getPath(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        Object object = LibraryUtil.unwrap(breakdownElementWrapperItemProvider);
        if (!(object instanceof MethodElement)) {
            return null;
        }
        Object object2 = breakdownElementWrapperItemProvider.getTopItem();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((MethodElement)object).getGuid());
        Object object3 = breakdownElementWrapperItemProvider;
        while (object3 != null && object3 != object2) {
            if (object3 instanceof BreakdownElement) {
                object3 = ((BreakdownElement)object3).getSuperActivities();
                object = object3;
            } else {
                if (!(object3 instanceof BreakdownElementWrapperItemProvider)) break;
                object3 = object3.getParent(object3);
                object = LibraryUtil.unwrap(object3);
            }
            if (!(object instanceof MethodElement)) continue;
            stringBuffer.insert(0, String.valueOf(((MethodElement)object).getGuid()) + ",");
        }
        return stringBuffer.toString();
    }

    public static String getRelativePath(String string, String string2) {
        if (string == null) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String[] getPathArray(String string) {
        Object object;
        if (string == null) {
            return new String[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            if (((String)object).length() <= 0) continue;
            arrayList.add(object);
        }
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public static String getOwningProcessGuidFromPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(",");
        String string2 = n < 0 ? string : string.substring(0, n);
        return string2;
    }

    public static String getParentPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(",");
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }
}

