/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.List;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;

public class SummaryPageLayout
implements IElementLayout {
    private static final String LAYOUT_TYPE = "Summary";
    private static final String LAYOUT_XSL = "summary.xsl";
    ElementLayoutManager layoutManager;
    MethodElement element;
    List refList;
    String title;
    String prefix;
    IElementLayout elementLayout;

    public SummaryPageLayout(ElementLayoutManager elementLayoutManager, MethodElement methodElement, String string, List list) {
        this.layoutManager = elementLayoutManager;
        this.element = methodElement;
        this.refList = list;
        this.title = string;
        this.elementLayout = elementLayoutManager.getLayout(methodElement, true);
    }

    public SummaryPageLayout(ElementLayoutManager elementLayoutManager, MethodElement methodElement, String string, String string2, List list) {
        this.layoutManager = elementLayoutManager;
        this.element = methodElement;
        this.refList = list;
        this.title = string2;
        this.prefix = string != null && string.length() > 0 && string.indexOf("null") < 0 ? string : LAYOUT_TYPE;
        this.elementLayout = elementLayoutManager.getLayout(methodElement, true);
    }

    public String getId() {
        return this.element.getGuid();
    }

    public String getType() {
        return LAYOUT_TYPE;
    }

    public String getName() {
        return this.title;
    }

    public String getDisplayName() {
        return this.title;
    }

    public String getUrl() {
        return String.valueOf(this.elementLayout.getFilePath()) + this.getFileName(".html");
    }

    public String getShapeiconUrl() {
        return null;
    }

    public String getNodeiconUrl() {
        return null;
    }

    public String getDiagramiconUrl() {
        return null;
    }

    public String getXslUrl() {
        return LAYOUT_XSL;
    }

    public String getBackPath() {
        return this.elementLayout.getBackPath();
    }

    public String getFilePath() {
        return this.elementLayout.getFilePath();
    }

    public String getFilePath(IElementLayout iElementLayout) {
        return this.elementLayout.getFilePath(iElementLayout);
    }

    public String getFileName(String string) {
        return String.valueOf(StrUtil.removeSpecialCharacters((String)(String.valueOf(this.prefix) + "_"))) + this.elementLayout.getFileName(string);
    }

    public MethodElement getElement() {
        return this.element;
    }

    public ElementLayoutManager getLayoutMgr() {
        return this.layoutManager;
    }

    public XmlElement getXmlElement(boolean bl) {
        XmlElement xmlElement = new XmlElement("Element").setAttribute("Type", this.getType()).setAttribute("Name", this.getName()).setAttribute("Url", this.getUrl()).setAttribute("BackPath", this.getBackPath()).setAttribute("ImageUrl", this.getShapeiconUrl()).setAttribute("DisplayName", this.getDisplayName());
        if (bl) {
            String string = ConfigurationHelper.getCopyrightText(this.element, this.layoutManager.getConfiguration());
            if (string != null && string.length() > 0) {
                xmlElement.newChild("copyright").setValue(string);
            }
            XmlElement xmlElement2 = xmlElement.newChild("referenceList").setAttribute("name", "");
            for (Object e : this.refList) {
                IElementLayout iElementLayout;
                if (!(e instanceof MethodElement)) continue;
                MethodElement methodElement = (MethodElement)e;
                if ((methodElement = ConfigurationHelper.getCalculatedElement(methodElement, this.layoutManager.getConfiguration())) == null || (iElementLayout = this.layoutManager.getLayout(methodElement, true)) == null) continue;
                xmlElement2.addChild(iElementLayout.getXmlElement(false));
            }
        }
        return xmlElement;
    }

    public List getLayouts() {
        return null;
    }

    public String getFileName(LayoutInfo layoutInfo, String string) {
        return ResourceHelper.getFileName(this.element, null, layoutInfo.name, string);
    }

    public void setContentTarget(MethodElement methodElement) {
    }

    public void setElementOwner(MethodElement methodElement) {
    }

    public boolean needContentScan(String string) {
        return false;
    }

    public void setShowElementLink(boolean bl) {
    }
}

