/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.util;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.util.IXmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;

public class XmlElement
implements IXmlElement {
    public static final String BR = FileUtil.LINE_SEP;
    private static String NODE_ID = "nodeId";
    private String element_name = null;
    private String element_value = null;
    private Map attributes = new HashMap();
    private Map contents = new HashMap();
    private List children = new ArrayList();
    private String id = null;

    public XmlElement(String string) {
        this(string, null);
    }

    public XmlElement(String string, String string2) {
        this.element_name = string;
        if (string2 == null) {
            string2 = Integer.toHexString(this.toString().hashCode());
        }
        this.id = string2;
        this.setAttribute(NODE_ID, this.id);
    }

    public XmlElement setAttribute(String string, String string2) {
        this.attributes.put(string, string2);
        return this;
    }

    public XmlElement setValue(String string) {
        this.element_value = string;
        return this;
    }

    public XmlElement setContent(String string, Object object) {
        this.contents.put(string, object);
        return this;
    }

    public XmlElement addChild(XmlElement xmlElement) {
        this.children.add(xmlElement);
        return this;
    }

    public XmlElement newChild(String string) {
        return this.newChild(string, null);
    }

    public XmlElement newChild(String string, String string2) {
        XmlElement xmlElement = new XmlElement(string, string2);
        this.children.add(xmlElement);
        return xmlElement;
    }

    public String getId() {
        return this.id;
    }

    public StringBuffer toXml() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.contents.size() == 0 && this.children.size() == 0) {
            stringBuffer.append(XmlHelper.getElement(this.element_name, this.element_value, this.attributes)).append(BR);
        } else {
            stringBuffer.append(XmlHelper.beginElement(this.element_name, this.attributes)).append(BR);
            for (Map.Entry object : this.contents.entrySet()) {
                String string = (String)object.getKey();
                Object v = object.getValue();
                if (v instanceof List) {
                    Iterator iterator = ((List)v).iterator();
                    while (iterator.hasNext()) {
                        stringBuffer.append(XmlHelper.getElement(string, iterator.next().toString(), null)).append(BR);
                    }
                    continue;
                }
                stringBuffer.append(XmlHelper.getElement(string, v == null ? "" : v.toString(), null)).append(BR);
            }
            for (IXmlElement iXmlElement : this.children) {
                stringBuffer.append(iXmlElement.toXml());
            }
            stringBuffer.append(XmlHelper.endElement(this.element_name)).append(BR);
        }
        return stringBuffer;
    }

    public void saveTo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XmlHelper.XML_HEADER).append(this.toXml());
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(string), "utf-8");
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

