/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.prefs;

import com.ibm.icu.util.StringTokenizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.prefs.BSColumn;
import org.eclipse.epf.library.prefs.PreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public class PreferenceUtil {
    private static Properties xslParams;
    private static Map colIdLabelMap;
    private static BSColumn teamCol;
    private static final String ID_STEPS = "steps";

    static {
        colIdLabelMap = new HashMap();
        teamCol = null;
        try {
            xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            colIdLabelMap.put("id", PreferenceUtil.getLabel("indexText"));
            colIdLabelMap.put("name", PreferenceUtil.getLabel("nameText"));
            colIdLabelMap.put("presentation_name", PreferenceUtil.getLabel("breakdownElementText"));
            colIdLabelMap.put(ID_STEPS, PreferenceUtil.getLabel("stepsText"));
            colIdLabelMap.put("prefix", PreferenceUtil.getLabel("prefixText"));
            colIdLabelMap.put("type", PreferenceUtil.getLabel("typeText"));
            colIdLabelMap.put("model_info", PreferenceUtil.getLabel("modelInfoText"));
            colIdLabelMap.put("predecessors", PreferenceUtil.getLabel("predecessorsText"));
            colIdLabelMap.put("is_repeatable", PreferenceUtil.getLabel("repeatableText"));
            colIdLabelMap.put("is_ongoing", PreferenceUtil.getLabel("ongoingText"));
            colIdLabelMap.put("is_event_driven", PreferenceUtil.getLabel("eventDrivenText"));
            colIdLabelMap.put("is_optional", PreferenceUtil.getLabel("optionalText"));
            colIdLabelMap.put("is_planned", PreferenceUtil.getLabel("plannedText"));
            colIdLabelMap.put("has_multiple_occurrences", PreferenceUtil.getLabel("multipleOccurrencesText"));
            colIdLabelMap.put("teams", PreferenceUtil.getLabel("teamText"));
            colIdLabelMap.put("deliverable", PreferenceUtil.getLabel("deliverableText"));
            colIdLabelMap.put("entry_state", PreferenceUtil.getLabel("entryStateText"));
            colIdLabelMap.put("exit_state", PreferenceUtil.getLabel("exitStateText"));
        }
        catch (IOException iOException) {}
    }

    private static String getLabel(String string) {
        String string2 = xslParams.getProperty(string);
        if (string2 == null) {
            System.out.println("Can't find property entry for " + string);
            string2 = string;
        }
        return string2;
    }

    public static List getWBSColumns() {
        List list = PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.wbs_columns");
        teamCol = null;
        PreferenceUtil.getTBSColumns();
        if (teamCol != null) {
            list.add(list.size(), teamCol);
        }
        return list;
    }

    public static List getTBSColumns() {
        return PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.tbs_columns");
    }

    public static List getWPBSColumns() {
        return PreferenceUtil.getPreferenceItems("org.eclipse.epf.library.edit.wpbs_columns");
    }

    public static void validatePreferences() {
        PreferenceUtil.getWBSColumns();
        PreferenceUtil.getTBSColumns();
        PreferenceUtil.getWPBSColumns();
    }

    private static List getPreferenceItems(String string) {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        String string2 = iPreferenceStore.getString(string);
        if (string2 == null) {
            string2 = iPreferenceStore.getDefaultString(string);
        }
        if (string2 == null || string2.length() == 0) {
            string2 = PreferenceUtil.getDefault(string);
            iPreferenceStore.setValue(string, string2);
        }
        ArrayList<BSColumn> arrayList = new ArrayList<BSColumn>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3 == null || string3.length() == 0) continue;
            BSColumn bSColumn = new BSColumn(string3, PreferenceUtil.getColText(string3));
            arrayList.add(bSColumn);
            if (string.equals("org.eclipse.epf.library.edit.wbs_columns") && string3.equals("presentation_name")) {
                bSColumn = new BSColumn(ID_STEPS, PreferenceUtil.getColText(ID_STEPS));
                arrayList.add(bSColumn);
            }
            if (!"teams".equals(string3)) continue;
            teamCol = bSColumn;
        }
        return arrayList;
    }

    private static String getColText(String string) {
        String string2 = (String)colIdLabelMap.get(string);
        if (string2 == null) {
            System.out.println("No label defined for column " + string);
            string2 = string;
        }
        return string2;
    }

    private static String getDefault(String string) {
        if ("org.eclipse.epf.library.edit.wbs_columns".equals(string)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_WBS_COLUMNS);
        }
        if ("org.eclipse.epf.library.edit.tbs_columns".equals(string)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_TBS_COLUMNS);
        }
        if ("org.eclipse.epf.library.edit.wpbs_columns".equals(string)) {
            return PreferenceUtil.toString(PreferenceConstants.DEFAULT_WPBS_COLUMNS);
        }
        return null;
    }

    private static String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(stringArray[n2]).append(',');
            ++n2;
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return stringBuffer.toString();
    }

    public static void saveSelectedConfigIntoPersistence(String string) {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        iPreferenceStore.setValue("org.eclipse.epf.library.pref.selected_config_in_last_session", string);
        LibraryPlugin.getDefault().savePluginPreferences();
    }

    public static String getSavedLastConfig() {
        IPreferenceStore iPreferenceStore = LibraryPlugin.getDefault().getPreferenceStore();
        return iPreferenceStore.getString("org.eclipse.epf.library.pref.selected_config_in_last_session");
    }
}

