/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaPackage;

public class ContentResourceScanner {
    protected static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    private File sourceRootPath;
    private File targetRootPath;
    private String rootContentPath;
    private IContentValidator validator;
    private List processedItems = new ArrayList();

    public ContentResourceScanner(File file, File file2, String string) {
        this(file, file2, string, null);
    }

    public ContentResourceScanner(File file, File file2, String string, IContentValidator iContentValidator) {
        this.sourceRootPath = file;
        this.targetRootPath = file2;
        this.rootContentPath = string;
        this.validator = iContentValidator;
    }

    public void setValidator(IContentValidator iContentValidator) {
        this.validator = iContentValidator;
    }

    public File getSourceRootPath() {
        return this.sourceRootPath;
    }

    public File getTargetRootPath() {
        return this.targetRootPath;
    }

    public void setTargetRootPath(File file) {
        this.targetRootPath = file;
    }

    public void resolveResources(String string, String string2) {
        this.resolveResources(null, string, string2);
    }

    public void resolveResources(MethodElement methodElement, String string, String string2) {
        this.processedItems.clear();
        ResourceHelper.resolveResources(methodElement, null, string, string2, this.sourceRootPath, this.targetRootPath, this.rootContentPath, this.processedItems, this.validator);
    }

    public String resolveResourcesPlugin(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            CharSequence charSequence;
            Matcher matcher = ResourceHelper.p_image_ref.matcher(string);
            while (matcher.find()) {
                charSequence = matcher.group(3);
                charSequence = this.processResourceUrlPlugin((String)charSequence, string2, string3);
                matcher.appendReplacement(stringBuffer, String.valueOf(matcher.group(1)) + (String)charSequence + matcher.group(4));
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
            stringBuffer = new StringBuffer();
            matcher = ResourceHelper.p_link_ref_gen.matcher(string);
            while (matcher.find()) {
                Matcher matcher2;
                charSequence = new StringBuffer();
                String string4 = " " + matcher.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(string4) != null || !(matcher2 = ResourceHelper.p_link_href_picker.matcher(string4)).find()) continue;
                String string5 = matcher2.group(1).trim().replaceAll("\"", "");
                string5 = this.processResourceUrlPlugin(string5, string2, string3);
                matcher2.appendReplacement((StringBuffer)charSequence, String.valueOf(string4.substring(matcher2.start(), matcher2.start(1))) + string5 + string4.substring(matcher2.end(1), matcher2.end()));
                matcher2.appendTail((StringBuffer)charSequence);
                matcher.appendReplacement(stringBuffer, String.valueOf(string.substring(matcher.start(), matcher.start(2))) + ((StringBuffer)charSequence).toString() + string.substring(matcher.end(2), matcher.end()));
            }
            matcher.appendTail(stringBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private String processResourceUrlPlugin(String string, String string2, String string3) {
        String string4 = ResourceHelper.getFilePathFromUrl(string, string3);
        if (string4 == null) {
            return string;
        }
        String string5 = null;
        File file = new File(this.sourceRootPath.getParentFile(), string4);
        if (string4.indexOf(File.separator) != -1) {
            String string6 = string4.substring(0, string4.indexOf(File.separator));
            String string7 = this.targetRootPath.getName();
            string5 = string.replaceFirst(string6, string7);
            string4 = string4.substring(string4.indexOf(File.separator));
        }
        File file2 = new File(this.targetRootPath, string4);
        FileUtil.copyFile((File)file, (File)file2);
        return string5;
    }

    public void copyResources(EObject eObject) {
        if (eObject == null) {
            return;
        }
        if (eObject instanceof DescribableElement) {
            String string;
            DescribableElement describableElement = (DescribableElement)eObject;
            String string2 = ResourceHelper.getElementPath((MethodElement)describableElement);
            URI uRI = describableElement.getShapeicon();
            if (uRI != null) {
                string = uRI.getPath();
                FileUtil.copyFile((File)new File(this.getSourceRootPath(), string), (File)new File(this.getTargetRootPath(), string));
            }
            if ((uRI = describableElement.getNodeicon()) != null) {
                string = uRI.getPath();
                FileUtil.copyFile((File)new File(this.getSourceRootPath(), string), (File)new File(this.getTargetRootPath(), string));
            }
            if ((string = describableElement.getPresentation()).eContainer() != null) {
                List list = LibraryUtil.getStructuralFeatures((MethodElement)string);
                int n = 0;
                while (n < list.size()) {
                    Object object;
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                    if (eStructuralFeature instanceof EAttribute && (object = string.eGet(eStructuralFeature)) != null) {
                        String string3;
                        StringTokenizer stringTokenizer;
                        Object object2;
                        if (eStructuralFeature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                            object2 = (List)object;
                            stringTokenizer = object2.iterator();
                            while (stringTokenizer.hasNext()) {
                                string3 = ((Section)stringTokenizer.next()).getSectionDescription();
                                this.resolveResources((MethodElement)describableElement, string3, string2);
                            }
                        } else if (eStructuralFeature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
                            object2 = object.toString().trim();
                            if (((String)object2).length() != 0) {
                                stringTokenizer = new StringTokenizer((String)object2, "|");
                                while (stringTokenizer.hasMoreTokens()) {
                                    string3 = stringTokenizer.nextToken();
                                    FileUtil.copyFile((File)new File(this.getSourceRootPath(), String.valueOf(string2) + string3), (File)new File(this.getTargetRootPath(), String.valueOf(string2) + string3));
                                }
                            }
                        } else if (object instanceof String) {
                            this.resolveResources((MethodElement)describableElement, object.toString(), string2);
                        }
                    }
                    ++n;
                }
            }
        }
    }
}

