/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class FileNameGenerator {
    public static FileNameGenerator INSTANCE = new FileNameGenerator();
    private Map<String, String> nameToGuidMap = new HashMap<String, String>();
    private Map<String, String> guidToNameMap = new HashMap<String, String>();
    private Map<String, Integer> baseNameIndexMap = new HashMap<String, Integer>();
    private ILibraryServiceListener svcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration methodConfiguration) {
        }

        public void libraryClosed(MethodLibrary methodLibrary) {
            FileNameGenerator.this.clear();
        }

        public void libraryCreated(MethodLibrary methodLibrary) {
            FileNameGenerator.this.clear();
        }

        public void libraryOpened(MethodLibrary methodLibrary) {
            FileNameGenerator.this.clear();
        }

        public void libraryReopened(MethodLibrary methodLibrary) {
            FileNameGenerator.this.clear();
        }

        public void librarySet(MethodLibrary methodLibrary) {
        }
    };

    private FileNameGenerator() {
        LibraryService.getInstance().addListener(this.svcListener);
    }

    public synchronized String getGuidFromFileName(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        return this.getGuidFromUniqueName(this.getUniqueName(string));
    }

    public synchronized String getFileName(MethodElement methodElement, String string, String string2, String string3) {
        String string4 = this.getUniqueNameForGuid(methodElement.getGuid(), methodElement.getName());
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(string4);
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (string3 != null) {
            if (string3.indexOf(".") < 0) {
                string3 = "." + string3;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void clear() {
        this.nameToGuidMap.clear();
        this.guidToNameMap.clear();
        this.baseNameIndexMap.clear();
    }

    private String getUniqueNameForGuid(String string, String string2) {
        String string3;
        if (string == null || string.equals("")) {
            return "";
        }
        String string4 = this.guidToNameMap.get(string);
        if (string4 != null) {
            return string4;
        }
        if (string2 == null) {
            string2 = "";
        }
        string2 = String.valueOf(string2) + "_" + Integer.toHexString(string.hashCode()).toUpperCase();
        string4 = string3 = StrUtil.removeSpecialCharacters((String)string2);
        Integer n = this.baseNameIndexMap.get(string3);
        if (n == null) {
            n = new Integer(1);
        } else {
            n = n + 1;
            string4 = String.valueOf(string3) + "-" + n.toString();
        }
        this.baseNameIndexMap.put(string3, n);
        this.guidToNameMap.put(string, string4);
        this.nameToGuidMap.put(string4, string);
        return string4;
    }

    private String getGuidFromUniqueName(String string) {
        return this.nameToGuidMap.get(string);
    }

    private String getUniqueName(String string) {
        try {
            File file = new File(string);
            string = file.getName();
            int n = string.lastIndexOf(".");
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

