/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportPluginSummaryPage
extends BaseWizardPage {
    public static final String PAGE_NAME = ExportPluginSummaryPage.class.getName();
    private TextViewer textViewer;
    private TextPresentation style;
    private PluginExportData data;

    public ExportPluginSummaryPage(PluginExportData pluginExportData) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.exportPluginSummaryPage_title);
        this.setDescription(ExportResources.exportPluginSummaryPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportMethodPlugins.gif"));
        this.data = pluginExportData;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.textViewer = ExportPluginSummaryPage.createTextViewer((Composite)composite2, (int)360, (int)160, (int)1);
        Document document = new Document("");
        this.textViewer.setDocument((IDocument)document);
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    private void displaySummary() {
        this.style = new TextPresentation();
        Document document = this.getSummaryText();
        this.textViewer.setDocument((IDocument)document);
        this.textViewer.changeTextPresentation(this.style, true);
    }

    public void onEnterPage(Object object) {
        this.displaySummary();
    }

    public Document getSummaryText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.data.selectedPlugins == null || this.data.selectedPlugins.isEmpty()) {
            return new Document(ExportResources.exportPluginSummaryPage_noPlugin_text);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.data.selectedPlugins.size()) {
            Object object2;
            MethodPlugin methodPlugin = (MethodPlugin)this.data.selectedPlugins.get(n3);
            n = stringBuffer.length();
            n2 = methodPlugin.getName().length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 1));
            stringBuffer.append(methodPlugin.getName()).append("\n");
            n = stringBuffer.length();
            n2 = AuthoringUIText.AUTHORS_TEXT.length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 3));
            stringBuffer.append("\t").append(AuthoringUIText.AUTHORS_TEXT).append("\n");
            stringBuffer.append("\t\t").append(methodPlugin.getAuthors()).append("\n");
            n = stringBuffer.length();
            n2 = AuthoringUIText.VERSION_TEXT.length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 3));
            stringBuffer.append("\t").append(AuthoringUIText.VERSION_TEXT).append("\n");
            stringBuffer.append("\t\t").append(methodPlugin.getVersion()).append("\n");
            n = stringBuffer.length();
            n2 = AuthoringUIText.BRIEF_DESCRIPTION_TEXT.length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 3));
            stringBuffer.append("\t").append(AuthoringUIText.BRIEF_DESCRIPTION_TEXT).append("\n");
            stringBuffer.append("\t\t").append(methodPlugin.getBriefDescription()).append("\n");
            n = stringBuffer.length();
            n2 = ExportResources.reviewPluginsPage_dependentPluginsLabel_text.length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 3));
            stringBuffer.append("\t").append(ExportResources.reviewPluginsPage_dependentPluginsLabel_text).append("\n");
            List list = methodPlugin.getBases();
            boolean bl = true;
            for (Object object2 : list) {
                stringBuffer.append("\t\t").append(object2.getName()).append("\n");
                bl = false;
            }
            if (bl) {
                stringBuffer.append("\n");
            }
            n = stringBuffer.length();
            n2 = ExportResources.reviewPluginsPage_associatedConfigsLabel_text.length();
            this.style.addStyleRange(new StyleRange(n, n2, null, null, 3));
            stringBuffer.append("\t").append(ExportResources.reviewPluginsPage_associatedConfigsLabel_text).append("\n");
            List list2 = (List)this.data.associatedConfigMap.get(methodPlugin);
            object2 = list2.iterator();
            while (object2.hasNext()) {
                MethodConfiguration methodConfiguration = (MethodConfiguration)object2.next();
                stringBuffer.append("\t\t").append(methodConfiguration.getName()).append("\n");
            }
            stringBuffer.append("\n");
            ++n3;
        }
        Document document = new Document(stringBuffer.toString());
        return document;
    }
}

