/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.diagram.wpdd.edit.parts.LinkEditPart;
import org.eclipse.epf.diagram.wpdd.edit.parts.LinkNameEditPart;
import org.eclipse.epf.diagram.wpdd.edit.parts.WorkProductDependencyDiagramEditPart;
import org.eclipse.epf.diagram.wpdd.edit.parts.WorkProductNodeEditPart;
import org.eclipse.epf.diagram.wpdd.edit.parts.WorkProductNodeNameEditPart;
import org.eclipse.epf.diagram.wpdd.part.DiagramVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class DiagramEditPartFactory
implements EditPartFactory {
    public EditPart createEditPart(EditPart editPart, Object object) {
        if (object instanceof View) {
            View view = (View)object;
            switch (DiagramVisualIDRegistry.getVisualID(view)) {
                case 79: {
                    return new WorkProductDependencyDiagramEditPart(view);
                }
                case 1001: {
                    return new WorkProductNodeEditPart(view);
                }
                case 4001: {
                    return new WorkProductNodeNameEditPart(view);
                }
                case 3001: {
                    return new LinkEditPart(view);
                }
                case 4002: {
                    return new LinkNameEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(editPart, object);
    }

    private EditPart createUnrecognizedEditPart(EditPart editPart, Object object) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart iTextAwareEditPart) {
        if (iTextAwareEditPart.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)iTextAwareEditPart.getFigure());
        }
        return new LabelCellEditorLocator((Label)iTextAwareEditPart.getFigure());
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor cellEditor) {
            Text text = (Text)cellEditor.getControl();
            Rectangle rectangle = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rectangle);
            int n = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rectangle.setSize(new Dimension(text.computeSize(-1, -1)).expand(n * 2, 0));
            if (!rectangle.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor cellEditor) {
            Text text = (Text)cellEditor.getControl();
            Rectangle rectangle = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rectangle);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rectangle.setSize(new Dimension(text.computeSize(rectangle.width, -1)));
            } else {
                int n = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rectangle.setSize(new Dimension(text.computeSize(-1, -1)).expand(n * 2, 0));
            }
            if (!rectangle.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }
}

