/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ADDiagramEditor;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramEditorHelper {
    private Map<Process, DiagramManager> processToDiagramManagerMap = new HashMap<Process, DiagramManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramManager getDiagramManager(Process process) {
        DiagramManager diagramManager = this.processToDiagramManagerMap.get(process);
        if (diagramManager != null && diagramManager.isDisposed()) {
            this.processToDiagramManagerMap.remove(process);
            diagramManager = null;
        }
        if (diagramManager == null) {
            Map<Process, DiagramManager> map = this.processToDiagramManagerMap;
            synchronized (map) {
                diagramManager = this.processToDiagramManagerMap.get(process);
                if (diagramManager == null) {
                    diagramManager = DiagramManager.getInstance((Process)process, (Object)this);
                    this.processToDiagramManagerMap.put(process, diagramManager);
                }
            }
        }
        return diagramManager;
    }

    public void openDiagram(IEditorPart iEditorPart, int n, Object object, Suppression suppression) {
        try {
            DiagramEditorInput diagramEditorInput = new DiagramEditorInput(object, suppression, n);
            DiagramEditorUtil.openDiagramEditor((IWorkbenchPage)iEditorPart.getSite().getPage(), (DiagramEditorInput)diagramEditorInput, (PreferencesHint)DiagramEditorHelper.getDiagramPreferencesHint(n), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (RuntimeException runtimeException) {
            DiagramUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
        }
    }

    public Diagram getDiagram(Activity activity, int n) {
        Diagram diagram = null;
        DiagramManager diagramManager = this.getDiagramManager(TngUtil.getOwningProcess((BreakdownElement)activity));
        if (diagramManager != null) {
            try {
                List list = diagramManager.getDiagrams(activity, n);
                if (!list.isEmpty()) {
                    diagram = (Diagram)list.get(0);
                }
            }
            catch (Exception exception) {
                DiagramUIPlugin.getDefault().getLogger().logError("Core error retrieving a diagram in process editor:", (Throwable)exception);
            }
        }
        return diagram;
    }

    public Collection getDiagrams(Activity activity) {
        DiagramManager diagramManager = this.getDiagramManager(TngUtil.getOwningProcess((BreakdownElement)activity));
        try {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < DiagramHelper.DIAGRAM_TYPES.length) {
                List list = diagramManager.getDiagrams(activity, DiagramHelper.DIAGRAM_TYPES[n]);
                if (!list.isEmpty()) {
                    arrayList.addAll(list);
                }
                ++n;
            }
            return arrayList;
        }
        catch (Exception exception) {
            return Collections.EMPTY_LIST;
        }
    }

    public void dispose() {
        for (DiagramManager diagramManager : this.processToDiagramManagerMap.values()) {
            try {
                diagramManager.removeConsumer((Object)this);
            }
            catch (Exception exception) {}
        }
    }

    public static int getDiagramType(Diagram diagram) {
        return DiagramHelper.getDiagramType((Diagram)diagram);
    }

    public static String getDiagramTypeString(Diagram diagram) {
        return DiagramHelper.getDiagramTypeString((Diagram)diagram);
    }

    public static PreferencesHint getDiagramPreferencesHint(int n) {
        switch (n) {
            case 0: {
                return ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 2: {
                return ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 1: {
                return WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
        }
        return null;
    }

    public static void closeDiagramEditors(Object object, List<IEditorReference> list) {
        IEditorReference[] iEditorReferenceArray;
        list = new ArrayList<IEditorReference>();
        IWorkbenchPage iWorkbenchPage = DiagramUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray2.length) {
            iEditorReferenceArray = iEditorReferenceArray2[n];
            IEditorPart iEditorPart = iEditorReferenceArray.getEditor(true);
            if (iEditorPart != null) {
                Object object2;
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                Object object3 = null;
                if (iEditorInput instanceof DiagramEditorInputProxy) {
                    object2 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput();
                    if (object2.getWrapper() != null) {
                        Object object4;
                        object3 = object2.getWrapper();
                        if (object3 instanceof BreakdownElementWrapperItemProvider && (object4 = ((BreakdownElementWrapperItemProvider)object3).getParent(object3)) instanceof BreakdownElementWrapperItemProvider && object3.equals(object)) {
                            DiagramEditorHelper.closeDiagramEditors(object4, list);
                        }
                    } else {
                        object3 = object2.getMethodElement();
                    }
                }
                if (object3 != null) {
                    if (object3.equals(object)) {
                        list.add((IEditorReference)iEditorReferenceArray);
                    } else if (object instanceof Activity) {
                        object2 = new ArrayList();
                        ProcessUtil.getChildElements((Activity)((Activity)object), Activity.class, (Collection)object2);
                        if (object2.contains(object3)) {
                            list.add((IEditorReference)iEditorReferenceArray);
                        }
                    }
                }
            }
            ++n;
        }
        n = list.size();
        iEditorReferenceArray = new IEditorReference[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorReferenceArray[n2] = list.get(n2);
            ++n2;
        }
        iWorkbenchPage.closeEditors(iEditorReferenceArray, false);
        iEditorReferenceArray = null;
    }

    public static void refreshParentDiagramEditors(Object object, List<IEditorReference> list, boolean bl) {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        list = new ArrayList<IEditorReference>();
        IWorkbenchPage iWorkbenchPage = DiagramUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart != null) {
                Object object2;
                iEditorInput = iEditorPart.getEditorInput();
                BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = null;
                if (iEditorInput instanceof DiagramEditorInputProxy) {
                    object2 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput();
                    if (object2.getWrapper() != null) {
                        Object object3;
                        breakdownElementWrapperItemProvider = object2.getWrapper();
                        if (bl && breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object3 = breakdownElementWrapperItemProvider.getParent(null)) instanceof BreakdownElementWrapperItemProvider && breakdownElementWrapperItemProvider.equals(object)) {
                            DiagramEditorHelper.refreshParentDiagramEditors(object3, list, bl);
                        }
                    } else {
                        breakdownElementWrapperItemProvider = object2.getMethodElement();
                    }
                }
                if (breakdownElementWrapperItemProvider != null) {
                    if (breakdownElementWrapperItemProvider instanceof Activity) {
                        if (!bl && breakdownElementWrapperItemProvider == object) {
                            list.add(iEditorReference);
                        }
                        if (((Activity)breakdownElementWrapperItemProvider).getBreakdownElements().contains(object)) {
                            list.add(iEditorReference);
                        } else if (object instanceof BreakdownElementWrapperItemProvider) {
                            object2 = object;
                            while (object2 instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object2).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)object2).getOwner().equals(breakdownElementWrapperItemProvider)) {
                                    list.add(iEditorReference);
                                }
                                object2 = ((BreakdownElementWrapperItemProvider)object2).getOwner();
                            }
                        }
                        if (((Activity)breakdownElementWrapperItemProvider).getVariabilityBasedOnElement() != null && (object2 = (Activity)((Activity)breakdownElementWrapperItemProvider).getVariabilityBasedOnElement()).getBreakdownElements().contains(object)) {
                            list.add(iEditorReference);
                        }
                    } else if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object2 = breakdownElementWrapperItemProvider.getChildren((Object)breakdownElementWrapperItemProvider)) != null && object2.contains(object)) {
                        list.add(iEditorReference);
                    }
                }
            }
            ++n;
        }
        n = list.size();
        int n2 = 0;
        while (n2 < n) {
            iEditorPart = list.get(n2);
            iEditorInput = iEditorPart.getEditor(true);
            if (iEditorInput instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)iEditorInput).refreshDiagram();
                if (iEditorInput instanceof ADDiagramEditor) {
                    ((ADDiagramEditor)iEditorInput).runResetLayoutAction();
                }
            }
            ++n2;
        }
    }

    public static void setDiagramOptions(Activity activity, int n) {
        switch (n) {
            case 0: {
                DiagramOptions.setPublishAD((Activity)activity, (boolean)false);
                break;
            }
            case 2: {
                DiagramOptions.setPublishADD((Activity)activity, (boolean)false);
                break;
            }
            case 1: {
                DiagramOptions.setPublishWPDD((Activity)activity, (boolean)false);
            }
        }
    }

    public static boolean isPublishDiagram(Activity activity, int n) {
        switch (n) {
            case 0: {
                return DiagramOptions.isPublishAD((Activity)activity);
            }
            case 2: {
                return DiagramOptions.isPublishADD((Activity)activity);
            }
            case 1: {
                return DiagramOptions.isPublishWPDD((Activity)activity);
            }
        }
        return false;
    }
}

