/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorPlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.diagram.ui.DiagramUIPlugin;
import org.eclipse.epf.diagram.ui.service.IDiagramImageService;
import org.eclipse.epf.diagram.ui.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.diagram.ui.viewer.NewActivityDetailDiagramViewer;
import org.eclipse.epf.diagram.ui.viewer.NewActivityDiagramViewer;
import org.eclipse.epf.diagram.ui.viewer.NewWPDependencyDiagramViewer;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.IMethodConfigurationProvider;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.DiagramOptions;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DiagramImageService
implements IDiagramImageService {
    static boolean debug = DiagramUIPlugin.getDefault().isDebugging();
    private Composite parent = null;
    private Composite holder = null;
    private File pubDir;
    private static Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo = null;
    private boolean publishUncreatedADD = true;
    private boolean publishADForActivityExtension = true;
    private boolean exist = true;
    private MethodConfiguration config = null;
    Shell shell = null;
    private Set<DiagramManager> diagramManagers = new HashSet<DiagramManager>();

    static {
        typeMap.put("Activity", new Integer(0));
        typeMap.put("ActivityDetail", new Integer(2));
        typeMap.put("WPDependency", new Integer(1));
    }

    public static int getIntType(String string) {
        Integer n = typeMap.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public static PreferencesHint getPreferenceHint(String string) {
        int n = DiagramImageService.getIntType(string);
        switch (n) {
            case 0: {
                return ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 2: {
                return ActivityDetailDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
            case 1: {
                return WPDDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
            }
        }
        return null;
    }

    public static String getStringType(int n) {
        switch (n) {
            case 0: {
                return "Activity";
            }
            case 2: {
                return "ActivityDetail";
            }
            case 1: {
                return "WPDependency";
            }
        }
        return null;
    }

    public DiagramImageService(File file) {
        this(null, file);
    }

    public DiagramImageService(Composite composite, File file) {
        this.parent = composite;
        this.pubDir = file;
    }

    private AbstractDiagramGraphicalViewer getDiagramViewer(int n, Object object) {
        if (this.shell != null && this.shell.isDisposed()) {
            this.parent = null;
            this.shell = null;
        }
        this.getViewerHolder(this.parent);
        switch (n) {
            case 0: {
                return new NewActivityDiagramViewer(this.holder, object);
            }
            case 2: {
                return new NewActivityDetailDiagramViewer(this.holder, object);
            }
            case 1: {
                return new NewWPDependencyDiagramViewer(this.holder, object);
            }
        }
        return null;
    }

    private void getViewerHolder(Composite composite) {
        if (composite == null) {
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = this.createShell();
            }
            this.shell.open();
            composite = this.shell;
        }
        if (this.holder != null) {
            this.holder.dispose();
        }
        this.holder = new Composite(composite, 0);
        this.holder.setLayoutData((Object)new GridData(1, 1));
        this.holder.setLayout((Layout)new GridLayout());
        this.holder.setVisible(false);
    }

    private Shell createShell() {
        Shell shell = null;
        Display display = Display.getDefault();
        shell = new Shell(display);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        shell.setLayout((Layout)gridLayout);
        shell.setBounds(0, 0, 0, 0);
        shell.setVisible(false);
        return shell;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
        for (DiagramManager diagramManager : this.diagramManagers) {
            diagramManager.removeConsumer((Object)this);
        }
    }

    public org.eclipse.epf.library.layout.diagram.DiagramInfo saveDiagram(final Object object, final String string, final String string2, final IFilter iFilter, final Suppression suppression) {
        this.diagramInfo = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                DiagramImageService.this.__internal_saveDiagram(object, string, string2, iFilter, suppression);
            }
        });
        return this.diagramInfo;
    }

    private boolean hasUserDefinedDiagram(Activity activity, String string, int n) throws Exception {
        DiagramInfo diagramInfo = new DiagramInfo(activity);
        switch (n) {
            case 0: {
                if (!diagramInfo.canPublishADImage()) break;
                return diagramInfo.getActivityDiagram() != null && diagramInfo.canPublishADImage();
            }
            case 2: {
                if (!diagramInfo.canPublishADDImage()) break;
                return diagramInfo.getActivityDetailDiagram() != null && diagramInfo.canPublishADDImage();
            }
            case 1: {
                if (!diagramInfo.canPublishWPDImage()) break;
                return diagramInfo.getWPDDiagram() != null && diagramInfo.canPublishWPDImage();
            }
        }
        return false;
    }

    private void __internal_saveDiagram(Object object, String string, String string2, IFilter iFilter, Suppression suppression) {
        if (suppression.isSuppressed(object)) {
            return;
        }
        int n = DiagramImageService.getIntType(string2);
        if (n < 0) {
            return;
        }
        this._internal_generateImage(object, string, n, iFilter, suppression, true, true);
    }

    public String generateDiagramImage(final Object object, final String string, final int n, final IFilter iFilter, final Suppression suppression, final boolean bl) {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                DiagramImageService.this._internal_generateImage(object, string, n, iFilter, suppression, false, bl);
            }
        });
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _internal_generateImage(Object object, String string, int n, IFilter iFilter, Suppression suppression, boolean bl, boolean bl2) {
        this.exist = true;
        Image image = null;
        Object object2 = TngUtil.unwrap((Object)object);
        if (!(object2 instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)object2;
        AbstractDiagramGraphicalViewer abstractDiagramGraphicalViewer = null;
        boolean bl3 = activity.eResource().isModified();
        try {
            Diagram diagram;
            Object object3 = this.canCreateImage(object, string, n, iFilter, suppression);
            if (bl2 && object3 == null) {
                return;
            }
            object = object3;
            try {
                abstractDiagramGraphicalViewer = this.getDiagramViewer(n, object);
                if (this.config != null) {
                    abstractDiagramGraphicalViewer.setMethodConfiguration(this.config);
                }
                if ((diagram = abstractDiagramGraphicalViewer.loadDiagram(object, !this.exist, iFilter, suppression)) == null) {
                    if (!debug) return;
                    DiagramUIPlugin.getDefault().getLogger().logError("Publishing: DiagramImageService viewer EditPart is null: " + object);
                    return;
                }
                if (diagram.getChildren().isEmpty()) {
                    return;
                }
                if (bl) {
                    this.diagramInfo = abstractDiagramGraphicalViewer.getDiagramInfo();
                }
                if ((image = abstractDiagramGraphicalViewer.createDiagramImage()) != null) {
                    File file = new File(this.pubDir, string);
                    File file2 = file.getParentFile();
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[]{image.getImageData()};
                    imageLoader.save((OutputStream)fileOutputStream, 4);
                } else {
                    DiagramUIPlugin.getDefault().getLogger().logError("Failed to create diagram image for" + activity);
                }
                if (bl && this.diagramInfo != null && !this.diagramInfo.isEmpty()) {
                    this.diagramInfo.setImageFilePath(string);
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
            if (this.exist) return;
            diagram = this.getDiagram(activity, n);
            if (diagram == null) return;
            DiagramHelper.deleteDiagram((Diagram)diagram, (boolean)false);
            return;
        }
        catch (Exception exception) {
            DiagramUIPlugin.getDefault().getLogger().logError("Exception" + activity);
            return;
        }
        finally {
            try {
                activity.eResource().setModified(bl3);
                if (abstractDiagramGraphicalViewer != null) {
                    abstractDiagramGraphicalViewer.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object canCreateImage(Object object, String string, int n, IFilter iFilter, Suppression suppression) {
        Object object2 = TngUtil.unwrap((Object)object);
        if (!(object2 instanceof Activity)) {
            return null;
        }
        try {
            Iterator iterator;
            Activity activity = (Activity)object2;
            if (this.hasUserDefinedDiagram(activity, string, n)) {
                return null;
            }
            Diagram diagram = this.getDiagram(activity, n);
            boolean bl = this.exist = diagram != null;
            if (this.exist) {
                if (!this.canPublishDiagram(diagram, activity)) {
                    return null;
                }
                if (n != 0 || !this.isBreakdownElementsReplaced(activity, iFilter)) return object;
                return null;
            }
            if (n == 1) {
                return null;
            }
            if (n == 0) {
                if (!this.publishADForActivityExtension) {
                    return null;
                }
                if (!activity.getBreakdownElements().isEmpty()) {
                    return null;
                }
                if (this.anyChildrenSuppressed(object, iFilter, suppression)) {
                    return null;
                }
                VariabilityElement variabilityElement = this.checkVariability((VariabilityElement)activity, iFilter, n);
                if (variabilityElement == null) {
                    return null;
                }
                object = variabilityElement;
                activity = (Activity)variabilityElement;
                this.exist = true;
            }
            if (this.publishUncreatedADD || n != 2) return object;
            boolean bl2 = false;
            MethodConfiguration methodConfiguration = null;
            if (iFilter instanceof ProcessAdapterFactoryFilter) {
                methodConfiguration = ((ProcessAdapterFactoryFilter)iFilter).getMethodConfiguration();
            }
            if (methodConfiguration == null) {
                return null;
            }
            List list = ConfigurationHelper.getContributors((VariabilityElement)activity, (MethodConfiguration)methodConfiguration);
            if (activity instanceof Activity && (iterator = list.iterator()) != null) {
                while (iterator.hasNext()) {
                    Diagram diagram2;
                    Object e = iterator.next();
                    if (e == null || (diagram2 = this.getDiagram((Activity)e, n)) == null) continue;
                    bl2 = true;
                    break;
                }
            }
            if (bl2) return object;
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean canPublishDiagram(Diagram diagram, Activity activity) {
        switch (DiagramHelper.getDiagramType((Diagram)diagram)) {
            case 0: {
                if (!DiagramOptions.isPublishAD((Activity)activity)) break;
                return true;
            }
            case 2: {
                if (!DiagramOptions.isPublishADD((Activity)activity)) break;
                return true;
            }
            case 1: {
                if (!DiagramOptions.isPublishWPDD((Activity)activity)) break;
                return true;
            }
        }
        return false;
    }

    private boolean anyChildrenSuppressed(Object object, IFilter iFilter, Suppression suppression) {
        Object object2;
        ITreeItemContentProvider iTreeItemContentProvider = this.getAdapter(object, iFilter);
        boolean bl = false;
        if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
            object2 = (BSActivityItemProvider)iTreeItemContentProvider;
            bl = object2.isRolledUp();
            object2.basicSetRolledUp(false);
        } else if (iTreeItemContentProvider instanceof IBSItemProvider) {
            object2 = (IBSItemProvider)iTreeItemContentProvider;
            bl = object2.isRolledUp();
            object2.setRolledUp(false);
        }
        try {
            object2 = TngUtil.unwrap((Object)object);
            for (Object e : iTreeItemContentProvider.getChildren(object2)) {
                if (!suppression.isSuppressed(e)) continue;
                return true;
            }
        }
        finally {
            if (iTreeItemContentProvider instanceof IBSItemProvider) {
                ((IBSItemProvider)iTreeItemContentProvider).setRolledUp(bl);
            }
        }
        return false;
    }

    private ITreeItemContentProvider getAdapter(Object object, IFilter iFilter) {
        Object object2 = null;
        object2 = object instanceof BreakdownElementWrapperItemProvider ? (BreakdownElementWrapperItemProvider)object : (ITreeItemContentProvider)this.getAdapterFactory(iFilter).adapt(object, ITreeItemContentProvider.class);
        return object2;
    }

    AdapterFactory getAdapterFactory(IFilter iFilter) {
        ComposedAdapterFactory composedAdapterFactory = null;
        if (iFilter == null) {
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (iFilter instanceof IAdapterFactoryFilter) {
            composedAdapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)iFilter).getWBSAdapterFactory();
        }
        return composedAdapterFactory;
    }

    private VariabilityElement checkVariability(VariabilityElement variabilityElement, IFilter iFilter, int n) {
        Object object2;
        MethodConfiguration methodConfiguration = null;
        if (iFilter instanceof ProcessAdapterFactoryFilter) {
            methodConfiguration = ((ProcessAdapterFactoryFilter)iFilter).getMethodConfiguration();
        }
        if (methodConfiguration == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)variabilityElement, (MethodConfiguration)methodConfiguration);
        for (Object object2 : list) {
            if (!(object2 instanceof Activity) || ((Activity)object2).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo variabilityInfo = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement);
        object2 = variabilityInfo.getContributors();
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (variabilityElement2 == null) {
            return null;
        }
        Activity activity = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)variabilityElement2, (MethodConfiguration)methodConfiguration);
        if (activity != null) {
            variabilityElement2 = activity;
            Diagram diagram = this.getDiagram(activity, n);
            if (diagram != null) {
                return activity;
            }
            return null;
        }
        Diagram diagram = this.getDiagram((Activity)variabilityElement2, n);
        if (diagram != null) {
            if (BridgeHelper.isSuppressed((View)diagram)) {
                return null;
            }
            VariabilityInfo variabilityInfo2 = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement2);
            List list2 = variabilityInfo2.getContributors();
            if (object2.size() != list2.size()) {
                for (Object e : object2) {
                    if (list2.contains(e) || ((Activity)e).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return variabilityElement2;
        }
        return this.checkVariability(variabilityElement2, iFilter, n);
    }

    public VariabilityElement checkVariability(VariabilityElement variabilityElement, IFilter iFilter, int n, boolean bl) {
        Object object2;
        MethodConfiguration methodConfiguration = null;
        DiagramInfo diagramInfo = null;
        if (iFilter instanceof ProcessAdapterFactoryFilter) {
            methodConfiguration = ((ProcessAdapterFactoryFilter)iFilter).getMethodConfiguration();
        }
        if (methodConfiguration == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)variabilityElement, (MethodConfiguration)methodConfiguration);
        for (Object object2 : list) {
            if (!(object2 instanceof Activity) || ((Activity)object2).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo variabilityInfo = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement);
        object2 = variabilityInfo.getContributors();
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (variabilityElement2 == null) {
            return null;
        }
        Activity activity = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)variabilityElement2, (MethodConfiguration)methodConfiguration);
        if (activity != null) {
            variabilityElement2 = activity;
            Diagram diagram = this.getDiagram(activity, n);
            if (bl ? (diagramInfo = new DiagramInfo(activity)).canPublishADImage() && diagramInfo.getActivityDiagram() != null : diagram != null) {
                return activity;
            }
            return null;
        }
        Diagram diagram = null;
        if (bl) {
            diagramInfo = new DiagramInfo((Activity)variabilityElement2);
        } else {
            diagram = this.getDiagram((Activity)variabilityElement2, n);
        }
        if (diagram != null || diagramInfo != null && diagramInfo.canPublishADImage() && diagramInfo.getActivityDiagram() != null) {
            VariabilityInfo variabilityInfo2 = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement2);
            List list2 = variabilityInfo2.getContributors();
            if (object2.size() != list2.size()) {
                for (Object e : object2) {
                    if (list2.contains(e) || ((Activity)e).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return variabilityElement2;
        }
        return this.checkVariability(variabilityElement2, iFilter, n);
    }

    public void setPublishedUnCreatedADD(boolean bl) {
        this.publishUncreatedADD = bl;
    }

    public void setPublishADForActivityExtension(boolean bl) {
        this.publishADForActivityExtension = bl;
    }

    public Diagram getDiagram(Activity activity, int n) {
        DiagramManager diagramManager = this.getDiagramManager(activity);
        Diagram diagram = null;
        if (diagramManager != null) {
            try {
                List list = diagramManager.getDiagrams(activity, n);
                if (!list.isEmpty()) {
                    diagram = (Diagram)list.get(0);
                }
            }
            catch (Exception exception) {
                DiagramUIPlugin.getDefault().getLogger().logError("Error in getDiagram()" + exception.getMessage());
            }
        }
        return diagram;
    }

    private DiagramManager getDiagramManager(Activity activity) {
        DiagramManager diagramManager = DiagramManager.getInstance((Process)TngUtil.getOwningProcess((BreakdownElement)activity), (Object)this);
        this.diagramManagers.add(diagramManager);
        return diagramManager;
    }

    public MethodConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(MethodConfiguration methodConfiguration) {
        this.config = methodConfiguration;
    }

    private boolean isBreakdownElementsReplaced(Activity activity, IFilter iFilter) {
        MethodConfiguration methodConfiguration = null;
        if (iFilter instanceof IMethodConfigurationProvider) {
            methodConfiguration = ((IMethodConfigurationProvider)iFilter).getMethodConfiguration();
        }
        if (methodConfiguration == null) {
            return true;
        }
        for (BreakdownElement breakdownElement : activity.getBreakdownElements()) {
            if (!(breakdownElement instanceof Activity) || ConfigurationHelper.getReplacer((VariabilityElement)((Activity)breakdownElement), (MethodConfiguration)methodConfiguration) == null) continue;
            return true;
        }
        return false;
    }

    public AbstractDiagramGraphicalViewer getDiagramViewer(Object object, int n, IFilter iFilter, Suppression suppression) {
        Object object2 = TngUtil.unwrap((Object)object);
        if (!(object2 instanceof Activity)) {
            return null;
        }
        Activity cfr_ignored_0 = (Activity)object2;
        AbstractDiagramGraphicalViewer abstractDiagramGraphicalViewer = null;
        if (n < 0) {
            return null;
        }
        abstractDiagramGraphicalViewer = this.getDiagramViewer(n, object);
        return abstractDiagramGraphicalViewer;
    }

    public Activity getRealizedForUnmodified(Object object, IFilter iFilter, Suppression suppression) {
        Activity activity = (Activity)TngUtil.unwrap((Object)object);
        if (activity == null) {
            return null;
        }
        if (!this.publishADForActivityExtension) {
            return null;
        }
        if (!activity.getBreakdownElements().isEmpty()) {
            return null;
        }
        if (this.anyChildrenSuppressed(activity, iFilter, suppression)) {
            return null;
        }
        VariabilityElement variabilityElement = this.checkVariability((VariabilityElement)activity, iFilter, 0, true);
        if (variabilityElement == null) {
            return null;
        }
        object = variabilityElement;
        return (Activity)object;
    }
}

