/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingServiceException;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPublishManager {
    protected static boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected static boolean profiling = PublishingPlugin.getDefault().isProfiling();
    protected String pubDir;
    protected MethodConfiguration config;
    protected PublishHTMLOptions options;
    protected AbstractViewBuilder viewBuilder;
    protected boolean success = false;

    public void init(String string, MethodConfiguration methodConfiguration, PublishOptions publishOptions) {
        this.pubDir = string;
        if (!this.pubDir.endsWith(File.separator)) {
            this.pubDir = String.valueOf(this.pubDir) + File.separator;
        }
        this.config = methodConfiguration;
        if (!(publishOptions instanceof PublishHTMLOptions)) {
            throw new IllegalArgumentException();
        }
        this.options = (PublishHTMLOptions)publishOptions;
        this.viewBuilder = this.createViewBuilder();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.viewBuilder;
    }

    public ISiteGenerator getSiteGenerator() {
        return this.viewBuilder.getSiteGenerator();
    }

    public void publish(IProgressMonitor iProgressMonitor) throws PublishingServiceException {
        if (this.options != null) {
            this.options.validate();
        }
        long l = 0L;
        long l2 = 0L;
        Runtime.getRuntime().gc();
        try {
            try {
                if (profiling) {
                    l = l2 = System.currentTimeMillis();
                }
                this.prePublish(iProgressMonitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"prePublish", (String)(String.valueOf(System.currentTimeMillis() - l2) + " ms"));
                }
                if (profiling) {
                    l2 = System.currentTimeMillis();
                }
                this.doPublish(iProgressMonitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"doPublish", (String)(String.valueOf(System.currentTimeMillis() - l2) + " ms"));
                }
                if (profiling) {
                    l2 = System.currentTimeMillis();
                }
                this.postPublish(iProgressMonitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"postPublish", (String)(String.valueOf(System.currentTimeMillis() - l2) + " ms"));
                }
                this.success = true;
            }
            catch (Exception exception) {
                throw new PublishingServiceException(exception);
            }
        }
        finally {
            if (profiling) {
                System.out.println("Time taken to publish configuration '" + this.config.getName() + "': " + (System.currentTimeMillis() - l) + " ms");
            }
        }
    }

    protected Collection<Resource> loadLibrary(IProgressMonitor iProgressMonitor) {
        long l = 0L;
        iProgressMonitor.subTask(PublishingResources.loadLibraryTask_name);
        if (profiling) {
            l = System.currentTimeMillis();
        }
        Collection collection = LibraryUtil.loadAll((MethodLibrary)((MethodLibrary)this.config.eContainer()));
        if (profiling) {
            DebugTrace.print((Object)this, (String)"loadLibrary", (String)("LibraryUtil.loadAll: " + (System.currentTimeMillis() - l) + " ms"));
        }
        return collection;
    }

    public void dispose() {
        if (this.viewBuilder != null) {
            this.viewBuilder.dispose();
            this.viewBuilder = null;
        }
    }

    public abstract String getPublishedUrl();

    public abstract String getPublishReportUrl();

    protected abstract AbstractViewBuilder createViewBuilder();

    protected abstract void prePublish(IProgressMonitor var1) throws Exception;

    protected abstract void doPublish(IProgressMonitor var1) throws Exception;

    protected abstract void postPublish(IProgressMonitor var1) throws Exception;
}

