/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.BookmarkList;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.AbstractSiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.util.PublishingUtil;

public class DefaultSiteGenerator
extends AbstractSiteGenerator {
    public static final String NO_APPLET_DIRECTORY = "noapplet";
    public static final String BOOKMARK_SUFFIX_XML = ".xml";
    public static final String BOOKMARK_SUFFIX_HTML = ".html";
    public static final String SPACE_REPLACEMENT = "_";
    public static final String SPACE_STRING = " ";
    public static final String PUBLISHED_BOOKMARKS_CFG_NAME = "PublishedBookmarks.xml";
    public static final String PUBLISHED_BOOKMARKS_DELIMITER = "*";
    protected static final String BOOKMARK_XSL_FILE = "xsl/bookmark.xsl";
    protected static final String BOOKMARKS_XSL_FILE = "xsl/PublishedBookmarks.xsl";
    protected static final String INDEX_XSL_FILE = "xsl/index.xsl";
    protected static final String TOPNAV_XSL_FILE = "xsl/topnav.xsl";
    protected static final String SEARCH_XSL_FILE = "xsl/search.xsl";
    private static final String APPLET_PATH = "applet" + File.separatorChar;
    private static final String NO_APPLET_PATH = "noapplet" + File.separatorChar;
    private static final String ICON_PATH = "images" + File.separatorChar;
    private static final String SERVER_SEARCH_PATH = "docroot/server_search";
    private static final String DEFAULT_BANNER_FILE = "EPFC_banner.jpg";
    protected File iconPath;

    public DefaultSiteGenerator(HtmlBuilder htmlBuilder, PublishHTMLOptions publishHTMLOptions) {
        super(htmlBuilder, publishHTMLOptions);
        this.iconPath = new File(this.pubDir, publishHTMLOptions.isPublishDynamicWebApp() ? String.valueOf(NO_APPLET_PATH) + ICON_PATH : String.valueOf(APPLET_PATH) + ICON_PATH);
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.builder;
    }

    public PublishOptions getPublishOptions() {
        return this.options;
    }

    public String getNodeIconPath() {
        return this.iconPath.getAbsolutePath();
    }

    public String getDefaultBannerImageFile() {
        return DEFAULT_BANNER_FILE;
    }

    public void prePublish() throws Exception {
        this.copyFiles();
    }

    public void postPublish() throws Exception {
        this.copyIconsForNonApplet();
        this.writeIndexAndTopNavHtml();
        this.writeSearchHtml();
    }

    protected void copyFiles() throws Exception {
        this.copyDocRootFiles();
        this.copyLocalizedFiles();
        this.copyCustomizedFiles();
    }

    protected void copyDocRootFiles() throws Exception {
        URL uRL = PublishingPlugin.getDefault().getInstallURL();
        URL uRL2 = new URL(uRL, "docroot/");
        String string = Platform.resolve((URL)uRL2).getPath();
        String string2 = "*.*, process/**, images/**, index/**, scripts/**, stylesheets/**";
        String string3 = "";
        if (this.options.isPublishJavaScriptTree()) {
            string2 = String.valueOf(string2) + ", noapplet/**";
        }
        LayoutResources.copyDir((String)string, (String)this.pubDir, (String)string2, (String)string3);
        String string4 = FileLocator.resolve((URL)new URL(uRL, SERVER_SEARCH_PATH)).getPath();
        string2 = "*.*, search/**";
        LayoutResources.copyDir((String)string4, (String)this.pubDir, (String)string2, null);
    }

    protected void copyCustomizedFiles() throws Exception {
        super.copyCustomizedFiles();
        if (this.options.aboutHTML != null && this.options.aboutHTML.length() > 0) {
            FileUtil.copyFile((String)this.options.aboutHTML, (String)(String.valueOf(this.pubDir) + "about.htm"));
        }
    }

    protected void copyLocalizedFiles() throws Exception {
        super.copyLocalizedFiles();
        if (this.options.isPublishJavaScriptTree()) {
            PublishingPlugin.getDefault().copyLocalizedFiles("docroot/noapplet/", new File(this.pubDir, "noapplet/"), false, false);
        }
    }

    protected void copyIconsForNonApplet() {
        try {
            if (this.options.isPublishJavaScriptTree()) {
                LayoutResources.copyDir((String)this.iconPath.getAbsolutePath(), (String)(String.valueOf(this.pubDir) + NO_APPLET_PATH + ICON_PATH));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String makeBookmarkFileName(String string) {
        return String.valueOf(string.replace(SPACE_STRING.charAt(0), SPACE_REPLACEMENT.charAt(0))) + BOOKMARK_SUFFIX_XML;
    }

    private String writeBookmark(Bookmark bookmark) {
        String string = this.makeBookmarkFileName(StrUtil.removeSpecialCharacters((String)bookmark.getPresentationName()));
        XmlElement xmlElement = bookmark.getXmlElement();
        String string2 = PublishingUtil.getHtml(xmlElement, BOOKMARK_XSL_FILE);
        if (string2 != null) {
            String string3 = this.getBookmarkHtmlPath(string);
            FileUtil.writeUTF8File((String)string3, (String)string2.toString());
        }
        return string;
    }

    public void writePublishedBookmarks(List list, Bookmark bookmark) throws Exception {
        String string;
        Object object2;
        BookmarkList bookmarkList = new BookmarkList();
        if (bookmark == null && list.size() > 0) {
            bookmark = (Bookmark)list.get(0);
        }
        for (Object object2 : list) {
            string = this.writeBookmark((Bookmark)object2);
            bookmarkList.addBookmark(object2.getPresentationName(), string, bookmark == object2);
        }
        XmlElement xmlElement = bookmarkList.getXmlElement();
        object2 = PublishingUtil.getHtml(xmlElement, BOOKMARKS_XSL_FILE);
        if (object2 != null) {
            string = this.getBookmarkHtmlPath(PUBLISHED_BOOKMARKS_CFG_NAME);
            FileUtil.writeUTF8File((String)string, (String)((String)object2).toString());
        }
    }

    protected void writeIndexAndTopNavHtml() {
        String string;
        XmlElement xmlElement = this.getOptionXml();
        String string2 = PublishingUtil.getHtml(xmlElement, INDEX_XSL_FILE);
        if (string2 != null) {
            string = this.getIndexFilePath();
            FileUtil.writeUTF8File((String)string, (String)string2.toString());
        }
        if ((string2 = PublishingUtil.getHtml(xmlElement, TOPNAV_XSL_FILE)) != null) {
            string = String.valueOf(this.pubDir) + "topnav.htm";
            FileUtil.writeUTF8File((String)string, (String)string2.toString());
        }
    }

    protected void writeSearchHtml() {
        XmlElement xmlElement;
        String string;
        boolean bl = this.options == null || this.options.isIncludeServletSearch();
        String string2 = this.options.getDynamicWebAppName();
        if (string2 != null && string2.length() > 0 && bl && (string = PublishingUtil.getHtml(xmlElement = new XmlElement("Search").setAttribute("webAppName", string2), SEARCH_XSL_FILE)) != null) {
            String string3 = this.getSearchFilePath();
            FileUtil.writeUTF8File((String)(String.valueOf(string3) + "search.html"), (String)string.toString());
        }
    }

    protected String getBookmarkHtmlPath(String string) {
        int n = string.lastIndexOf(BOOKMARK_SUFFIX_XML);
        return String.valueOf(this.pubDir) + NO_APPLET_DIRECTORY + File.separatorChar + string.substring(0, n) + BOOKMARK_SUFFIX_HTML;
    }

    public String getIndexFilePath() {
        return String.valueOf(this.pubDir) + "index.htm";
    }

    private String getSearchFilePath() {
        return String.valueOf(this.pubDir) + File.separatorChar + "search" + File.separatorChar;
    }

    protected XmlElement getOptionXml() {
        boolean bl = this.options == null || this.options.isPublishGlossary();
        boolean bl2 = this.options == null || this.options.isPublishIndex();
        XmlElement xmlElement = new XmlElement("PublishingOption");
        if (this.options != null) {
            xmlElement.setAttribute("title", this.options.getTitle()).setAttribute("bannerImage", this.options.bannerImage).setAttribute("bannerImageHeight", Integer.toString(this.options.getBannerImageHeight())).setAttribute("feedbackUrl", this.options.feedbackURL).setAttribute("showGlossary", bl ? "true" : "false").setAttribute("showIndex", bl2 ? "true" : "false").setAttribute("serverSideSearch", this.options.isIncludeServletSearch() ? "true" : "false");
        }
        return xmlElement;
    }

    public void dispose() {
        super.dispose();
    }
}

