/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services.index;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.epf.publishing.services.index.Def;

final class JarResources {
    boolean debugOn = false;
    private Hashtable htJarContents = new Hashtable();
    private String jarFileName;

    JarResources(String string) {
        this.jarFileName = string;
        this.init();
    }

    byte[] getResource(String string) {
        return (byte[])this.htJarContents.get(string);
    }

    byte[] getResource() {
        Enumeration enumeration = this.htJarContents.keys();
        return (byte[])this.htJarContents.get(enumeration.nextElement());
    }

    private void init() {
        try {
            DataInputStream dataInputStream = null;
            dataInputStream = this.jarFileName.startsWith(Def.Http) || this.jarFileName.startsWith(Def.Https) || this.jarFileName.startsWith(Def.File) ? new DataInputStream(new URL(this.jarFileName).openStream()) : new DataInputStream(new FileInputStream(this.jarFileName));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(dataInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                if (this.debugOn) {
                    System.out.println("ze.getName()=" + zipEntry.getName() + "," + "getSize()=" + zipEntry.getSize());
                }
                if ((n = (int)zipEntry.getSize()) == -1) {
                    System.out.println("ERROR: Returned size of zip file is -1. Filename: " + zipEntry.getName());
                }
                byte[] byArray = new byte[n];
                int n2 = 0;
                int n3 = 0;
                while (n - n2 > 0) {
                    n3 = zipInputStream.read(byArray, n2, n - n2);
                    if (n3 == -1) break;
                    n2 += n3;
                }
                this.htJarContents.put(zipEntry.getName(), byArray);
                if (!this.debugOn) continue;
                System.out.println(String.valueOf(zipEntry.getName()) + "  rb=" + n2 + ",size=" + n + ",csize=" + zipEntry.getCompressedSize());
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("done.");
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String dumpZipEntry(ZipEntry zipEntry) {
        StringBuffer stringBuffer = new StringBuffer();
        if (zipEntry.isDirectory()) {
            stringBuffer.append("d ");
        } else {
            stringBuffer.append("f ");
        }
        if (zipEntry.getMethod() == 0) {
            stringBuffer.append("stored   ");
        } else {
            stringBuffer.append("defalted ");
        }
        stringBuffer.append(zipEntry.getName());
        stringBuffer.append("\t");
        stringBuffer.append("" + zipEntry.getSize());
        if (zipEntry.getMethod() == 8) {
            stringBuffer.append("/" + zipEntry.getCompressedSize());
        }
        return stringBuffer.toString();
    }
}

