/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.services.IAccessController;

public class AccessController
implements IAccessController {
    public IStatus checkModify(Collection collection, Object object) {
        if (collection.isEmpty()) {
            return Status.OK_STATUS;
        }
        ILibraryResourceSet iLibraryResourceSet = null;
        for (EObject eObject : collection) {
            Resource resource = eObject.eResource();
            if (resource != null && resource.getResourceSet() instanceof ILibraryResourceSet && (iLibraryResourceSet = (ILibraryResourceSet)resource.getResourceSet()) != null) break;
        }
        if (iLibraryResourceSet != null) {
            return iLibraryResourceSet.checkModify(collection, object);
        }
        return Status.OK_STATUS;
    }

    public IStatus checkModify(Resource[] resourceArray, Object object) {
        if (resourceArray.length == 0) {
            return Status.OK_STATUS;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < resourceArray.length) {
            Resource resource = resourceArray[n];
            String string = FileManager.toFileString(resource.getURI());
            if (string != null) {
                arrayList.add(string);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return FileManager.getInstance().checkModify(stringArray, object);
        }
        return Status.OK_STATUS;
    }
}

