/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.persistence.UnnormalizedURIException;

public class ExtendedResourceSet
extends ResourceSetImpl {
    public static final int URI_TYPE_UNKNOWN = 0;
    public static final int URI_TYPE_LOCAL = 1;
    public static final int URI_TYPE_EXTERNAL = 2;
    protected List<ResourceSet> referencedResourceSets = new ArrayList<ResourceSet>();

    protected int getURIType(URI uRI) {
        return 0;
    }

    public boolean add(ResourceSet resourceSet) {
        if (!this.referencedResourceSets.contains(resourceSet)) {
            return this.referencedResourceSets.add(resourceSet);
        }
        return false;
    }

    public EObject getEObject(URI uRI, boolean bl) {
        EObject eObject = null;
        UnnormalizedURIException unnormalizedURIException = null;
        int n = this.getURIType(uRI);
        if (n == 0 || n == 1) {
            try {
                eObject = super.getEObject(uRI, bl);
            }
            catch (UnnormalizedURIException unnormalizedURIException2) {
                unnormalizedURIException = unnormalizedURIException2;
            }
            if (eObject != null) {
                return eObject;
            }
        }
        if (n == 0 || n == 2) {
            for (ResourceSet resourceSet : this.referencedResourceSets) {
                try {
                    eObject = resourceSet.getEObject(uRI, bl);
                    if (eObject == null) continue;
                    return eObject;
                }
                catch (UnnormalizedURIException unnormalizedURIException3) {
                    unnormalizedURIException = unnormalizedURIException3;
                }
            }
        }
        if (unnormalizedURIException != null) {
            throw unnormalizedURIException;
        }
        return eObject;
    }

    public void dispose() {
        for (Resource resource : this.getResources()) {
            try {
                resource.unload();
            }
            catch (Exception exception) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
        this.referencedResourceSets.clear();
    }
}

