/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.LibraryResourceException;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.IURIProvider;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileURIConverter;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerFactory;
import org.eclipse.epf.uma.BreakdownElementDescription;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiFileSaveUtil {
    public static final String DEFAULT_MODEL_FILENAME = "model.xmi";
    public static final String DEFAULT_CONTENT_FILENAME = "content.xmi";
    public static final String DEFAULT_LIBRARY_MODEL_FILENAME = "library.xmi";
    public static final String DEFAULT_PLUGIN_EXPORT_FILENAME = "export.xmi";
    public static final String DEFAULT_PLUGIN_MODEL_FILENAME = "plugin.xmi";
    public static final String DEFAULT_FILE_EXTENSION = ".xmi";
    public static final String LIBRARY_FILE_EXTENSION = "uma";
    public static final String CAPABILITY_PATTERN_PATH = "capabilitypatterns";
    public static final String DELIVERY_PROCESS_PATH = "deliveryprocesses";
    public static final String PROCESS_CONTRIBUTION_PATH = "processcontributions";
    public static final String METHOD_CONFIGURATION_FOLDER_NAME = "configurations";
    public static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    static final boolean PROFILE = false;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMddHHmmss.S");

    public static boolean isValidFileName(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(47) == -1 && string.indexOf(92) == -1 && string.indexOf(58) == -1 && string.indexOf(42) == -1 && string.indexOf(63) == -1 && string.indexOf(34) == -1 && string.indexOf(60) == -1 && string.indexOf(62) == -1 && string.indexOf(124) == -1;
    }

    public static String getPath(MethodElement methodElement) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(methodElement.getName()));
        methodElement = (MethodElement)methodElement.eContainer();
        while (methodElement != null) {
            stringBuffer.insert(0, String.valueOf(String.valueOf(methodElement.getName())) + " > ");
            methodElement = (MethodElement)methodElement.eContainer();
        }
        return stringBuffer.toString();
    }

    public static String createDirName(MethodElement methodElement) {
        String string = methodElement.getName();
        if (MultiFileSaveUtil.isValidFileName(string)) {
            return string;
        }
        throw new MultiFileIOException(NLS.bind((String)PersistenceResources.invalidNameError_msg, (Object)string), methodElement);
    }

    public static EObject resolve(EObject eObject) {
        if (!(eObject instanceof InternalEObject)) {
            return eObject;
        }
        InternalEObject internalEObject = (InternalEObject)eObject;
        if (internalEObject.eProxyURI() == null) {
            return eObject;
        }
        XMIResourceImpl xMIResourceImpl = new XMIResourceImpl(internalEObject.eProxyURI());
        try {
            xMIResourceImpl.load(null);
            return PersistenceUtil.getMethodElement((Resource)xMIResourceImpl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return eObject;
        }
    }

    static Resource save(EObject eObject, URI uRI, Map map) {
        String string;
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        MultiFileXMIResourceImpl multiFileXMIResourceImpl = MultiFileSaveUtil.save(resourceSet, eObject, uRI, map);
        if (map == null) {
            map = ((MultiFileResourceSetImpl)resourceSet).getDefaultSaveOptions();
        }
        if ((string = (String)map.get("REFRESH_NEW_RESOURCE")) != null && Boolean.valueOf(string).booleanValue()) {
            RefreshJob.getInstance().resourceSaved(multiFileXMIResourceImpl);
            FileManager.getInstance().refresh(multiFileXMIResourceImpl);
        }
        return multiFileXMIResourceImpl;
    }

    public static boolean canSaveTogether(Map map, Object object) {
        Set set = (Set)map.get("SAVE_TOGETHER_CLASS_SET");
        if (set == null) {
            return false;
        }
        for (EClass eClass : set) {
            if (!eClass.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    private static void addTo(Resource resource, MultiResourceEObject multiResourceEObject) {
        BasicEList basicEList = (BasicEList)resource.getContents();
        if (basicEList.isEmpty()) {
            basicEList.clear();
            basicEList.setData(1, new Object[]{multiResourceEObject});
        } else {
            Object[] objectArray = basicEList.toArray();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray.length] = multiResourceEObject;
            basicEList.setData(objectArray2.length, objectArray2);
        }
        multiResourceEObject.eSetResource((Resource.Internal)resource);
    }

    private static MultiFileXMIResourceImpl save(ResourceSet resourceSet, EObject eObject, URI uRI, Map map) {
        return MultiFileSaveUtil.save(resourceSet, eObject, uRI, map, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static MultiFileXMIResourceImpl save(ResourceSet var0, EObject var1_1, URI var2_2, Map var3_3, boolean var4_4) {
        block25: {
            var5_5 = (MultiResourceEObject)var1_1;
            var6_6 = (MultiFileXMIResourceImpl)var1_1.eResource();
            if (var6_6 != null) {
                var6_6.detached(var1_1);
            }
            var7_7 = null;
            var8_8 = (Set)var3_3.get("MODIFIED_RESOURCE_SET");
            var9_9 = null;
            if (MultiFileSaveUtil.canSaveTogether(var3_3, var1_1)) {
                var10_10 = (MultiFileResourceSetImpl)var0;
                var11_11 /* !! */  = (URI)var10_10.getURIToTempURIMap().get(var2_2);
                if (var11_11 /* !! */  != null) {
                    var2_2 = var11_11 /* !! */ ;
                }
                if ((var9_9 = (MultiFileXMIResourceImpl)var10_10.getResource(var2_2)) != null) {
                    if (!var9_9.getContents().contains((Object)var1_1)) {
                        if (var9_9.getFinalURI() == var9_9.getURI() && MultiFileXMISaveImpl.checkModifyRequired(var3_3)) {
                            MultiFileSaveUtil.checkModify(var9_9);
                        }
                        MultiFileSaveUtil.addTo(var9_9, var5_5);
                        var12_13 = null;
                        try {
                            if (var4_4 && (var12_13 = MultiFileSaveUtil.registerWithResourceManager(var13_15 = MultiFileSaveUtil.getResourceManagerFor(var1_1, var8_8), var1_1, var9_9.getFinalURI())) != null && var8_8 != null) {
                                var8_8.add(var13_15.eResource());
                            }
                            var9_9.setModified(true);
                            var10_10.save(var9_9, var3_3, false);
                            var9_9.attachedAll(var1_1);
                        }
                        catch (Exception var13_16) {
                            var9_9.getContents().remove((Object)var5_5);
                            var5_5.eSetResource(null);
                            if (var12_13 != null) {
                                EcoreUtil.remove((EObject)var12_13);
                            }
                            if (var6_6 != null) {
                                var6_6.attached(var1_1);
                            }
                            throw new MultiFileIOException(var13_16.getMessage());
                        }
                    }
                    return var9_9;
                }
            }
            var9_9 = (MultiFileXMIResourceImpl)var0.createResource(var2_2);
            MultiFileSaveUtil.addTo(var9_9, var5_5);
            if (var5_5 instanceof MethodPlugin) {
                MultiFileSaveUtil.addResourceManager(var9_9);
            }
            var10_10 = null;
            try {
                block26: {
                    try {
                        if (var4_4) {
                            var7_7 = MultiFileSaveUtil.registerWithResourceManager(var9_9, var8_8);
                        }
                        var10_10 = MultiFileSaveUtil.removeContainers(var9_9);
                        var9_9.save(var3_3);
                        var9_9.attachedAll(var1_1);
                        break block25;
                    }
                    catch (Exception var11_12) {
                        CommonPlugin.INSTANCE.log((Object)var11_12);
                        var0.getResources().remove((Object)var9_9);
                        var5_5.eSetResource(null);
                        if (var7_7 == null || var7_7.isEmpty()) break block26;
                        var12_14 = var7_7.iterator();
                        ** while (var12_14.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        EcoreUtil.remove((EObject)((EObject)var12_14.next()));
                        continue;
                    }
                }
                if (var6_6 != null) {
                    var6_6.attached(var1_1);
                }
                throw new MultiFileIOException(var11_12.getMessage());
            }
            finally {
                MultiFileSaveUtil.restoreContainers(var9_9, (Map)var10_10);
            }
        }
        if (var4_4) {
            var11_11 /* !! */  = MultiFileSaveUtil.addNewResourceManager(var9_9);
            if (var11_11 /* !! */  == null) {
                if (var1_1 instanceof MethodPlugin) {
                    var11_11 /* !! */  = MultiFileSaveUtil.getResourceManagerFor(var1_1, var8_8);
                }
            } else if (var8_8 != null) {
                var8_8.add(var11_11 /* !! */ .eContainer().eResource());
            }
        }
        var9_9.updateTimeStamps();
        return var9_9;
    }

    private static Map removeContainers(Resource resource) {
        int n = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> hashMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int n2 = 0;
        while (n2 < n) {
            MultiResourceEObject multiResourceEObject = (MultiResourceEObject)resource.getContents().get(n2);
            InternalEObject internalEObject = (InternalEObject)multiResourceEObject.eContainer();
            if (internalEObject != null) {
                hashMap.put(multiResourceEObject, internalEObject);
                multiResourceEObject.eBasicSetContainer(null, multiResourceEObject.eContainerFeatureID());
            }
            ++n2;
        }
        return hashMap;
    }

    static Map getContainers(Resource resource) {
        int n = resource.getContents().size();
        HashMap<MultiResourceEObject, InternalEObject> hashMap = new HashMap<MultiResourceEObject, InternalEObject>();
        int n2 = 0;
        while (n2 < n) {
            MultiResourceEObject multiResourceEObject = (MultiResourceEObject)resource.getContents().get(n2);
            InternalEObject internalEObject = (InternalEObject)multiResourceEObject.eContainer();
            if (internalEObject != null) {
                hashMap.put(multiResourceEObject, internalEObject);
            }
            ++n2;
        }
        return hashMap;
    }

    private static void restoreContainers(Resource resource, Map map) {
        int n = resource.getContents().size();
        int n2 = 0;
        while (n2 < n) {
            MultiResourceEObject multiResourceEObject = (MultiResourceEObject)resource.getContents().get(n2);
            InternalEObject internalEObject = (InternalEObject)map.get(multiResourceEObject);
            if (internalEObject != null) {
                multiResourceEObject.eBasicSetContainer(internalEObject, multiResourceEObject.eContainerFeatureID());
            }
            ++n2;
        }
    }

    public static void checkModify(Resource resource) {
        MultiFileSaveUtil.checkModify((Collection<Resource>)Collections.singleton(resource));
    }

    static void doCheckModify(Collection<Resource> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resource resource : collection) {
            if (resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            arrayList.add(FileManager.toFileString(resource.getURI()));
        }
        if (!arrayList.isEmpty()) {
            Resource resource;
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            resource = FileManager.getInstance().checkModify(stringArray, (Object)MsgBox.getDefaultShell());
            if (!resource.isOK()) {
                String string = UmaUtil.getMessage((IStatus)resource);
                if (string == null) {
                    string = NLS.bind((String)PersistenceResources.modifyFileError_msg, Arrays.asList(stringArray));
                }
                throw new MultiFileIOException(string);
            }
        }
    }

    public static void checkModify(Collection<Resource> collection) {
        Resource[] resourceArray;
        Object object;
        HashMap<ILibraryResourceSet, Resource[]> hashMap = new HashMap<ILibraryResourceSet, Resource[]>();
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource object2 : collection) {
            object = object2.getResourceSet();
            if (object instanceof ILibraryResourceSet) {
                resourceArray = (Resource[])hashMap.get(object);
                if (resourceArray == null) {
                    resourceArray = new ArrayList();
                    hashMap.put((ILibraryResourceSet)object, resourceArray);
                }
                resourceArray.add(object2);
                continue;
            }
            arrayList.add(object2);
        }
        if (!hashMap.isEmpty()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (ILibraryResourceSet)entry.getKey();
                resourceArray = new Resource[((Collection)entry.getValue()).size()];
                ((Collection)entry.getValue()).toArray(resourceArray);
                try {
                    object.checkModify(resourceArray, (Object)MsgBox.getDefaultShell());
                }
                catch (LibraryResourceException libraryResourceException) {
                    throw new MultiFileIOException(libraryResourceException.getMessage());
                }
            }
        }
        if (!arrayList.isEmpty()) {
            MultiFileSaveUtil.doCheckModify(arrayList);
        }
    }

    public static void checkOutOfSynch(Collection<Resource> collection, Map map) {
        Collection<Resource> collection2;
        Collection collection3 = (Collection)map.get("OVERWRITABLE_RESOURCES");
        if (collection3 != null && !collection3.isEmpty()) {
            collection2 = new ArrayList<Resource>(collection);
            collection2.removeAll(collection3);
        } else {
            collection2 = collection;
        }
        if (!collection2.isEmpty()) {
            MultiFileSaveUtil.checkOutOfSynch(collection2);
        }
    }

    private static void checkOutOfSynch(Collection collection) {
        for (MultiFileXMIResourceImpl multiFileXMIResourceImpl : collection) {
            File file;
            if (!multiFileXMIResourceImpl.isLoaded() || multiFileXMIResourceImpl.hasTempURI() || !(file = new File(multiFileXMIResourceImpl.getURI().toFileString())).exists() || multiFileXMIResourceImpl.isSynchronized()) continue;
            String string = NLS.bind((String)PersistenceResources.resourceOutOfSynch_msg, (Object)multiFileXMIResourceImpl.getURI().toFileString());
            throw new MultiFileIOException(string);
        }
    }

    public static boolean save(Resource resource, Map map) {
        if (resource.getContents().isEmpty()) {
            return false;
        }
        Set set = (Set)map.get("MODIFIED_RESOURCE_SET");
        Map map2 = MultiFileSaveUtil.removeContainers(resource);
        try {
            try {
                resource.save(map);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new MultiFileIOException(iOException.getMessage());
            }
        }
        finally {
            MultiFileSaveUtil.restoreContainers(resource, map2);
        }
        ResourceManager resourceManager = MultiFileSaveUtil.addNewResourceManager(resource);
        if (resourceManager != null && set != null) {
            set.add(resourceManager.eContainer().eResource());
        }
        return true;
    }

    private static ResourceManager addNewResourceManager(Resource resource) {
        ResourceManager resourceManager;
        ResourceManager resourceManager2 = MultiFileSaveUtil.getResourceManager(resource);
        MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
        EObject eObject = methodElement.eContainer();
        if (resourceManager2 != null && eObject != null && resourceManager2.eContainer() == null && !(resourceManager = MultiFileSaveUtil.getResourceManager(eObject.eResource())).getSubManagers().contains(resourceManager2)) {
            resourceManager.getSubManagers().add(resourceManager2);
            MultiFileSaveUtil.registerWithResourceManager(resourceManager, methodElement, MultiFileSaveUtil.getFinalURI(resource));
            return resourceManager2;
        }
        return null;
    }

    private static String toFileString(EObject eObject) {
        return eObject.eResource().getResourceSet().getURIConverter().normalize(eObject.eResource().getURI()).toFileString();
    }

    static boolean hasOwnFolder(Object object) {
        return object instanceof MethodPlugin || object instanceof ProcessComponent;
    }

    static boolean hasOwnResource(Object object, Collection collection) {
        if (object instanceof MethodUnit) {
            return true;
        }
        if (collection == null) {
            return false;
        }
        for (EClass eClass : collection) {
            if (!eClass.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    static URI createFileURI(MethodElement methodElement) {
        if (methodElement.eContainer() == null) {
            return ((MultiFileXMIResourceImpl)methodElement.eResource()).getFinalURI();
        }
        if (methodElement instanceof ProcessComponent) {
            Object object;
            Object object2;
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
            if (methodPlugin == null) {
                return null;
            }
            Resource resource = methodPlugin.eResource();
            String string = null;
            if (resource != null) {
                string = new File(MultiFileSaveUtil.getFinalURI(resource).toFileString()).getParent();
            } else {
                object2 = (MethodLibrary)methodPlugin.eContainer();
                if (object2 != null) {
                    object = new File(((MultiFileXMIResourceImpl)object2.eResource()).getFinalURI().toFileString()).getParent();
                    string = String.valueOf(object) + File.separator + methodPlugin.getName();
                }
            }
            if (string == null) {
                return null;
            }
            object = ((ProcessComponent)methodElement).getProcess();
            object2 = object instanceof CapabilityPattern ? CAPABILITY_PATTERN_PATH : (object instanceof DeliveryProcess ? DELIVERY_PROCESS_PATH : "");
            String string2 = String.valueOf(string) + File.separator + (String)object2 + File.separator + methodElement.getName() + File.separator + DEFAULT_MODEL_FILENAME;
            return URI.createFileURI((String)string2);
        }
        if (methodElement instanceof BreakdownElementDescription) {
            String string = null;
            string = new File(((MultiFileXMIResourceImpl)UmaUtil.getProcessComponent((MethodElement)methodElement).eResource()).getFinalURI().toFileString()).getParent();
            return URI.createFileURI((String)(String.valueOf(string) + File.separator + DEFAULT_CONTENT_FILENAME));
        }
        if (methodElement instanceof ContentDescription) {
            ContentDescription contentDescription = (ContentDescription)methodElement;
            String string = MethodLibraryPersister.getCorrectPath(contentDescription);
            if (string == null) {
                String string3 = String.valueOf(((MultiFileXMIResourceImpl)methodElement.eResource()).getFinalURI().trimSegments(1).toFileString()) + File.separator;
                string = MethodLibraryPersister.getNextAvailableFileName(string3, contentDescription);
            }
            URI uRI = URI.createFileURI((String)string);
            return uRI;
        }
        if (methodElement instanceof MethodConfiguration) {
            String string = new StringBuffer(((MultiFileXMIResourceImpl)methodElement.eContainer().eResource()).getFinalURI().trimSegments(1).toFileString()).append(File.separator).append(METHOD_CONFIGURATION_FOLDER_NAME).append(File.separator).toString();
            String string4 = MethodLibraryPersister.getNextAvailableFileName(string, StrUtil.makeValidFileName((String)methodElement.getName()), (MultiResourceEObject)methodElement);
            return URI.createFileURI((String)string4);
        }
        StringBuffer stringBuffer = new StringBuffer();
        MethodElement methodElement2 = null;
        Object object = (MethodElement)methodElement.eContainer();
        while (object != null) {
            methodElement2 = object;
            if (object instanceof MethodLibrary) {
                stringBuffer.insert(0, new File(((MultiFileXMIResourceImpl)object.eResource()).getFinalURI().toFileString()).getParentFile().getAbsolutePath());
                break;
            }
            stringBuffer.insert(0, object.getName()).insert(0, File.separatorChar);
            object = (MethodElement)object.eContainer();
        }
        if (methodElement2 == null) {
            return methodElement.eResource() != null ? ((MultiFileXMIResourceImpl)methodElement.eResource()).getFinalURI() : null;
        }
        if (!(methodElement2 instanceof MethodLibrary)) {
            stringBuffer.insert(0, new File(MultiFileSaveUtil.toFileString((EObject)methodElement2)).getParentFile().getParentFile().getAbsolutePath());
        }
        object = methodElement instanceof MethodPlugin ? DEFAULT_PLUGIN_MODEL_FILENAME : DEFAULT_MODEL_FILENAME;
        URI uRI = URI.createFileURI((String)(String.valueOf(stringBuffer.toString()) + File.separator + MultiFileSaveUtil.createDirName(methodElement) + File.separator + (String)object));
        return uRI;
    }

    public static void delete(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                MultiFileSaveUtil.delete(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    static void setURIMapping(EObject eObject, URI uRI, Set set) {
        MultiFileURIConverter multiFileURIConverter = (MultiFileURIConverter)eObject.eResource().getResourceSet().getURIConverter();
        multiFileURIConverter.setURIMapping(eObject, uRI, set);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl multiFileXMIResourceImpl, Set set) {
        MultiFileSaveUtil.updateURIMappings(multiFileXMIResourceImpl, set, true);
    }

    static boolean hasLoadedResource(ResourceSet resourceSet, URI uRI) {
        for (Resource resource : resourceSet.getResources()) {
            if (!resource.isLoaded() || !resource.getURI().equals((Object)uRI)) continue;
            return true;
        }
        return false;
    }

    static void updateURIMappings(MultiFileXMIResourceImpl multiFileXMIResourceImpl, Set set, boolean bl) {
        MultiFileSaveUtil.updateURIMappings(multiFileXMIResourceImpl, multiFileXMIResourceImpl.getFinalURI(), set, bl);
    }

    static void updateURIMappings(MultiFileXMIResourceImpl multiFileXMIResourceImpl, URI uRI, Set set, boolean bl) {
        ResourceDescriptor resourceDescriptor;
        MultiFileURIConverter multiFileURIConverter2;
        Object object;
        HashMap<URI, ResourceDescriptor> hashMap = null;
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(multiFileXMIResourceImpl);
        if (resourceManager != null) {
            hashMap = new HashMap<URI, ResourceDescriptor>();
            object = resourceManager.eAllContents();
            while (object.hasNext()) {
                multiFileURIConverter2 = object.next();
                if (!(multiFileURIConverter2 instanceof ResourceDescriptor)) continue;
                resourceDescriptor = (ResourceDescriptor)((Object)multiFileURIConverter2);
                hashMap.put(resourceDescriptor.getResolvedURI(), resourceDescriptor);
                if (!bl) continue;
                resourceDescriptor.clearResolvedURI();
            }
        }
        if (!multiFileXMIResourceImpl.getContents().isEmpty()) {
            object = PersistenceUtil.getMethodElement(multiFileXMIResourceImpl);
            multiFileURIConverter2 = (MultiFileURIConverter)multiFileXMIResourceImpl.getResourceSet().getURIConverter();
            multiFileURIConverter2.setURIMapping((EObject)object, uRI, set, bl);
        }
        if (hashMap != null) {
            for (MultiFileURIConverter multiFileURIConverter2 : multiFileXMIResourceImpl.getResourceSet().getResources()) {
                resourceDescriptor = (ResourceDescriptor)hashMap.get(multiFileURIConverter2.getURI());
                if (resourceDescriptor == null) continue;
                if (bl) {
                    multiFileURIConverter2.setURI(resourceDescriptor.getResolvedURI());
                    continue;
                }
                if (!multiFileURIConverter2.isLoaded()) continue;
                resourceDescriptor.clearResolvedURI();
                multiFileURIConverter2.setURI(resourceDescriptor.getResolvedURI());
            }
        }
    }

    static ResourceManager getResourceManagerFor(EObject eObject, Set set) {
        Resource resource = eObject.eContainer() != null ? eObject.eContainer().eResource() : eObject.eResource();
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(resource);
        if (resourceManager == null) {
            ResourceManager resourceManager2;
            InternalEObject internalEObject;
            resourceManager = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)resourceManager);
            if (set != null) {
                set.add(resource);
            }
            if ((internalEObject = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)eObject)) != null && internalEObject.eResource() != resource && (resourceManager2 = MultiFileSaveUtil.getResourceManagerFor((EObject)internalEObject, set)) != null) {
                resourceManager2.getSubManagers().add(resourceManager);
                if (set != null) {
                    set.add(resourceManager2.eResource());
                }
            }
        }
        return resourceManager;
    }

    static List registerWithResourceManager(MultiFileXMIResourceImpl multiFileXMIResourceImpl, Set set) {
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManagerFor((EObject)PersistenceUtil.getMethodElement(multiFileXMIResourceImpl), set);
        ArrayList<ResourceDescriptor> arrayList = new ArrayList<ResourceDescriptor>();
        for (Object e : multiFileXMIResourceImpl.getContents()) {
            ResourceDescriptor resourceDescriptor;
            if (!(e instanceof MethodElement) || (resourceDescriptor = MultiFileSaveUtil.registerWithResourceManager(resourceManager, e, multiFileXMIResourceImpl.getFinalURI())) == null) continue;
            arrayList.add(resourceDescriptor);
        }
        if (!arrayList.isEmpty() && set != null) {
            set.add(resourceManager.eResource());
        }
        return arrayList;
    }

    public static ResourceDescriptor registerWithResourceManager(ResourceManager resourceManager, Object object, URI uRI) {
        String string = MultiFileSaveUtil.getGuid(object);
        if (resourceManager.getResourceDescriptor(string) == null) {
            return MultiFileSaveUtil.createResourceDescriptor(resourceManager, string, uRI);
        }
        return null;
    }

    private static ResourceDescriptor createResourceDescriptor(ResourceManager resourceManager, String string, URI uRI) {
        ResourceDescriptor resourceDescriptor = ResourcemanagerFactory.eINSTANCE.createResourceDescriptor();
        resourceDescriptor.setId(string);
        resourceManager.getResourceDescriptors().add(resourceDescriptor);
        resourceDescriptor.setResolvedURI(uRI);
        return resourceDescriptor;
    }

    public static void setGuid(MethodElement methodElement) {
        if (methodElement.getGuid() == null || methodElement.getGuid().trim().length() == 0) {
            methodElement.setGuid(EcoreUtil.generateUUID());
        }
    }

    public static void save(MethodElement methodElement, Map map) throws LibraryResourceException {
        boolean bl;
        MultiFileXMIResourceImpl multiFileXMIResourceImpl = (MultiFileXMIResourceImpl)methodElement.eResource();
        MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)multiFileXMIResourceImpl.getResourceSet();
        if (map == null) {
            map = multiFileResourceSetImpl.getDefaultSaveOptions();
        }
        EObject eObject = methodElement.eContainer();
        HashSet hashSet = new HashSet();
        map.put("MODIFIED_RESOURCE_SET", hashSet);
        URI uRI = MultiFileSaveUtil.createURI(methodElement, (ResourceSet)multiFileResourceSetImpl);
        boolean bl2 = bl = multiFileXMIResourceImpl == null || eObject != null && multiFileXMIResourceImpl == eObject.eResource();
        if (bl) {
            MultiFileSaveUtil.save((EObject)methodElement, uRI, map);
        } else {
            URI uRI2 = multiFileXMIResourceImpl.getURI();
            if (!uRI2.equals((Object)uRI) && FileManager.getInstance().move(uRI2.toFileString(), uRI.toFileString())) {
                multiFileXMIResourceImpl.setURI(uRI);
                MultiFileSaveUtil.updateURIMappings(multiFileXMIResourceImpl, hashSet);
            }
            if (multiFileXMIResourceImpl.isModified()) {
                MultiFileSaveUtil.save(multiFileXMIResourceImpl, map);
            }
        }
        multiFileResourceSetImpl.saveModifiedResources(map);
    }

    public static URI createURI(MethodElement methodElement, ResourceSet resourceSet) {
        IURIProvider iURIProvider;
        URI uRI = null;
        if (resourceSet instanceof MultiFileResourceSetImpl && (iURIProvider = ((MultiFileResourceSetImpl)resourceSet).getURIProvider()) != null) {
            uRI = iURIProvider.getURI((EObject)methodElement);
        }
        if (uRI == null) {
            uRI = MultiFileSaveUtil.createFileURI(methodElement);
        }
        return uRI;
    }

    public static void save(ResourceSet resourceSet, MethodElement methodElement, Map map) {
        URI uRI = MultiFileSaveUtil.createURI(methodElement, resourceSet);
        MultiFileSaveUtil.save(resourceSet, (EObject)methodElement, uRI, map);
    }

    static void adjustLocation(Resource resource, Set set) {
        MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
        if (methodElement == null) {
            return;
        }
        URI uRI = MultiFileSaveUtil.createURI(methodElement, resource.getResourceSet());
        if (uRI != null && MultiFileSaveUtil.adjustLocation(resource, uRI)) {
            resource.setURI(uRI);
            MultiFileSaveUtil.updateURIMappings((MultiFileXMIResourceImpl)resource, set);
        }
    }

    static URI getNewURI(MultiFileXMIResourceImpl multiFileXMIResourceImpl) {
        MethodElement methodElement = PersistenceUtil.getMethodElement(multiFileXMIResourceImpl);
        if (methodElement == null) {
            return null;
        }
        URI uRI = MultiFileSaveUtil.createURI(methodElement, multiFileXMIResourceImpl.getResourceSet());
        if (uRI != null && MultiFileSaveUtil.adjustLocationRequired(multiFileXMIResourceImpl, uRI)) {
            return uRI;
        }
        return null;
    }

    static boolean prepareAdjustLocation(MultiFileXMIResourceImpl multiFileXMIResourceImpl, Set set) {
        URI uRI = MultiFileSaveUtil.getNewURI(multiFileXMIResourceImpl);
        if (uRI != null) {
            multiFileXMIResourceImpl.backUpURI();
            multiFileXMIResourceImpl.setFinalURI(uRI);
            MultiFileSaveUtil.updateURIMappings(multiFileXMIResourceImpl, set, false);
            return true;
        }
        return false;
    }

    public static String getGuid(Object object) {
        String string;
        URI uRI;
        InternalEObject internalEObject;
        if (object instanceof InternalEObject && (internalEObject = (InternalEObject)object).eIsProxy() && (uRI = internalEObject.eProxyURI()) != null && LIBRARY_FILE_EXTENSION.equals(uRI.scheme()) && (string = uRI.fragment()) != null) {
            return string;
        }
        if (object instanceof MethodElement) {
            return ((MethodElement)object).getGuid();
        }
        if (object instanceof ResourceManager) {
            return ((ResourceManager)object).getGuid();
        }
        return null;
    }

    static boolean adjustLocationRequired(MultiFileXMIResourceImpl multiFileXMIResourceImpl, URI uRI) {
        File file;
        File file2 = new File(multiFileXMIResourceImpl.getFinalURI().toFileString());
        return !file2.equals(file = new File(uRI.toFileString()));
    }

    static boolean adjustLocation(Resource resource, URI uRI) {
        File file;
        File file2 = new File(resource.getURI().toFileString());
        if (file2.equals(file = new File(uRI.toFileString()))) {
            return false;
        }
        return MultiFileSaveUtil.move(resource, file2, file);
    }

    static boolean move(Resource resource, File file, File file2) {
        boolean bl = true;
        if (file.equals(file2)) {
            return false;
        }
        MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
        if (MultiFileSaveUtil.hasOwnFolder(methodElement)) {
            String string = file.getParentFile().toString();
            if (!file.getParentFile().equals(file2.getParentFile())) {
                if (FileManager.getInstance().rename(file.getParentFile(), file2.getParentFile())) {
                    if (DEBUG) {
                        System.out.println("Directory '" + string + "' is successfully moved to '" + file2.getParentFile() + "'");
                    }
                } else {
                    bl = false;
                    if (DEBUG) {
                        System.out.println("Could not move directory '" + string + "' to '" + file2.getParentFile() + "'");
                    }
                }
            }
            if (!file.getName().equals(file2.getName())) {
                file = new File(file2.getParentFile(), file.getName());
                if (FileManager.getInstance().rename(file, file2)) {
                    if (DEBUG) {
                        System.out.println("File '" + file + "' is successfully moved to '" + file2 + "'");
                    }
                } else {
                    bl = false;
                    if (DEBUG) {
                        System.out.println("Could not move file '" + file + "' to '" + file2 + "'");
                    }
                }
            }
            return bl;
        }
        if (file.exists()) {
            String string = file.toString();
            if (FileManager.getInstance().rename(file, file2)) {
                if (DEBUG) {
                    System.out.println("File '" + string + "' is successfully moved to '" + file2 + "'");
                }
                return true;
            }
            if (DEBUG) {
                System.out.println("Could not move file '" + string + "' to '" + file2 + "'");
            }
        }
        return false;
    }

    public static ResourceDescriptor findResourceDescriptor(ResourceManager resourceManager, String string, Collection collection, boolean bl) {
        ResourceDescriptor resourceDescriptor = resourceManager.getResourceDescriptor(string);
        if (resourceDescriptor != null) {
            return resourceDescriptor;
        }
        Iterator<ResourceManager> iterator = bl ? new ArrayList<ResourceManager>(resourceManager.getSubManagers()).iterator() : ((InternalEList)resourceManager.getSubManagers()).basicIterator();
        while (iterator.hasNext()) {
            ResourceManager resourceManager2 = iterator.next();
            if (resourceManager2 == null || resourceManager2.eIsProxy() || collection != null && collection.contains(resourceManager2) || (resourceDescriptor = MultiFileSaveUtil.findResourceDescriptor(resourceManager2, string, collection, bl)) == null) continue;
            return resourceDescriptor;
        }
        return null;
    }

    public static int getCountResourceDescriptors(ResourceManager resourceManager) {
        int n = resourceManager.getResourceDescriptors().size();
        for (ResourceManager resourceManager2 : resourceManager.getSubManagers()) {
            n += MultiFileSaveUtil.getCountResourceDescriptors(resourceManager2);
        }
        return n;
    }

    public static ResourceDescriptor getResourceDescriptor(Resource resource) {
        Object object;
        Object object2;
        ResourceManager resourceManager = null;
        MethodElement methodElement = null;
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (object2 instanceof MethodLibrary && (object = MultiFileSaveUtil.getResourceManager(resource)) != null) {
                ResourceDescriptor resourceDescriptor = object.getResourceDescriptor(((MethodElement)object2).getGuid());
                if (resourceDescriptor == null) {
                    resourceDescriptor = MultiFileSaveUtil.registerWithResourceManager((ResourceManager)object, object2, ((MultiFileXMIResourceImpl)resource).getFinalURI());
                }
                return resourceDescriptor;
            }
            if (methodElement == null && object2 instanceof MethodElement) {
                methodElement = (MethodElement)object2;
            }
            if (resourceManager == null && object2 instanceof InternalEObject && (object = MultiFileSaveUtil.getContainerWithDirectResource((InternalEObject)object2)) != null) {
                resourceManager = MultiFileSaveUtil.getResourceManager(object.eResource());
            }
            if (methodElement != null && resourceManager != null) break;
        }
        if (methodElement != null) {
            if (resourceManager != null) {
                return resourceManager.getResourceDescriptor(methodElement.getGuid());
            }
            if (methodElement.eContainer() == null && (iterator = resource.getResourceSet()) instanceof MultiFileResourceSetImpl) {
                object2 = ((MultiFileResourceSetImpl)((Object)iterator)).getRootResourceManager();
                object = new AbstractTreeIterator(object2){
                    private static final long serialVersionUID = 1L;

                    protected Iterator getChildren(Object object) {
                        if (object instanceof ResourceManager) {
                            ArrayList<Object> arrayList = new ArrayList<Object>();
                            ResourceManager resourceManager = (ResourceManager)object;
                            arrayList.addAll(resourceManager.getResourceDescriptors());
                            arrayList.addAll(resourceManager.getSubManagers());
                            return arrayList.iterator();
                        }
                        return Collections.EMPTY_LIST.iterator();
                    }
                };
                URI uRI = MultiFileSaveUtil.getFinalURI(resource);
                while (object.hasNext()) {
                    ResourceDescriptor resourceDescriptor;
                    Object e = object.next();
                    if (!(e instanceof ResourceDescriptor) || !uRI.equals((Object)(resourceDescriptor = (ResourceDescriptor)e).getResolvedURI())) continue;
                    return resourceDescriptor;
                }
            }
        }
        return null;
    }

    public static ResourceManager getResourceManager(Resource resource) {
        ResourceManager resourceManager = null;
        for (Object e : resource.getContents()) {
            if (!(e instanceof ResourceManager)) continue;
            resourceManager = (ResourceManager)e;
            break;
        }
        return resourceManager;
    }

    static InternalEObject getContainerWithDirectResource(InternalEObject internalEObject) {
        if (internalEObject.eContainer() == null) {
            return null;
        }
        InternalEObject internalEObject2 = (InternalEObject)internalEObject.eContainer();
        if (internalEObject2.eDirectResource() != null) {
            return internalEObject2;
        }
        return MultiFileSaveUtil.getContainerWithDirectResource(internalEObject2);
    }

    static String getHREF(Resource resource, Object object) {
        MethodElement methodElement = PersistenceUtil.getMethodElement(resource);
        return MultiFileURIConverter.createURI(methodElement.getGuid()).appendFragment(MultiFileSaveUtil.getGuid(object)).toString();
    }

    public static String getBackupFileSuffix() {
        return "_" + dateFormatter.format(Calendar.getInstance().getTime());
    }

    public static void resolveProxies(Collection collection, EObject eObject) {
        Iterator iterator = eObject.eClass().getEAllContainments().iterator();
        while (!collection.isEmpty() && iterator.hasNext()) {
            InternalEList internalEList;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
            if (eStructuralFeature.isMany()) {
                internalEList = (InternalEList)eObject.eGet(eStructuralFeature);
                int n = 0;
                Iterator iterator2 = internalEList.basicIterator();
                while (!collection.isEmpty() && iterator2.hasNext()) {
                    InternalEObject internalEObject = (InternalEObject)iterator2.next();
                    if (internalEObject.eIsProxy()) {
                        String string = internalEObject.eProxyURI().fragment();
                        if (collection.contains(string)) {
                            internalEList.get(n);
                            collection.remove(string);
                        }
                    } else {
                        MultiFileSaveUtil.resolveProxies(collection, (EObject)internalEObject);
                    }
                    ++n;
                }
                continue;
            }
            internalEList = (InternalEObject)eObject.eGet(eStructuralFeature, false);
            if (internalEList == null) continue;
            if (internalEList.eIsProxy()) {
                String string = internalEList.eProxyURI().fragment();
                if (!collection.contains(string)) continue;
                eObject.eGet(eStructuralFeature);
                collection.remove(string);
                continue;
            }
            MultiFileSaveUtil.resolveProxies(collection, (EObject)internalEList);
        }
    }

    public static URI getFinalURI(Resource resource) {
        return resource instanceof MultiFileXMIResourceImpl ? ((MultiFileXMIResourceImpl)resource).getFinalURI() : resource.getURI();
    }

    static boolean adjustLocationRequired(MultiFileXMIResourceImpl multiFileXMIResourceImpl) {
        URI uRI;
        MethodElement methodElement = PersistenceUtil.getMethodElement(multiFileXMIResourceImpl);
        return methodElement != null && MultiFileSaveUtil.hasOwnFolder(methodElement) && MultiFileSaveUtil.adjustLocationRequired(multiFileXMIResourceImpl, uRI = MultiFileSaveUtil.createURI(methodElement, multiFileXMIResourceImpl.getResourceSet())) && !new File(uRI.toFileString()).exists();
    }

    public static int checkSynchronized(Resource resource) {
        if (resource instanceof MultiFileXMIResourceImpl) {
            return ((MultiFileXMIResourceImpl)resource).checkSynchronized();
        }
        return -1;
    }

    public static boolean same(long l, long l2) {
        return l < l2 && (l & 7L) == 0L && l2 - l < 1000L;
    }

    static ResourceManager addResourceManager(Resource resource) {
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManager(resource);
        if (resourceManager == null) {
            resourceManager = ResourcemanagerFactory.eINSTANCE.createResourceManager();
            resource.getContents().add(0, (Object)resourceManager);
            return resourceManager;
        }
        return null;
    }

    static void checkFilePathLength(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Resource resource : collection) {
            if (resource instanceof MultiFileXMIResourceImpl && ((MultiFileXMIResourceImpl)resource).hasTempURI()) continue;
            arrayList.add(resource.getURI().toFileString());
        }
        if (!arrayList.isEmpty()) {
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            int n = 0;
            while (n < stringArray.length) {
                String cfr_ignored_0 = stringArray[n];
                if (stringArray[n].length() > 255) {
                    String string = NLS.bind((String)PersistenceResources.filePathNameTooLong_msg, Arrays.asList(stringArray));
                    throw new MultiFileIOException(string);
                }
                ++n;
            }
        }
    }

    public static Iterator listConfigFiles(File file) {
        return new AbstractTreeIterator(file, false){
            private static final long serialVersionUID = 2758436193000640907L;
            FileFilter filter = new FileFilter(){

                public boolean accept(File file) {
                    return !FileManager.getInstance().isTeamPrivate(file.getAbsolutePath()) && (file.isDirectory() || file.getName().endsWith(MultiFileSaveUtil.DEFAULT_FILE_EXTENSION));
                }
            };

            protected Iterator getChildren(Object object) {
                File[] fileArray = ((File)object).listFiles(this.filter);
                if (fileArray != null && fileArray.length > 0) {
                    return Arrays.asList(fileArray).iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
    }
}

