/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class MultiFileURIConverter
extends URIConverterImpl {
    public static final String SCHEME = "uma";
    private static final HashSet lockedGUIDs = new HashSet();
    protected ResourceManager resMgr;
    private URI libraryURI;
    private URI libraryUmaURI;
    private MultiFileResourceSetImpl resourceSet;
    private boolean resolveProxy;

    public MultiFileURIConverter(MultiFileResourceSetImpl multiFileResourceSetImpl) {
        this.resourceSet = multiFileResourceSetImpl;
    }

    void setResolveProxy(boolean bl) {
        this.resolveProxy = bl;
    }

    void setLibraryURIs(MethodLibrary methodLibrary) {
        this.libraryURI = methodLibrary.eResource().getURI();
        this.libraryUmaURI = URI.createURI((String)new StringBuffer(SCHEME).append("://").append(methodLibrary.getGuid()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockGUID(String string) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            lockedGUIDs.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLockedGUID(String string) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            return lockedGUIDs.contains(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean unlockGUID(String string) {
        HashSet hashSet = lockedGUIDs;
        synchronized (hashSet) {
            return lockedGUIDs.remove(string);
        }
    }

    public URI normalize(URI uRI) {
        return this.normalize(uRI, null);
    }

    public URI normalize(URI uRI, EObject eObject) {
        if (SCHEME.equalsIgnoreCase(uRI.scheme())) {
            String string = uRI.authority();
            if (MultiFileURIConverter.isLockedGUID(string)) {
                return null;
            }
            try {
                Object object;
                ResourceManager resourceManager;
                MultiFileURIConverter.lockGUID(string);
                ResourceDescriptor resourceDescriptor = null;
                HashSet hashSet = null;
                if (eObject != null && eObject.eResource() != null && (resourceManager = MultiFileSaveUtil.getResourceManager(eObject.eResource())) != null && (resourceDescriptor = MultiFileSaveUtil.findResourceDescriptor(resourceManager, string, null, this.resolveProxy)) == null) {
                    hashSet = new HashSet();
                    object = new AbstractTreeIterator(resourceManager){

                        protected Iterator getChildren(Object object) {
                            return ((ResourceManager)object).getSubManagers().iterator();
                        }
                    };
                    while (object.hasNext()) {
                        hashSet.add(object.next());
                    }
                }
                if (resourceDescriptor == null && this.getResourceManager() != null) {
                    resourceDescriptor = MultiFileSaveUtil.findResourceDescriptor(this.getResourceManager(), string, hashSet, this.resolveProxy);
                }
                if (resourceDescriptor != null) {
                    resourceManager = resourceDescriptor.getResolvedURI();
                    object = (URI)this.resourceSet.getURIToTempURIMap().get(resourceManager);
                    if (object != null) {
                        resourceManager = object;
                    }
                    if (uRI.hasFragment()) {
                        resourceManager = resourceManager.appendFragment(uRI.fragment());
                    }
                    ResourceManager resourceManager2 = resourceManager;
                    return resourceManager2;
                }
                return null;
            }
            finally {
                MultiFileURIConverter.unlockGUID(string);
            }
        }
        return super.normalize(uRI);
    }

    public InputStream createInputStream(URI uRI) throws IOException {
        if (uRI == null) {
            return null;
        }
        return super.createInputStream(uRI);
    }

    public static URI createURI(String string) {
        return URI.createURI((String)new StringBuffer(SCHEME).append("://").append(string).toString());
    }

    public static URI createURI(MethodElement methodElement) {
        return URI.createURI((String)MultiFileURIConverter.createUriString(methodElement));
    }

    public static String createUriString(Object object) {
        InternalEObject internalEObject = (InternalEObject)object;
        URI uRI = internalEObject.eProxyURI();
        if (uRI != null && SCHEME.equals(uRI.scheme())) {
            return uRI.toString();
        }
        String string = MultiFileSaveUtil.getGuid(object);
        if (string == null) {
            return null;
        }
        return new StringBuffer(SCHEME).append("://").append(string).toString();
    }

    public ResourceManager getResourceManager() {
        if (this.resMgr == null) {
            this.resMgr = this.resourceSet.getRootResourceManager();
        }
        return this.resMgr;
    }

    public ResourceDescriptor findResourceDescriptor(String string) {
        return MultiFileSaveUtil.findResourceDescriptor(this.getResourceManager(), string, null, this.resolveProxy);
    }

    public void dispose() {
        if (this.resMgr != null) {
            this.resMgr.dispose();
            this.resMgr = null;
        }
    }

    public void setURIMapping(EObject eObject, URI uRI, Set set) {
        this.setURIMapping(eObject, uRI, set, true);
    }

    public void setURIMapping(EObject eObject, URI uRI, Set set, boolean bl) {
        String string = MultiFileSaveUtil.getGuid(eObject);
        ResourceManager resourceManager = MultiFileSaveUtil.getResourceManagerFor(eObject, set);
        ResourceDescriptor resourceDescriptor = resourceManager.getResourceDescriptor(string);
        if (resourceDescriptor != null) {
            if (bl) {
                resourceDescriptor.setResolvedURI(uRI);
            } else {
                resourceDescriptor.getResolvedURI();
                resourceDescriptor.setUri(uRI.deresolve(MultiFileSaveUtil.getFinalURI(resourceDescriptor.eResource())).toString());
            }
            if (set != null) {
                set.add(resourceDescriptor.eResource());
            }
        } else {
            MultiFileResourceSetImpl multiFileResourceSetImpl = (MultiFileResourceSetImpl)eObject.eResource().getResourceSet();
            ResourceManager resourceManager2 = multiFileResourceSetImpl.getRootResourceManager();
            resourceDescriptor = MultiFileSaveUtil.findResourceDescriptor(resourceManager2, string, Collections.singletonList(resourceManager), this.resolveProxy);
            if (resourceDescriptor != null) {
                ResourceManager resourceManager3 = (ResourceManager)resourceDescriptor.eContainer();
                ResourceManager resourceManager4 = null;
                for (ResourceManager resourceManager5 : resourceManager3.getSubManagers()) {
                    URI uRI2 = ((MultiFileXMIResourceImpl)resourceManager5.eResource()).getFinalURI();
                    if (!uRI2.equals((Object)uRI)) continue;
                    resourceManager4 = resourceManager5;
                    break;
                }
                resourceManager.getResourceDescriptors().add(resourceDescriptor);
                if (set != null) {
                    set.add(resourceManager3.eResource());
                    set.add(resourceManager.eResource());
                }
                if (resourceManager4 != null) {
                    resourceManager.getSubManagers().add(resourceManager4);
                }
                if (bl) {
                    resourceDescriptor.setResolvedURI(uRI);
                } else {
                    resourceDescriptor.getResolvedURI();
                    resourceDescriptor.setUri(uRI.deresolve(resourceDescriptor.eResource().getURI()).toString());
                }
                if (set != null) {
                    set.add(resourceDescriptor.eResource());
                }
            } else {
                MultiFileSaveUtil.registerWithResourceManager(resourceManager, eObject, uRI);
                if (set != null) {
                    set.add(resourceManager.eResource());
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        URI uRI = URI.createURI((String)"uma://_LPzdAGZ7EdmAm_xSX2EdUA#//@breakdownElements.0");
        System.out.println(uRI);
        System.out.println("deresolved URI: " + uRI.deresolve(URI.createURI((String)"uma://_LPzdAGZ7EdmAm_xSX2EdUA")));
    }
}

