/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal.migration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.IDiagramMigration;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.library.xmi.internal.migration.MigrationUtil;
import org.eclipse.epf.library.xmi.internal.migration.Migrator102;
import org.eclipse.epf.library.xmi.internal.migration.MigratorBase;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.Whitepaper;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Migrator103
extends MigratorBase {
    private Map<String, Process> diagramElemMap;
    private static boolean xmlMigrate = false;

    @Override
    public void migrate(String string, IProgressMonitor iProgressMonitor) throws Exception {
        this.migrate(string, iProgressMonitor, null);
    }

    @Override
    public void migrate(String string, IProgressMonitor iProgressMonitor, UpgradeCallerInfo upgradeCallerInfo) throws Exception {
        File file = new File(string);
        boolean bl = true;
        if (upgradeCallerInfo != null && upgradeCallerInfo.getIsExportedPluginLib()) {
            bl = false;
        }
        xmlMigrate = false;
        ResourceUtil.open((String)file.getParent(), (IProgressMonitor)iProgressMonitor);
        MultiFileResourceSetImpl multiFileResourceSetImpl = null;
        this.diagramElemMap = new LinkedHashMap<String, Process>();
        try {
            Migrator103.updateStatus(iProgressMonitor, PersistenceResources.loadLibraryTask_name);
            multiFileResourceSetImpl = bl ? new MultiFileResourceSetImpl(false) : Migrator102.getImportPluginResourceSet();
            multiFileResourceSetImpl.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            MethodLibrary methodLibrary = multiFileResourceSetImpl.loadLibrary(string);
            LinkInfo.setLibrary((MethodLibrary)methodLibrary);
            Migrator103.updateStatus(iProgressMonitor, PersistenceResources.loadResourcesTask_name);
            this.updateAllContents(iProgressMonitor, methodLibrary);
            Migrator103.updateStatus(iProgressMonitor, PersistenceResources.saveLibraryTask_name);
            Map map = multiFileResourceSetImpl.getDefaultSaveOptions();
            multiFileResourceSetImpl.save(map, true);
            Migrator103.updateStatus(iProgressMonitor, PersistenceResources.refreshLibraryFilesTask_name);
            ResourceUtil.refreshResources((MethodLibrary)methodLibrary, (IProgressMonitor)iProgressMonitor);
            Migrator103.diagramMigrate(this.diagramElemMap, iProgressMonitor);
            ResourceUtil.refreshResources((MethodLibrary)methodLibrary, (IProgressMonitor)iProgressMonitor);
        }
        finally {
            LinkInfo.setLibrary(null);
            if (multiFileResourceSetImpl != null) {
                multiFileResourceSetImpl.reset();
                multiFileResourceSetImpl = null;
            }
        }
    }

    protected static void diagramMigrate(Map<String, Process> map, IProgressMonitor iProgressMonitor) {
        Migrator103.updateStatus(iProgressMonitor, PersistenceResources.migratingDiagram_name);
        IDiagramMigration iDiagramMigration = (IDiagramMigration)ExtensionManager.getExtension((String)"org.eclipse.epf.library.xmi", (String)"diagramMigration");
        if (iDiagramMigration != null && !map.isEmpty()) {
            try {
                iDiagramMigration.migrate(map.values());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected void updateElement(MethodElement methodElement, IProgressMonitor iProgressMonitor) throws Exception {
        Migrator103.updateElement(methodElement, this.diagramElemMap, iProgressMonitor);
    }

    protected static void updateElement(MethodElement methodElement, Map<String, Process> map, IProgressMonitor iProgressMonitor) throws Exception {
        Process process;
        if (map != null && (methodElement instanceof CapabilityPattern || methodElement instanceof DeliveryProcess) && (process = (Process)methodElement).eContainer() instanceof ProcessComponent) {
            String string = methodElement.getGuid();
            Process process2 = map.get(string);
            if (process2 == null) {
                map.put(methodElement.getGuid(), (Process)methodElement);
            } else assert (process2 == methodElement);
        }
        MigrationUtil.formatValue(methodElement);
        Migrator103.handleTypeConvert(methodElement);
        if (!xmlMigrate) {
            Migrator103.handleShapeAndNodeIcons(methodElement);
        }
    }

    private static void handleTypeConvert(MethodElement methodElement) throws Exception {
        Guidance guidance;
        GuidanceDescription guidanceDescription;
        if ((methodElement instanceof Example || methodElement instanceof ReusableAsset || methodElement instanceof Whitepaper) && (guidanceDescription = Migrator103.convert((guidance = (Guidance)methodElement).getPresentation())) != null) {
            guidance.setPresentation((ContentDescription)guidanceDescription);
        }
    }

    private static GuidanceDescription convert(ContentDescription contentDescription) {
        List list;
        if (contentDescription == null) {
            return null;
        }
        GuidanceDescription guidanceDescription = UmaFactory.eINSTANCE.createGuidanceDescription();
        Resource resource = contentDescription.eResource();
        if (resource != null) {
            resource.getContents().remove((Object)contentDescription);
            resource.getContents().add((Object)guidanceDescription);
        }
        if ((list = LibraryUtil.getStructuralFeatures((MethodElement)contentDescription)) != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                Object object = contentDescription.eGet(eStructuralFeature);
                guidanceDescription.eSet(eStructuralFeature, object);
                ++n;
            }
        }
        return guidanceDescription;
    }

    private static void handleShapeAndNodeIcons(MethodElement methodElement) throws Exception {
        if (methodElement instanceof DescribableElement) {
            DescribableElement describableElement = (DescribableElement)methodElement;
            URI uRI = Migrator103.fixIconURI(describableElement, describableElement.getShapeicon());
            if (uRI != null) {
                describableElement.setShapeicon(uRI);
            }
            if ((uRI = Migrator103.fixIconURI(describableElement, describableElement.getNodeicon())) != null) {
                describableElement.setNodeicon(uRI);
            }
        }
    }

    private static URI fixIconURI(DescribableElement describableElement, URI uRI) {
        if (uRI == null) {
            return null;
        }
        File file = new File(NetUtil.decodedFileUrl((String)uRI.toString()));
        Stack<String> stack = new Stack<String>();
        File file2 = file;
        String string = "";
        while (file2 != null) {
            stack.push(file2.getName());
            file2 = file2.getParentFile();
        }
        if (!stack.isEmpty()) {
            String string2 = (String)stack.pop();
            while (!stack.isEmpty()) {
                if (string.length() > 0) {
                    string = String.valueOf(string) + '/';
                }
                string = String.valueOf(string) + (String)stack.pop();
            }
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)describableElement);
            try {
                URI uRI2 = new URI(string);
                if (!string2.equals(methodPlugin.getName())) {
                    File file3 = TngUtil.getLibraryRootPath((EObject)describableElement);
                    File file4 = new File(file3, NetUtil.decodedFileUrl((String)uRI.toString()));
                    File file5 = new File(file3, String.valueOf(methodPlugin.getName()) + File.separator + NetUtil.decodedFileUrl((String)uRI2.toString()));
                    if (!file5.exists()) {
                        FileUtil.copyFile((File)file4, (File)file5);
                    }
                }
                return uRI2;
            }
            catch (URISyntaxException uRISyntaxException) {
                XMILibraryPlugin.getDefault().getLogger().logError((Throwable)uRISyntaxException);
                return null;
            }
        }
        return null;
    }

    public void migrateXmlImportedLib(MethodLibrary methodLibrary, IProgressMonitor iProgressMonitor) throws Exception {
        xmlMigrate = true;
        Migrator103.updateStatus(iProgressMonitor, XMILibraryResources.migrateXMLLibrary_taskName);
        this.updateAllContents(iProgressMonitor, methodLibrary);
        LibraryUtil.saveLibrary((MethodLibrary)methodLibrary, (boolean)false, (boolean)false);
        xmlMigrate = false;
    }
}

