/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.RaisedMarginBorder;
import org.eclipse.epf.authoring.gef.edit.policies.RoleTaskFlowLayoutEditPolicy;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class RoleTaskCompositeEditPart
extends NodeContainerEditPart {
    private static Color BG_COLOR;

    public RoleTaskCompositeEditPart(RoleTaskComposite roleTaskComposite) {
        super((NodeContainer)roleTaskComposite);
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setMinorSpacing(20);
        figure.setLayoutManager((LayoutManager)flowLayout);
        figure.setBorder((Border)new RaisedMarginBorder());
        figure.setBackgroundColor(this.getBackgroundColor());
        figure.setOpaque(true);
        return figure;
    }

    protected void handlePropertyChanged(Notification notification) {
        switch (notification.getFeatureID(NodeContainer.class)) {
            case 7: {
                this.refreshChildren();
                EditPart editPart = this.getParent();
                editPart.refresh();
                return;
            }
        }
        super.handlePropertyChanged(notification);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new RoleTaskFlowLayoutEditPolicy());
        this.installEditPolicy("ComponentEditPolicy", null);
    }

    protected Color getBackgroundColor() {
        String string;
        if (BG_COLOR != null) {
            return BG_COLOR;
        }
        if (BG_COLOR == null && (string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("ADD_ROLE_TASKS_BOX_BG_COLOR_RGB")) != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            BG_COLOR = new Color(null, n, n2, n3);
            return BG_COLOR;
        }
        if (BG_COLOR == null) {
            BG_COLOR = new Color((Device)Display.getCurrent(), 255, 255, 156);
        }
        return BG_COLOR;
    }
}

