/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.epf.authoring.gef.edit.LabelTextCellEditorLocator;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.ValidatingDirectEditManager;
import org.eclipse.epf.authoring.gef.figures.Images;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.authoring.gef.figures.WPCompartmentFigure;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;

public class WPNodeEditPart
extends NamedNodeEditPart {
    int type = 1;

    public WPNodeEditPart(NamedNode namedNode) {
        super(namedNode);
    }

    protected IFigure createFigure() {
        if (this.getModel() instanceof WorkProductNode) {
            this.type = ((WorkProductNode)this.getModel()).getType();
        }
        SelectableLabel selectableLabel = new SelectableLabel();
        selectableLabel.setLabelAlignment(1);
        selectableLabel.setTextPlacement(4);
        selectableLabel.setBackgroundColor(ColorConstants.white);
        Font font = new Font(null, "Arial", 9, 0);
        selectableLabel.setFont(font);
        if (this.type == 1) {
            selectableLabel.setIcon(Images.ARTIFACT);
        } else if (this.type == 2) {
            selectableLabel.setIcon(Images.DELIVERABLE);
        } else if (this.type == 3) {
            selectableLabel.setIcon(Images.OUTCOME);
        } else {
            selectableLabel.setIcon(Images.WORK_PRODUCT_DESCRIPTOR);
        }
        selectableLabel.setIconTextGap(5);
        WPCompartmentFigure wPCompartmentFigure = new WPCompartmentFigure(selectableLabel, this.type);
        return wPCompartmentFigure;
    }

    protected DirectEditManager createDirectEditManager() {
        Label label = ((WPCompartmentFigure)this.getFigure()).getLabel();
        return new ValidatingDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelTextCellEditorLocator(label), label){

            protected String validate(String string) {
                Object object = this.getEditPart().getModel();
                if (object instanceof WorkProductNode) {
                    Node node = (Node)object;
                    Object object2 = node.getObject();
                    Suppression suppression = node.getDiagram().getSuppression();
                    return TngUtil.checkWorkProductDescriptorPresentationName((Object)object2, (String)string, (Suppression)suppression);
                }
                return super.validate(string);
            }
        };
    }

    IFigure getDirectEditFigure() {
        return ((WPCompartmentFigure)this.getFigure()).getLabel();
    }
}

