/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.viewer;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.authoring.gef.edit.DiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDiagramGraphicalViewer {
    protected Composite parent;
    protected GraphicalViewer graphicalViewer;
    protected Object wrapper;

    public AbstractDiagramGraphicalViewer(Composite composite) {
        this.parent = composite;
        this.createGraphicalViewer();
    }

    public AbstractDiagramGraphicalViewer(Composite composite, Object object) {
        this.parent = composite;
        this.wrapper = object;
        this.createGraphicalViewer();
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        ScrollingGraphicalViewer scrollingGraphicalViewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart scalableFreeformRootEditPart = new ScalableFreeformRootEditPart();
        scrollingGraphicalViewer.setRootEditPart((RootEditPart)scalableFreeformRootEditPart);
        scrollingGraphicalViewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected IFigure getFigure() {
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        LayerManager layerManager = (LayerManager)graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure iFigure = layerManager.getLayer((Object)"Printable Layers");
        return iFigure;
    }

    protected void setSuppressionToDiagram(Diagram diagram) {
        Process process;
        Object object = diagram.getObject();
        if (object instanceof BreakdownElement && (process = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)object))) != null) {
            diagram.setSuppression(Suppression.getSuppression((Process)process));
        }
    }

    public EditPart loadDiagram(Object object, boolean bl, IFilter iFilter, Suppression suppression) {
        IFigure iFigure;
        EditPart editPart = this.createEditPart(object, iFilter, suppression);
        this.graphicalViewer.setContents(editPart);
        this.parent.pack(true);
        Object object2 = TngUtil.unwrap((Object)object);
        if (object2 instanceof VariabilityElement && this.getDiagramType() != null && this.getDiagramType().equalsIgnoreCase("ActivityDetail") && TngUtil.hasContributor((VariabilityElement)((VariabilityElement)object2))) {
            bl = true;
        }
        if (bl) {
            this.cleanUpDiagram();
        }
        if ((iFigure = this.getFigure()) != null) {
            Rectangle rectangle = iFigure.getBounds();
            if (rectangle.x < 0 || rectangle.y < 0) {
                ((DiagramEditPart)editPart).moveFigure(-rectangle.x, -rectangle.y);
                this.parent.pack(true);
                rectangle = iFigure.getBounds();
            }
        }
        return editPart;
    }

    protected void loadDiagramInfo(GraphicalEditPart graphicalEditPart, DiagramInfo diagramInfo) {
        List list = graphicalEditPart.getChildren();
        for (Object e : list) {
            if (e instanceof NodeContainerEditPart) {
                this.loadDiagramInfo((GraphicalEditPart)e, diagramInfo);
                continue;
            }
            if (!(e instanceof GraphicalEditPart)) continue;
            graphicalEditPart = (GraphicalEditPart)e;
            Object object = graphicalEditPart.getModel();
            Object object2 = object;
            if (object2 instanceof LinkedObject) {
                object2 = ((LinkedObject)object2).getObject();
            }
            if (object2 instanceof DiagramElement || !(object2 instanceof MethodElement)) continue;
            boolean bl = object instanceof NamedNode ? ((NamedNode)object).isSuppressed() : ((MethodElement)object2).getSuppressed().booleanValue();
            IFigure iFigure = graphicalEditPart.getFigure();
            Rectangle rectangle = iFigure.getBounds();
            String string = null;
            if (iFigure instanceof SelectableLabel) {
                string = ((SelectableLabel)iFigure).getText();
            }
            diagramInfo.addArea((MethodElement)object2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, string, bl);
        }
    }

    public DiagramInfo getDiagramInfo() {
        DiagramInfo diagramInfo = null;
        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)this.graphicalViewer.getContents();
        Object object = graphicalEditPart.getModel();
        if (object instanceof LinkedObject) {
            object = ((LinkedObject)object).getObject();
        }
        if (object instanceof MethodElement) {
            diagramInfo = new DiagramInfo(this.getDiagramType(), (MethodElement)object);
            this.loadDiagramInfo(graphicalEditPart, diagramInfo);
        }
        return diagramInfo;
    }

    public Image createDiagramImage() {
        IFigure iFigure = this.getFigure();
        SWTGraphics sWTGraphics = null;
        GC gC = null;
        Image image = null;
        try {
            try {
                Rectangle rectangle = iFigure.getBounds();
                int n = rectangle.height;
                int n2 = rectangle.width;
                Display display = Display.getDefault();
                image = new Image((Device)display, n2, n);
                gC = new GC((Drawable)image);
                sWTGraphics = new SWTGraphics(gC);
                iFigure.paint((Graphics)sWTGraphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (sWTGraphics != null) {
                    sWTGraphics.dispose();
                }
                if (gC != null) {
                    gC.dispose();
                }
            }
        }
        finally {
            if (sWTGraphics != null) {
                sWTGraphics.dispose();
            }
            if (gC != null) {
                gC.dispose();
            }
        }
        return image;
    }

    public void dispose() {
        try {
            if (this.graphicalViewer != null) {
                Control control = this.graphicalViewer.getControl();
                if (control != null) {
                    control.dispose();
                }
                this.graphicalViewer = null;
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected abstract EditPart createEditPart(Object var1, IFilter var2, Suppression var3);

    protected abstract String getDiagramType();

    protected void cleanUpDiagram() {
    }
}

