/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.authoring.ui.util.LibraryValidationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyValidationMgr;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.validation.constraints.LibraryTraversalStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class LibraryValidateAction
extends ValidateAction {
    private HashSet resources;
    private boolean success;
    private boolean showSuccess = true;
    private Map contextData = new HashMap();

    public LibraryValidateAction() {
        this.eclipseResourcesUtil = new LibraryValidationMarkerHelper();
    }

    public LibraryValidateAction(boolean bl) {
        this();
        this.showSuccess = bl;
    }

    public void putContextData(Object object, Object object2) {
        this.contextData.put(object, object2);
    }

    protected Diagnostic validate(final IProgressMonitor iProgressMonitor) {
        Object var10_12;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.resources == null) {
            this.resources = new HashSet();
        } else {
            this.resources.clear();
        }
        boolean bl = false;
        Collection<Object> collection = new ArrayList();
        Iterator iterator = this.selectedObjects.iterator();
        while (iterator.hasNext()) {
            object4 = TngUtil.unwrap(iterator.next());
            if (!(object4 instanceof EObject)) continue;
            collection.add(object4);
            object3 = ((EObject)object4).eResource();
            if (object3 != null) {
                this.resources.add(object3);
            }
            if (bl || !(object4 instanceof MethodElement)) continue;
            object2 = UmaUtil.getMethodLibrary((EObject)((MethodElement)object4));
            this.putContextData("CTX_DEPENDENCY_VALIDATION_MGR", new DependencyValidationMgr((MethodLibrary)object2));
            bl = true;
        }
        int n = collection.size();
        collection = LibraryTraversalStrategy.makeTargetsDisjoint(collection);
        object4 = new LibraryTraversalStrategy.LibraryIterator(collection, true, 1, true);
        while (object4.hasNext()) {
            object3 = object4.next();
            ++n;
            if (!(object3 instanceof EObject) || (object2 = ((EObject)object3).eResource()) == null) continue;
            this.resources.add(object2);
        }
        iProgressMonitor.beginTask("", n);
        object3 = new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                return TngUtil.getLabelWithPath((Object)eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnosticChain, Map map) {
                iProgressMonitor.worked(1);
                if (map == null) {
                    map = LibraryValidateAction.this.contextData;
                } else {
                    map.putAll(LibraryValidateAction.this.contextData);
                }
                return super.validate(eClass, eObject, diagnosticChain, map);
            }
        };
        object2 = new ArrayList(collection);
        int n2 = object2.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            object = object2.get(n3);
            if (object instanceof NamedElement) {
                stringBuffer.append(((NamedElement)object).getName()).append(", ");
            }
            ++n3;
        }
        Object v0 = var10_12 = n2 < 0 ? null : object2.get(n2);
        if (var10_12 instanceof NamedElement) {
            stringBuffer.append(((NamedElement)var10_12).getName());
        }
        object = new BasicDiagnostic("org.eclipse.emf.ecore", 0, EcorePlugin.INSTANCE.getString("_UI_DiagnosticRoot_diagnostic", new Object[]{stringBuffer.toString()}), object2.toArray());
        for (EObject eObject : collection) {
            iProgressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{object3.getObjectLabel(eObject)}));
            object3.validate(eObject, object);
        }
        this.success = object.getSeverity() == 0;
        return object;
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        if (diagnostic != null) {
            Object object;
            if (this.showSuccess || !this.isSuccessful()) {
                object = this.eclipseResourcesUtil;
                this.eclipseResourcesUtil = null;
                try {
                    super.handleDiagnostic(diagnostic);
                }
                finally {
                    this.eclipseResourcesUtil = object;
                }
            }
            if (this.eclipseResourcesUtil != null) {
                IWorkbenchPart iWorkbenchPart;
                object = this.resources.iterator();
                while (object.hasNext()) {
                    this.eclipseResourcesUtil.deleteMarkers((Object)((Resource)object.next()));
                }
                object = null;
                if (!diagnostic.getChildren().isEmpty()) {
                    Object object2;
                    List list;
                    iWorkbenchPart = new HashMap();
                    for (Diagnostic object3 : diagnostic.getChildren()) {
                        Resource resource;
                        list = object3.getData();
                        if (list.isEmpty() || !((object2 = list.get(0)) instanceof EObject) || (resource = ((EObject)object2).eResource()) == null) continue;
                        iWorkbenchPart.put(object3, resource);
                    }
                    for (Map.Entry entry : iWorkbenchPart.entrySet()) {
                        list = (Diagnostic)entry.getKey();
                        object2 = (Resource)entry.getValue();
                        this.eclipseResourcesUtil.createMarkers(object2, (Diagnostic)list);
                    }
                    List list2 = ((Diagnostic)diagnostic.getChildren().get(0)).getData();
                    if (!list2.isEmpty()) {
                        IWorkbenchPart iWorkbenchPart2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                        list = list2.get(0);
                        if (iWorkbenchPart2 instanceof ISetSelectionTarget) {
                            ((ISetSelectionTarget)iWorkbenchPart2).selectReveal((ISelection)new StructuredSelection((Object)list));
                        } else if (iWorkbenchPart2 instanceof IViewerProvider && (object = ((IViewerProvider)iWorkbenchPart2).getViewer()) != null) {
                            object.setSelection((ISelection)new StructuredSelection(list2.get(0)), true);
                        }
                    }
                }
                if (object == null && (iWorkbenchPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IViewerProvider) {
                    object = ((IViewerProvider)iWorkbenchPart).getViewer();
                }
                if (object != null) {
                    object.refresh();
                }
                try {
                    this.refreshViews();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void refreshViews() {
        ConfigurationView.getView().getViewer().refresh();
    }

    public boolean isSuccessful() {
        return this.success;
    }
}

