/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.ProcessActivityFilter;
import org.eclipse.epf.authoring.ui.filters.ProcessRoleFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessRoleFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessTaskFilter;
import org.eclipse.epf.authoring.ui.filters.VariabilityProcessWorkProductFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.ui.PlatformUI;

public class DialogHelper {
    public static List selectElementsFor(BreakdownElement breakdownElement, IFilter iFilter, MethodConfiguration methodConfiguration, String string) {
        ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, string, null, methodConfiguration);
        itemsFilterDialog.setBlockOnOpen(true);
        itemsFilterDialog.setViewerSelectionSingle(false);
        itemsFilterDialog.setTitle(string);
        itemsFilterDialog.open();
        return itemsFilterDialog.getSelectedItems();
    }

    public static List selectTasksFor(Activity activity, MethodConfiguration methodConfiguration) {
        String string = FilterConstants.TASKS;
        VariabilityProcessTaskFilter variabilityProcessTaskFilter = new VariabilityProcessTaskFilter(methodConfiguration, null, FilterConstants.TASKS, activity);
        return DialogHelper.selectElementsFor((BreakdownElement)activity, (IFilter)variabilityProcessTaskFilter, methodConfiguration, string);
    }

    public static List selectElementsFor(Object object, MethodConfiguration methodConfiguration, AdapterFactory adapterFactory) {
        if (object instanceof Activity) {
            if (adapterFactory == TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()) {
                return DialogHelper.selectTasksFor((Activity)object, methodConfiguration);
            }
            if (adapterFactory == TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()) {
                String string = FilterConstants.ROLES;
                VariabilityProcessRoleFilter variabilityProcessRoleFilter = new VariabilityProcessRoleFilter(methodConfiguration, null, FilterConstants.ROLES, (Activity)object);
                return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)variabilityProcessRoleFilter, methodConfiguration, string);
            }
            if (adapterFactory == TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()) {
                String string = FilterConstants.WORKPRODUCTS;
                VariabilityProcessWorkProductFilter variabilityProcessWorkProductFilter = new VariabilityProcessWorkProductFilter(methodConfiguration, null, FilterConstants.WORKPRODUCTS, (Activity)object);
                return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)variabilityProcessWorkProductFilter, methodConfiguration, string);
            }
        }
        if (object instanceof TeamProfile && adapterFactory == TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()) {
            String string = FilterConstants.ROLES;
            ProcessRoleFilter processRoleFilter = new ProcessRoleFilter(methodConfiguration, null, FilterConstants.ROLES);
            return DialogHelper.selectElementsFor((BreakdownElement)object, (IFilter)processRoleFilter, methodConfiguration, string);
        }
        return Collections.EMPTY_LIST;
    }

    public static List selectActivitiesFor(Activity activity, MethodConfiguration methodConfiguration, int n) {
        String string = FilterConstants.PROCESSES;
        ProcessActivityFilter processActivityFilter = new ProcessActivityFilter(methodConfiguration, null, FilterConstants.PROCESSES, activity, n);
        List list = DialogHelper.selectElementsFor((BreakdownElement)activity, (IFilter)processActivityFilter, methodConfiguration, string);
        ArrayList arrayList = new ArrayList();
        for (Object e : list) {
            Process process;
            if (e instanceof Activity) {
                arrayList.add(e);
                continue;
            }
            if (!(e instanceof ProcessComponent) || (process = ((ProcessComponent)e).getProcess()) == null) continue;
            arrayList.add(process);
        }
        return arrayList;
    }
}

