/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.actions.LibraryViewDeleteAction;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.TermDefinition;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCategoryAssignPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "customCategoryAssignPage";
    private CustomCategory category;
    private ContentElementOrderList allSteps;

    public CustomCategoryAssignPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.ASSIGN_PAGE_TITLE);
    }

    @Override
    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.category = (CustomCategory)this.contentElement;
        this.setUseCategory2(false);
        this.setUseCategory3(false);
        this.setAllowChange1(true);
        this.setIsUpAndDownButtonsRequired1(true);
    }

    @Override
    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (CustomCategoryAssignPage.this.allSteps == null) {
                    CustomCategoryAssignPage.this.allSteps = new ContentElementOrderList(CustomCategoryAssignPage.this.contentElement, 1, CustomCategoryAssignPage.this.getContentCategoryOrderFeature());
                }
                List list = CategorySortHelper.sortCategoryElements((MethodElement)CustomCategoryAssignPage.this.contentElement, (Object[])CustomCategoryAssignPage.this.allSteps.toArray());
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    @Override
    protected void addItemsToModel1(ArrayList arrayList) {
        boolean bl = DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.category, (Collection)arrayList);
        if (!bl) {
            String string = AuthoringUIResources.circular_dependency_error_title;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, LibraryEditResources.circular_dependency_error_msg);
            return;
        }
        List<Object> list = this.getAncestors(this.category);
        if (!arrayList.isEmpty()) {
            for (MethodElement methodElement : arrayList) {
                if (methodElement instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)methodElement)) || list.contains(methodElement)) continue;
                if (methodElement instanceof ProcessComponent) {
                    Process process = ((ProcessComponent)methodElement).getProcess();
                    LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), this.category, (MethodElement)process, (List)this.usedCategories);
                    continue;
                }
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), this.category, methodElement, (List)this.usedCategories);
            }
            this.setDirty(true);
        }
    }

    @Override
    protected void removeItemsFromModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)this.category);
            for (Object object : arrayList) {
                if (object instanceof CustomCategory && TngUtil.isInPluginWithLessThanOneSuperCustomCategory((CustomCategory)((CustomCategory)object), (MethodPlugin)methodPlugin)) {
                    arrayList2.add(object);
                    continue;
                }
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), this.category, (MethodElement)object, (List)this.usedCategories);
            }
            if (arrayList2.size() > 0) {
                Object object;
                int n = 0;
                object = new StringBuffer();
                Object object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    Object object3 = TngUtil.unwrap(object2.next());
                    if (!(object3 instanceof MethodElement)) continue;
                    if (n > 0) {
                        ((StringBuffer)object).append(", ");
                    }
                    ((StringBuffer)object).append(((MethodElement)object3).getName());
                    ++n;
                }
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.remove_text, NLS.bind((String)AuthoringUIResources.promptDeleteCustomCategoryBeforeRemoveLastRefToIt, (Object)object))) {
                    return;
                }
                object2 = new LibraryViewDeleteAction(){

                    public void run() {
                        String string = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorTitle;
                        this.confirm = false;
                        try {
                            super.run();
                        }
                        catch (MessageException messageException) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, messageException.getMessage());
                        }
                        catch (Exception exception) {
                            String string2 = TngUtil.toStackTraceString((Throwable)exception);
                            String string3 = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorMessage;
                            String string4 = AuthoringUIResources.actions_LibraryActionBarContributor_deleteErrorReason;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, string3, string4, string2, (Throwable)exception);
                        }
                    }

                    protected void deleteFailed() {
                        String string = LibraryService.getInstance().getCurrentMethodLibraryLocation();
                        LibraryUIManager.getInstance().openLibrary(string);
                    }
                };
                object2.setEditingDomain(LibraryView.getView().getEditingDomain());
                object2.selectionChanged((IStructuredSelection)new StructuredSelection(arrayList2));
                object2.run();
            }
            this.setDirty(true);
        }
    }

    private List<Object> getAncestors(CustomCategory customCategory) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(customCategory);
        this.getAncestors(arrayList, arrayList2);
        return arrayList;
    }

    private List<Object> getAncestors(List<Object> list, List<Object> list2) {
        if (list2.isEmpty()) {
            return list;
        }
        ArrayList arrayList = new ArrayList();
        for (Object object : list2) {
            List list3 = AssociationHelper.getCustomCategories((DescribableElement)object);
            arrayList.addAll(list3);
        }
        list.addAll(list2);
        ArrayList arrayList2 = new ArrayList();
        for (List list3 : arrayList) {
            if (list.contains(list3)) continue;
            arrayList2.add(list3);
        }
        return this.getAncestors(list, arrayList2);
    }

    @Override
    protected Object getContentElement() {
        return this.category;
    }

    @Override
    protected String getTabString() {
        return FilterConstants.ALL_ELEMENTS;
    }

    @Override
    protected IFilter getFilter() {
        this.filter = new CustomCategoryAssignFilter();
        return this.filter;
    }

    @Override
    protected String getMultipleSelectDescription(int n) {
        return super.getMultipleSelectDescription(n, AuthoringUIResources.customCategoryAssignPage_multipleSelectDescription);
    }

    @Override
    protected String getSectionDescription() {
        return AuthoringUIResources.customCategoryAssignPage_sectionDescription;
    }

    @Override
    protected String getSectionName() {
        return AuthoringUIResources.customCategoryAssignPage_sectionName;
    }

    @Override
    protected String getSelectedLabel() {
        return AuthoringUIResources.customCategoryAssignPage_selectedLabel;
    }

    @Override
    protected String getSelectedLabel2() {
        return null;
    }

    @Override
    protected String getSelectedLabel3() {
        return null;
    }

    @Override
    protected EStructuralFeature getContentCategoryOrderFeature() {
        return UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements();
    }

    @Override
    protected String[] getModelStructurePath() {
        return ModelStructure.DEFAULT.customCategoryPath;
    }

    @Override
    protected ContentElementOrderList getContentElementOrderList() {
        return this.allSteps;
    }

    private class CustomCategoryAssignFilter
    extends AllFilter {
        private CustomCategoryAssignFilter() {
        }

        protected boolean childAccept(Object object) {
            if (object instanceof ProcessPackage) {
                return true;
            }
            if (object instanceof Process) {
                return true;
            }
            if (object instanceof Milestone) {
                return true;
            }
            if (object instanceof Activity) {
                return true;
            }
            if (object instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)object))) {
                return !((CustomCategory)object).getCategorizedElements().isEmpty();
            }
            if (object instanceof TermDefinition) {
                return false;
            }
            if (object instanceof ContentElement) {
                return !this.getHelper().isContributor((ContentElement)object);
            }
            return false;
        }
    }
}

