/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class WorkProductCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "workProductCategoriesPage";
    private WorkProduct workProduct;

    public WorkProductCategoriesPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.workProduct = (WorkProduct)this.contentElement;
        this.setUseCategory3(true);
        this.setCategoryIsSingleSelection1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getDomains((WorkProduct)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            Object e = arrayList.get(0);
            List list = AssociationHelper.getDomains((WorkProduct)this.workProduct);
            if (list != null && list.size() > 0) {
                Object e2 = list.get(0);
                String string = MessageFormat.format(LibraryEditResources.UserInteractionHelper_errRelationshipExists, this.workProduct.getName(), TngUtil.getLabelWithPath(e2), ((Domain)e).getName());
                Messenger.INSTANCE.showWarning(LibraryEditResources.errorDialog_title, string);
                return;
            }
            LibraryManager.getInstance().addToDomain(this.getActionManager(), (Domain)e, this.workProduct, (List)this.usedCategories);
        }
    }

    protected void removeItemsFromModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Domain domain : arrayList) {
                LibraryManager.getInstance().removeFromDomain(this.getActionManager(), domain, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getWorkProductTypes((WorkProduct)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (WorkProductType workProductType : arrayList) {
                LibraryManager.getInstance().addToWorkProductType(this.getActionManager(), workProductType, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (WorkProductType workProductType : arrayList) {
                LibraryManager.getInstance().removeFromWorkProductType(this.getActionManager(), workProductType, this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected3() {
        this.contentProviderSelected3 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((WorkProduct)object)).toArray();
            }
        };
        this.viewer_selected3.setContentProvider((IContentProvider)this.contentProviderSelected3);
    }

    protected void addItemsToModel3(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (CustomCategory customCategory : arrayList) {
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel3(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (CustomCategory customCategory : arrayList) {
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.workProduct, (List)this.usedCategories);
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.DOMAINS;
    }

    protected String getTabString2() {
        return FilterConstants.WORKPRODUCTTYPES;
    }

    protected String getTabString3() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object object) {
                return object instanceof Domain;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter2 = new CategoryFilter(){

            protected boolean childAccept(Object object) {
                return object instanceof WorkProductType;
            }
        };
        return this.filter2;
    }

    protected IFilter getFilter3() {
        this.filter3 = new CustomCategoryFilter();
        return this.filter3;
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.workProductCategoriesPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.workProductCategoriesPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel2;
    }

    protected String getSelectedLabel3() {
        return AuthoringUIResources.workProductCategoriesPage_selectedLabel3;
    }

    protected String getMultipleSelectDescriptionString() {
        return AuthoringUIResources.workProductCategoriesPage_multipleSelectDescription;
    }
}

