/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.filters.ActivityVariabilityFilter;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.properties.PropertiesUtil;
import org.eclipse.epf.authoring.ui.properties.WorkBreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.library.configuration.ProcessVariabilityConfigurator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityVariabilityCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.ui.dialogs.ConvertActivityDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityGeneralSection
extends WorkBreakdownElementGeneralSection {
    protected Activity element;
    private static final String NOT_APPLICABLE_TEXT = AuthoringUIResources.notApplicable_text;
    private static final String CONTRIBUTES_TEXT = AuthoringUIResources.contributes_text;
    private static final String EXTENDS_TEXT = AuthoringUIResources.extends_text;
    private static final String REPLACES_TEXT = AuthoringUIResources.replaces_text;
    private Text modelInfoText;
    private Label activityTypeLabel;
    private Text ctrl_type_text;
    private Button ctrl_type_button;
    private Combo ctrl_variability;
    private ComboViewer viewer_variability;
    private Text baseText;
    private Button selectButton;
    protected ILabelProvider variabilityLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            VariabilityType variabilityType = (VariabilityType)object;
            if (variabilityType == VariabilityType.NA_LITERAL) {
                return NOT_APPLICABLE_TEXT;
            }
            if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                return CONTRIBUTES_TEXT;
            }
            if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                return EXTENDS_TEXT;
            }
            if (variabilityType == VariabilityType.REPLACES_LITERAL) {
                return REPLACES_TEXT;
            }
            return null;
        }
    };
    private IContentProvider variabilityContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public Object[] getElements(Object object) {
            ArrayList<VariabilityType> arrayList = new ArrayList<VariabilityType>();
            arrayList.add(VariabilityType.NA_LITERAL);
            arrayList.add(VariabilityType.CONTRIBUTES_LITERAL);
            arrayList.add(VariabilityType.EXTENDS_LITERAL);
            arrayList.add(VariabilityType.REPLACES_LITERAL);
            return arrayList.toArray();
        }
    };

    @Override
    protected void init() {
        super.init();
        this.element = (Activity)this.getElement();
    }

    @Override
    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_ModelInfo);
        this.modelInfoText = FormUI.createText(this.toolkit, this.generalComposite, -1, this.horizontalSpan);
        this.modelInfoText.setEnabled(false);
        this.modelInfoText.setText(this.getModelInfo());
        this.activityTypeLabel = FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.Activity_Type);
        this.ctrl_type_text = this.toolkit.createText(this.generalComposite, "", 8);
        GridData gridData = new GridData(769);
        gridData.horizontalSpan = 1;
        this.ctrl_type_text.setLayoutData((Object)gridData);
        this.ctrl_type_button = this.toolkit.createButton(this.generalComposite, AuthoringUIText.CHANGE_TYPE_BUTTON_TEXT, 8);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_type_button.setLayoutData((Object)gridData);
        if (ConvertActivityDialog.getValidNewActivityTypes((Activity)this.element) == null) {
            this.ctrl_type_button.setVisible(false);
        }
        FormUI.createLabel(this.toolkit, this.generalComposite, "");
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.VARIABILITY_TYPE_TEXT);
        this.ctrl_variability = FormUI.createCombo(this.toolkit, this.generalComposite, 2);
        gridData = new GridData(1);
        gridData.horizontalSpan = 1;
        this.ctrl_variability.setLayoutData((Object)gridData);
        this.viewer_variability = new ComboViewer(this.ctrl_variability);
        this.viewer_variability.getCombo().setLayoutData((Object)new GridData(1));
        this.viewer_variability.setContentProvider(this.variabilityContentProvider);
        this.viewer_variability.setLabelProvider((IBaseLabelProvider)this.variabilityLabelProvider);
        this.viewer_variability.setInput((Object)this.element);
        gridData = FormUI.createLabel(this.toolkit, this.generalComposite, "");
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 2;
        gridData.setLayoutData((Object)gridData2);
        FormUI.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.BASE_ELEMENT_TEXT);
        this.baseText = FormUI.createText(this.toolkit, this.generalComposite);
        gridData2 = new GridData(769);
        gridData2.horizontalSpan = 2;
        this.baseText.setLayoutData((Object)gridData2);
        this.baseText.setEnabled(false);
        this.selectButton = FormUI.createButton(this.toolkit, this.generalComposite, AuthoringUIText.SELECT_BUTTON_TEXT);
    }

    private List<AbstractDiagramEditor> getDirtyDiagramEditors() {
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        Process process = TngUtil.getOwningProcess((BreakdownElement)this.element);
        ArrayList<AbstractDiagramEditor> arrayList = new ArrayList<AbstractDiagramEditor>();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            MethodElement methodElement;
            DiagramEditorInput diagramEditorInput;
            IEditorInput iEditorInput;
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            IEditorPart iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof AbstractDiagramEditor && iEditorPart.isDirty() && (iEditorInput = iEditorPart.getEditorInput()) instanceof DiagramEditorInputProxy && (diagramEditorInput = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null && (methodElement = diagramEditorInput.getMethodElement()) instanceof BreakdownElement && process == TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)methodElement))) {
                arrayList.add((AbstractDiagramEditor)iEditorPart);
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.ctrl_type_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessEditor processEditor = ActivityGeneralSection.this.getEditor();
                if (processEditor.isDirty() || !ActivityGeneralSection.this.getDirtyDiagramEditors().isEmpty()) {
                    String string = AuthoringUIResources.changeActivityTypeWarningDialog_title;
                    String string2 = AuthoringUIResources.descriptionTabGuidanceWarningDialog_message1;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(string, string2);
                } else {
                    ActivityGeneralSection.this.nameText.removeListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                    ActivityGeneralSection.this.presentationNameText.removeListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    Activity activity = ConvertActivityDialog.queryUserAndConvert((Activity)ActivityGeneralSection.this.element, null, null);
                    if (activity != null) {
                        StructuredSelection structuredSelection = new StructuredSelection((Object)activity);
                        ActivityGeneralSection.this.getPropertySheetPage().selectionChanged(ActivityGeneralSection.this.getPart(), (ISelection)structuredSelection);
                        ActivityGeneralSection.this.refresh();
                        ((ProcessViewer)((ProcessBreakdownStructureFormPage)ActivityGeneralSection.this.getEditor().getActivePageInstance()).getViewer()).expandToLevel(activity, 3);
                    }
                    ActivityGeneralSection.this.nameText.addListener(27, ActivityGeneralSection.this.nameDeactivateListener);
                    ActivityGeneralSection.this.presentationNameText.addListener(27, ActivityGeneralSection.this.presentationNameDeactivateListener);
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            List list = ActivityGeneralSection.this.getDirtyDiagramEditors();
                            for (AbstractDiagramEditor abstractDiagramEditor : list) {
                                abstractDiagramEditor.refresh();
                                IDocumentProvider iDocumentProvider = abstractDiagramEditor.getDocumentProvider();
                                if (!(iDocumentProvider instanceof SharedResourceDiagramDocumentProvider)) continue;
                                ((SharedResourceDiagramDocumentProvider)iDocumentProvider).markDocumentAsSaved((IFileEditorInput)abstractDiagramEditor.getEditorInput());
                            }
                        }
                    });
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.ctrl_variability.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection();
                VariabilityElement variabilityElement = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                VariabilityType variabilityType = (VariabilityType)iStructuredSelection.getFirstElement();
                if (variabilityElement != null & variabilityElement instanceof Activity) {
                    IStatus iStatus;
                    if (variabilityType != VariabilityType.NA_LITERAL && !(iStatus = DependencyChecker.checkCircularDependencyAfterFilterSelection((Activity)ActivityGeneralSection.this.element, (Activity)((Activity)variabilityElement), (VariabilityType)variabilityType)).isOK()) {
                        String string = AuthoringUIResources.activity_variability_error_title;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, iStatus.getMessage());
                        VariabilityType variabilityType2 = ActivityGeneralSection.this.element.getVariabilityType();
                        StructuredSelection structuredSelection = new StructuredSelection((Object)variabilityType2);
                        ActivityGeneralSection.this.viewer_variability.setSelection((ISelection)structuredSelection, true);
                        return;
                    }
                    bl = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType(), (Object)variabilityType, -1);
                    if (!bl) {
                        if ((ActivityGeneralSection.this.element.getPresentationName() == null || ActivityGeneralSection.this.element.getPresentationName().equals("")) && variabilityType.equals(VariabilityType.NA_LITERAL)) {
                            ActivityGeneralSection.this.element.setPresentationName(ActivityGeneralSection.this.element.getName());
                        }
                        return;
                    }
                    if ((ActivityGeneralSection.this.element.getPresentationName() == null || ActivityGeneralSection.this.element.getPresentationName().equals("")) && (variabilityType.equals(VariabilityType.CONTRIBUTES_LITERAL) || variabilityType.equals(VariabilityType.REPLACES_LITERAL) || variabilityType.equals(VariabilityType.NA_LITERAL))) {
                        ActivityGeneralSection.this.element.setPresentationName(ActivityGeneralSection.this.element.getName());
                    }
                }
                if (variabilityType == VariabilityType.NA_LITERAL) {
                    if (variabilityElement != null && !(bl = ActivityGeneralSection.this.actionMgr.doAction(1, (EObject)ActivityGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement(), null, -1))) {
                        return;
                    }
                    ActivityGeneralSection.this.selectButton.setEnabled(false);
                    ActivityGeneralSection.this.baseText.setText("");
                } else {
                    ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
                    VariabilityElement variabilityElement2 = ActivityGeneralSection.this.element.getVariabilityBasedOnElement();
                    arrayList.add(variabilityElement2);
                    ActivityGeneralSection.this.selectButton.setEnabled(true);
                }
            }
        });
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodConfiguration methodConfiguration = ActivityGeneralSection.this.getConfiguration();
                String string = FilterConstants.ACTIVITIES;
                VariabilityType variabilityType = (VariabilityType)((IStructuredSelection)ActivityGeneralSection.this.viewer_variability.getSelection()).getFirstElement();
                ActivityVariabilityFilter activityVariabilityFilter = new ActivityVariabilityFilter(methodConfiguration, null, string, ActivityGeneralSection.this.element);
                ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)activityVariabilityFilter, string, null, methodConfiguration);
                itemsFilterDialog.setBlockOnOpen(true);
                itemsFilterDialog.setViewerSelectionSingle(true);
                itemsFilterDialog.setTitle(string);
                itemsFilterDialog.open();
                ArrayList arrayList = itemsFilterDialog.getSelectedItems();
                if (arrayList != null && !arrayList.isEmpty()) {
                    VariabilityElement variabilityElement;
                    Object e = arrayList.get(0);
                    if (e instanceof Activity && !(variabilityElement = DependencyChecker.checkCircularDependencyAfterFilterSelection((Activity)ActivityGeneralSection.this.element, (Activity)((Activity)e), (VariabilityType)variabilityType)).isOK()) {
                        String string2 = AuthoringUIResources.activity_variability_error_title;
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string2, variabilityElement.getMessage());
                        return;
                    }
                    if (e instanceof VariabilityElement) {
                        variabilityElement = (VariabilityElement)e;
                        ProcessVariabilityConfigurator processVariabilityConfigurator = new ProcessVariabilityConfigurator(ActivityGeneralSection.this.getDefaultConfiguration(), null);
                        ActivityVariabilityCommand activityVariabilityCommand = new ActivityVariabilityCommand(ActivityGeneralSection.this.element, variabilityElement, variabilityType, (IConfigurator)processVariabilityConfigurator);
                        boolean bl = ActivityGeneralSection.this.actionMgr.execute((IResourceAwareCommand)activityVariabilityCommand);
                        if (!bl) {
                            return;
                        }
                        ActivityGeneralSection.this.baseText.setText(TngUtil.getLabelWithPath((Object)variabilityElement));
                    }
                }
            }
        });
    }

    private String getModelInfo() {
        String string = null;
        try {
            ItemProviderAdapter itemProviderAdapter = this.getAdapter();
            if (itemProviderAdapter instanceof IBSItemProvider) {
                IBSItemProvider iBSItemProvider = (IBSItemProvider)itemProviderAdapter;
                string = iBSItemProvider.getAttribute((Object)this.element, "model_info");
            }
        }
        catch (Exception exception) {}
        if (!StrUtil.isBlank(string)) {
            return string;
        }
        return PropertiesResources.Process_None;
    }

    @Override
    protected void updateControls() {
        super.updateControls();
        this.ctrl_type_button.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        this.selectButton.setEnabled(this.editable);
        this.ctrl_variability.setEnabled(this.editable);
        if (((IStructuredSelection)this.viewer_variability.getSelection()).getFirstElement() == VariabilityType.NA_LITERAL) {
            this.selectButton.setEnabled(false);
        }
    }

    @Override
    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                super.refresh();
                this.element = (Activity)this.getElement();
                this.modelInfoText.setText(this.getModelInfo());
                this.ctrl_type_text.setText(PropertiesUtil.getType(this.element));
                if (this.element instanceof Process && (this.element.getSuperActivities() == null || this.element.getSuperActivities() == null)) {
                    this.activityTypeLabel.setVisible(false);
                    this.ctrl_type_text.setVisible(false);
                    this.ctrl_type_button.setVisible(false);
                } else {
                    this.activityTypeLabel.setVisible(true);
                    this.ctrl_type_text.setVisible(true);
                    this.ctrl_type_button.setVisible(true);
                }
                VariabilityType variabilityType = this.element.getVariabilityType();
                StructuredSelection structuredSelection = new StructuredSelection((Object)variabilityType);
                this.viewer_variability.setSelection((ISelection)structuredSelection, true);
                if (this.element.getVariabilityBasedOnElement() != null) {
                    this.baseText.setText(TngUtil.getLabelWithPath((Object)this.element.getVariabilityBasedOnElement()));
                } else {
                    this.baseText.setText("");
                }
                if (variabilityType.equals(VariabilityType.LOCAL_CONTRIBUTION_LITERAL) || variabilityType.equals(VariabilityType.LOCAL_REPLACEMENT_LITERAL)) {
                    StructuredSelection structuredSelection2 = new StructuredSelection((Object)VariabilityType.NA_LITERAL);
                    this.viewer_variability.setSelection((ISelection)structuredSelection2);
                    this.ctrl_variability.setEnabled(false);
                } else {
                    this.ctrl_variability.setEnabled(this.editable);
                }
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing Activity general section : " + this.element, (Throwable)exception);
        }
    }

    @Override
    public String getNamePrefix() {
        if (this.element instanceof CapabilityPattern) {
            return String.valueOf(LibraryUIText.TEXT_CAPABILITY_PATTERN) + ": ";
        }
        if (this.element instanceof DeliveryProcess) {
            return String.valueOf(LibraryUIText.TEXT_DELIVERY_PROCESS) + ": ";
        }
        if (this.element instanceof Phase) {
            return String.valueOf(LibraryUIText.TEXT_PHASE) + ": ";
        }
        if (this.element instanceof Iteration) {
            return String.valueOf(LibraryUIText.TEXT_ITERATION) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_ACTIVITY) + ": ";
    }
}

