/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewConfigurationMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewConfigurationMainPage.class.getName();
    protected Composite composite;
    protected Text nameText;
    protected Text briefDescText;

    public NewConfigurationMainPage(String string) {
        super(string);
        this.setTitle(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageTitle);
        this.setDescription(AuthoringUIResources.AuthoringUIPlugin_NewConfigurationMainPage_pageDescription);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public NewConfigurationMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        this.composite = NewConfigurationMainPage.createGridLayoutComposite((Composite)composite, (int)3);
        NewConfigurationMainPage.createVerticallyAlignedLabel((Composite)this.composite, (String)AuthoringUIText.NAME_TEXT);
        this.nameText = NewConfigurationMainPage.createEditableText((Composite)this.composite, (int)2);
        NewConfigurationMainPage.createVerticallyAlignedLabel((Composite)this.composite, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = NewConfigurationMainPage.createEditableText((Composite)this.composite, (int)400, (int)80, (int)2);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        String string = "new_config";
        if (methodLibrary != null) {
            string = TngUtil.getNextAvailableName((List)methodLibrary.getPredefinedConfigurations(), (String)string);
        }
        this.nameText.setText(string);
    }

    protected void addListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewConfigurationMainPage.this.setPageComplete(NewConfigurationMainPage.this.isPageComplete());
                NewConfigurationMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public void onEnterPage(Object object) {
        if (this.nameText != null) {
            this.nameText.setFocus();
            this.nameText.selectAll();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        String string = this.getConfigurationName();
        if (!this.validateConfigurationName(string)) {
            return false;
        }
        if (this.configurationExists(string)) {
            this.setErrorMessage(LibraryEditResources.duplicateElementNameError_simple_msg);
            return false;
        }
        this.setErrorMessage(null);
        return this.getErrorMessage() == null;
    }

    protected boolean configurationExists(String string) {
        String[] stringArray = LibraryServiceUtil.getMethodConfigurationNames((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean validateConfigurationName(String string) {
        String string2 = TngUtil.checkElementName((String)string, (String)LibraryUIText.TEXT_METHOD_CONFIGURATON);
        if (string2 != null) {
            string2 = string2.replaceAll("\n\n", " ");
        }
        this.setErrorMessage(string2);
        return string2 == null;
    }

    public String getConfigurationName() {
        return this.nameText.getText().trim();
    }

    public String getBriefDescription() {
        return this.briefDescText.getText().trim();
    }
}

