/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.msp.ExportMSPException;
import org.eclipse.epf.export.msp.ExportMSPOptions;
import org.eclipse.epf.export.msp.ExportMSPPlugin;
import org.eclipse.epf.export.msp.ExportMSPResources;
import org.eclipse.epf.export.msp.ExportMSPServiceException;
import org.eclipse.epf.export.msp.ExportMSPXMLOperation;
import org.eclipse.epf.export.msp.ExportOptions;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.msproject.Assignment;
import org.eclipse.epf.msproject.DocumentRoot;
import org.eclipse.epf.msproject.MsprojectFactory;
import org.eclipse.epf.msproject.PredecessorLink;
import org.eclipse.epf.msproject.Project;
import org.eclipse.epf.msproject.Resource;
import org.eclipse.epf.msproject.util.MsprojectResourceImpl;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishManager;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.wizards.PublishProgressMonitorDialog;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMSPXMLService {
    private static boolean debug = ExportMSPPlugin.getDefault().isDebugging();
    private List referencedTasks = new ArrayList();
    private HashMap rolesToUidMap = new HashMap();
    private HashMap taskUidToWbsWapperPathMap = new HashMap();
    private HashMap wbsWapperPathToLocalPredListMap = new HashMap();
    private HashMap wbsGuidToTaskUidMap = new HashMap();
    private HashMap wbsWrapperPathToPredListMap = new HashMap();
    private String contentFolderName;
    private String abTargetDir;
    private boolean exportOnlyPlannedElements;
    private boolean publishContentSite = false;
    private int task_uid = 1;
    private int res_uid = 1;
    private int assign_uid = 1;
    protected MsprojectFactory projectFactory = MsprojectFactory.eINSTANCE;
    private Process process;
    private MethodConfiguration processConfig;
    private ConfigurableComposedAdapterFactory wbsAdapterFactory;
    private ProcessConfigurator breakdownElementFilter;
    private IStructuredContentProvider wbsContentProvider;
    private Map suppressionMap = new HashMap();
    private Suppression suppression;
    private Stack elementPaths = new Stack();
    private Object currentElement;
    private String currentElementPath;
    private PredecessorList currentPredList;
    private HashMap<org.eclipse.epf.msproject.Task, WorkBreakdownElement> taskToWbeMap;

    public boolean export(Process process, ExportMSPOptions exportMSPOptions) throws ExportMSPServiceException {
        MsprojectResourceImpl msprojectResourceImpl;
        File file;
        block10: {
            Object object;
            String string = exportMSPOptions.getMSProjectName();
            File file2 = exportMSPOptions.getExportDir();
            this.publishContentSite = exportMSPOptions.getPublishWebSite();
            PublishOptions publishOptions = exportMSPOptions.getPublishingOptions();
            this.processConfig = exportMSPOptions.getMethodConfiguration();
            if (debug) {
                System.out.println("$$$ exporting to Microsoft Project!");
                System.out.println("$$$ process          = " + process);
                System.out.println("$$$ configuration    = " + this.processConfig);
                System.out.println("$$$ msprojectName    = " + string);
                System.out.println("$$$ targetDir                 = " + file2.getAbsolutePath());
                System.out.println("$$$ exportOnlyPlannedElements = " + this.exportOnlyPlannedElements);
                System.out.println("$$$ publishConfigOptions      = " + publishOptions);
            }
            if (!file2.exists()) {
                file2.mkdirs();
            }
            this.abTargetDir = file2.getAbsolutePath();
            Path path = new Path(this.abTargetDir);
            boolean bl = string.toLowerCase().endsWith(".xml");
            String string2 = path.append(bl ? string : String.valueOf(string) + ".xml").toOSString();
            if (debug) {
                System.out.println("$$$ exportPathStr                 = " + string2);
            }
            String string3 = String.valueOf(ExportMSPPlugin.getDefault().getInstallPath()) + "template" + File.separator + "msproject_2003_template.xml";
            if (debug) {
                System.out.println("$$$ emptyTemplateFile             = " + string3);
            }
            try {
                file = new File(string3);
                object = new File(string2);
                FileUtil.copyFile((File)file, (File)object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            file = null;
            object = URI.createFileURI((String)string2);
            try {
                msprojectResourceImpl = new MsprojectResourceImpl(object);
                msprojectResourceImpl.getDefaultSaveOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                msprojectResourceImpl.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                msprojectResourceImpl.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
                msprojectResourceImpl.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                msprojectResourceImpl.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                msprojectResourceImpl.load(null);
                DocumentRoot documentRoot = (DocumentRoot)msprojectResourceImpl.getEObject("/");
                file = documentRoot.getProject();
                this.taskToWbeMap = new HashMap();
                if (this.generateMSProject(process, (Project)file, exportMSPOptions)) break block10;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ExportMSPException(exception);
            }
        }
        msprojectResourceImpl.save(null);
        if (debug) {
            ExportMSPXMLService.printMSProject((Project)file);
        }
        return true;
    }

    public boolean generateMSProject(Process process, Project project, ExportMSPOptions exportMSPOptions) throws Exception {
        MethodConfiguration methodConfiguration;
        block11: {
            if (process == null || project == null) {
                throw new IllegalArgumentException();
            }
            methodConfiguration = exportMSPOptions.getMethodConfiguration();
            if (methodConfiguration == null) {
                if (process instanceof DeliveryProcess) {
                    methodConfiguration = ((DeliveryProcess)process).getDefaultContext();
                } else if (process instanceof CapabilityPattern) {
                    methodConfiguration = ((CapabilityPattern)process).getDefaultContext();
                } else {
                    throw new IllegalArgumentException();
                }
            }
            this.contentFolderName = methodConfiguration.getName();
            PublishOptions publishOptions = exportMSPOptions.getPublishingOptions();
            if (!this.publishContentSite || publishOptions == null) break block11;
            File file = new File(exportMSPOptions.getExportDir(), this.contentFolderName);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (debug) {
                System.out.println("$$$ vieBuilder methodConfig = " + methodConfiguration);
                System.out.println("$$$ vieBuilder publishConfigOptions = " + publishOptions);
            }
            if (this.publishConfiguration(file.getAbsolutePath(), methodConfiguration, publishOptions)) break block11;
            return false;
        }
        this.exportOnlyPlannedElements = exportMSPOptions.getExportOnlyPlannedWBSElements();
        project.setName(process.getName());
        project.setStartDate((Object)new Date());
        project.setCreationDate((Object)new Date());
        project.setLastSaved((Object)new Date());
        project.setFinishDate((Object)new Date());
        this.setProjectExtendedAttributes(project);
        this.generateProjectResources(process, methodConfiguration, project);
        this.generateProjectTasks(process, methodConfiguration, project);
        this.generateLinks(process, project);
        this.generateWPDs(methodConfiguration);
        return true;
    }

    protected void setExportOptions(ExportOptions exportOptions) {
        Boolean bl = (Boolean)exportOptions.get("exportOnlyPlannedElements");
        this.exportOnlyPlannedElements = bl;
    }

    protected void generateProjectResources(Process process, MethodConfiguration methodConfiguration, Project project) throws Exception {
        ComposedAdapterFactory composedAdapterFactory = null;
        try {
            try {
                composedAdapterFactory = TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
                if (composedAdapterFactory instanceof ConfigurableComposedAdapterFactory) {
                    ((ConfigurableComposedAdapterFactory)composedAdapterFactory).setFilter((IFilter)new ProcessConfigurator(methodConfiguration, null));
                }
                AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)composedAdapterFactory);
                List list = process.getBreakdownElements();
                if (list.size() > 0) {
                    this.generateProjectResource((IStructuredContentProvider)adapterFactoryContentProvider, (BreakdownElement)process, project);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        finally {
            if (composedAdapterFactory != null) {
                composedAdapterFactory.dispose();
            }
        }
    }

    protected void generateProjectResource(IStructuredContentProvider iStructuredContentProvider, BreakdownElement breakdownElement, Project project) throws Exception {
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        if (breakdownElement instanceof RoleDescriptor) {
            this.addResource(breakdownElement, project);
            return;
        }
        if (iStructuredContentProvider != null) {
            Object[] objectArray = iStructuredContentProvider.getElements((Object)breakdownElement);
            int n = 0;
            while (n < objectArray.length) {
                Object object;
                RoleDescriptorWrapperItemProvider roleDescriptorWrapperItemProvider;
                Object object2 = objectArray[n];
                if (object2 instanceof RoleDescriptorWrapperItemProvider) {
                    roleDescriptorWrapperItemProvider = (RoleDescriptorWrapperItemProvider)object2;
                    object = roleDescriptorWrapperItemProvider.getValue();
                    if (object instanceof RoleDescriptor) {
                        this.addResource((BreakdownElement)object, project);
                    }
                } else if (object2 instanceof RoleDescriptor) {
                    this.addResource((BreakdownElement)object2, project);
                } else if (object2 instanceof BreakdownElementWrapperItemProvider) {
                    roleDescriptorWrapperItemProvider = (BreakdownElementWrapperItemProvider)object2;
                    object = roleDescriptorWrapperItemProvider.getValue();
                    if (object instanceof WorkBreakdownElement) {
                        this.generateProjectResource(iStructuredContentProvider, (BreakdownElement)((WorkBreakdownElement)object), project);
                    }
                } else if (object2 instanceof WorkBreakdownElement) {
                    this.generateProjectResource(iStructuredContentProvider, (BreakdownElement)((WorkBreakdownElement)object2), project);
                }
                ++n;
            }
        }
    }

    protected void addResource(BreakdownElement breakdownElement, Project project) throws Exception {
        Resource resource;
        if (!(breakdownElement instanceof RoleDescriptor)) {
            return;
        }
        RoleDescriptor roleDescriptor = (RoleDescriptor)breakdownElement;
        if (debug) {
            System.out.println("$$$ handle RoleDescriptor = " + roleDescriptor);
        }
        Role role = roleDescriptor.getRole();
        if (debug) {
            System.out.println("$$$ handle Ref-ed Role = " + role);
        }
        boolean bl = true;
        String string = this.getDisplayName((MethodElement)roleDescriptor);
        if (this.rolesToUidMap.get(string) != null) {
            bl = false;
        }
        boolean bl2 = false;
        String string2 = null;
        if (role != null && this.rolesToUidMap.get(string2 = this.getDisplayName((MethodElement)role)) == null && !string2.equalsIgnoreCase(string)) {
            bl2 = true;
        }
        if (bl) {
            resource = this.projectFactory.createResource();
            resource.setUID(BigInteger.valueOf(this.res_uid));
            resource.setID(BigInteger.valueOf(this.res_uid));
            resource.setName(string);
            project.getResources().getResource().add((Object)resource);
            this.rolesToUidMap.put(string, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
        if (bl2) {
            resource = this.projectFactory.createResource();
            resource.setUID(BigInteger.valueOf(this.res_uid));
            resource.setID(BigInteger.valueOf(this.res_uid));
            resource.setName(string2);
            project.getResources().getResource().add((Object)resource);
            this.rolesToUidMap.put(string2, BigInteger.valueOf(this.res_uid));
            ++this.res_uid;
        }
    }

    protected void generateProjectTasks(Process process, MethodConfiguration methodConfiguration, Project project) throws Exception {
        this.process = process;
        this.wbsAdapterFactory = null;
        try {
            try {
                this.suppression = new Suppression(process);
                this.suppressionMap.put(process, this.suppression);
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
                this.breakdownElementFilter = new ProcessConfigurator(methodConfiguration, null);
                this.wbsAdapterFactory.setFilter((IFilter)this.breakdownElementFilter);
                this.wbsContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.wbsAdapterFactory);
                this.currentElement = process;
                if (process instanceof CapabilityPattern) {
                    this.generateProjectTask(this.wbsContentProvider, process, 1, project);
                } else {
                    List list = process.getBreakdownElements();
                    if (list.size() > 0) {
                        this.generateProjectTask(this.wbsContentProvider, process, 1, project);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
        }
        finally {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.dispose();
            }
            if (this.suppressionMap != null) {
                this.suppressionMap.clear();
                this.suppressionMap = null;
            }
            if (this.wbsContentProvider != null) {
                this.wbsContentProvider.dispose();
            }
        }
    }

    private void enumerateProcessPredecessorLists() {
        AdapterFactoryTreeIterator adapterFactoryTreeIterator = new AdapterFactoryTreeIterator((AdapterFactory)this.wbsAdapterFactory, (Object)this.process);
        while (adapterFactoryTreeIterator.hasNext()) {
            Object e = adapterFactoryTreeIterator.next();
            System.out.println("treeIterator: " + e);
            IBSItemProvider iBSItemProvider = (IBSItemProvider)this.wbsAdapterFactory.adapt(e, ITreeItemContentProvider.class);
            PredecessorList predecessorList = iBSItemProvider.getPredecessors();
            for (IBSItemProvider iBSItemProvider2 : predecessorList) {
                System.out.println("    predList: " + iBSItemProvider2);
                if (!(iBSItemProvider2 instanceof ItemProviderAdapter)) continue;
                System.out.println("    unwrappedPredList: " + ((ItemProviderAdapter)iBSItemProvider2).getTarget());
            }
        }
    }

    protected void generateProjectTask(IStructuredContentProvider iStructuredContentProvider, Object object, int n, Project project) throws Exception {
        boolean bl;
        String[] stringArray;
        Object object2;
        boolean bl2;
        boolean bl3;
        Object object3;
        ArrayList arrayList;
        WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)TngUtil.unwrap((Object)object);
        if (workBreakdownElement instanceof WorkProductDescriptor || workBreakdownElement instanceof RoleDescriptor || workBreakdownElement.getSuppressed().booleanValue() || this.exportOnlyPlannedElements && !workBreakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        boolean bl4 = false;
        if (this.exportOnlyPlannedElements && workBreakdownElement instanceof Activity && iStructuredContentProvider != null) {
            Object[] objectArray = iStructuredContentProvider.getElements(object);
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object4;
                arrayList = objectArray[n2];
                if (arrayList instanceof Activity) {
                    if (!this.exportOnlyPlannedElements || ((Activity)arrayList).getIsPlanned().booleanValue()) {
                        bl4 = true;
                        break;
                    }
                } else if (arrayList instanceof ActivityWrapperItemProvider) {
                    object4 = TngUtil.unwrap((Object)arrayList);
                    if (object4 instanceof Activity && (!this.exportOnlyPlannedElements || ((Activity)object4).getIsPlanned().booleanValue())) {
                        bl4 = true;
                        break;
                    }
                } else if (arrayList instanceof TaskDescriptor) {
                    object4 = (TaskDescriptor)arrayList;
                    if (!this.exportOnlyPlannedElements || object4.getIsPlanned().booleanValue()) {
                        bl4 = true;
                        break;
                    }
                } else if (arrayList instanceof TaskDescriptorWrapperItemProvider && (object4 = TngUtil.unwrap(arrayList)) instanceof TaskDescriptor) {
                    object3 = (TaskDescriptor)object4;
                    if (!this.exportOnlyPlannedElements || object3.getIsPlanned().booleanValue()) {
                        bl4 = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        boolean bl5 = workBreakdownElement.getIsPlanned();
        org.eclipse.epf.msproject.Task task = null;
        if ((!this.exportOnlyPlannedElements || this.exportOnlyPlannedElements && bl5) && !(bl3 = this.isSuppressed(workBreakdownElement))) {
            task = this.addTask(object, n, project);
        }
        if (this.exportOnlyPlannedElements && task != null && workBreakdownElement instanceof Activity && iStructuredContentProvider != null && !bl4 && !(bl2 = this.calculateRollupRoles(iStructuredContentProvider, (BreakdownElement)workBreakdownElement, arrayList = new ArrayList()))) {
            object3 = new HashSet(arrayList);
            object2 = ((HashSet)object3).iterator();
            while (object2.hasNext()) {
                stringArray = (String[])object2.next();
                this.addAssignment((String)stringArray, task.getUID().intValue(), project);
            }
        }
        if (iStructuredContentProvider != null && !(bl = this.isSuppressed(workBreakdownElement))) {
            this.elementPaths.push(workBreakdownElement.getGuid());
            Object[] objectArray = iStructuredContentProvider.getElements(object);
            int n3 = 0;
            while (n3 < objectArray.length) {
                this.currentElement = object2 = objectArray[n3];
                stringArray = new String[this.elementPaths.size()];
                this.elementPaths.toArray(stringArray);
                StringBuffer stringBuffer = new StringBuffer();
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringBuffer.append(String.valueOf(stringArray[n4]) + ".");
                    ++n4;
                }
                if (this.currentElement instanceof BreakdownElementWrapperItemProvider) {
                    Object object5 = TngUtil.unwrap((Object)object2);
                    stringBuffer.append(((BreakdownElement)object5).getGuid());
                } else {
                    stringBuffer.append(((BreakdownElement)this.currentElement).getGuid());
                }
                this.currentElementPath = stringBuffer.toString();
                this.generateProjectTask(iStructuredContentProvider, object2, n + 1, project);
                ++n3;
            }
            this.generateLinks(this.process, project);
            this.elementPaths.pop();
        }
    }

    protected boolean isSuppressed(Object object) {
        if (object != null) {
            Process process;
            Suppression suppression;
            if (object instanceof Descriptor && debug) {
                System.out.println("Descriptor = " + ((Descriptor)object).getName());
            }
            if ((suppression = (Suppression)this.suppressionMap.get(process = TngUtil.getOwningProcess((Object)object))) == null) {
                suppression = new Suppression(process);
                this.suppressionMap.put(process, suppression);
            }
            if (suppression.isSuppressed(object)) {
                return true;
            }
            if (process != this.process && object instanceof WorkBreakdownElement) {
                this.elementPaths.push(((WorkBreakdownElement)object).getGuid());
                String[] stringArray = new String[this.elementPaths.size()];
                this.elementPaths.toArray(stringArray);
                Object object2 = this.suppression.getObjectByPath(stringArray, (AdapterFactory)this.wbsAdapterFactory);
                this.elementPaths.pop();
                return this.suppression.isSuppressed(object2);
            }
        }
        return false;
    }

    protected org.eclipse.epf.msproject.Task addTask(Object object, int n, Project project) throws Exception {
        org.eclipse.epf.msproject.Task task = this.addTask_(object, n, project);
        if (task != null) {
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)TngUtil.unwrap((Object)object);
            this.taskToWbeMap.put(task, workBreakdownElement);
        }
        return task;
    }

    private org.eclipse.epf.msproject.Task addTask_(Object object, int n, Project project) throws Exception {
        Object object2;
        Object object3;
        String string3;
        if (object == null) {
            return null;
        }
        WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)TngUtil.unwrap((Object)object);
        org.eclipse.epf.msproject.Task task = this.projectFactory.createTask();
        task.setName(this.getDisplayName((MethodElement)workBreakdownElement));
        task.setOutlineLevel(BigInteger.valueOf(n));
        task.setUID(BigInteger.valueOf(this.task_uid));
        task.setID(BigInteger.valueOf(this.task_uid));
        task.setType(BigInteger.valueOf(0L));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        task.setStart((Object)date);
        String string2 = this.getBriefDescription(workBreakdownElement);
        if (string2 != null && string2.trim().length() > 0) {
            task.setNotes(string2);
        }
        if (workBreakdownElement instanceof Milestone) {
            task.setMilestone(true);
            task.setDurationFormat(BigInteger.valueOf(7L));
        }
        List list = null;
        if (workBreakdownElement instanceof TaskDescriptor) {
            list = this.getRolesForTaskD((TaskDescriptor)workBreakdownElement);
        } else if (workBreakdownElement instanceof Task) {
            list = this.getRolesForTask((Task)workBreakdownElement);
        }
        if (list != null) {
            for (String string3 : list) {
                this.addAssignment(string3, this.task_uid, project);
            }
        }
        if (this.publishContentSite) {
            object3 = this.getElementURL((MethodElement)workBreakdownElement);
            if (workBreakdownElement instanceof TaskDescriptor) {
                string3 = (TaskDescriptor)workBreakdownElement;
                object2 = string3.getTask();
                this.referencedTasks.add(object2);
            }
            task.setHyperlinkAddress((String)object3);
        }
        project.getTasks().getTask().add((Object)task);
        if (debug) {
            System.out.println("$$$ theCurrent element: taskUid=" + this.task_uid + ", " + this.currentElement);
            System.out.println("                  path: " + this.currentElementPath);
        }
        this.storeTaskPredecessors(workBreakdownElement);
        this.taskUidToWbsWapperPathMap.put(BigInteger.valueOf(this.task_uid), this.currentElementPath);
        this.wbsGuidToTaskUidMap.put(workBreakdownElement.getGuid(), BigInteger.valueOf(this.task_uid));
        object3 = (IBSItemProvider)this.wbsAdapterFactory.adapt(object, ITreeItemContentProvider.class);
        string3 = object3.getPredecessors();
        object2 = new ArrayList();
        Iterator iterator = string3.iterator();
        while (iterator.hasNext()) {
            Object object4;
            Object e = iterator.next();
            if (debug) {
                System.out.println("    wrapperPredListMember: " + e);
            }
            if ((object4 = TngUtil.unwrap(e)) instanceof WorkBreakdownElement) {
                object2.add((WorkBreakdownElement)object4);
                if (debug) {
                    System.out.println("    unwrappedPredListMember: " + object4);
                }
            }
            if (!(e instanceof ItemProviderAdapter)) continue;
            object4 = ((ItemProviderAdapter)e).getTarget();
            object2.add((BreakdownElement)object4);
            if (!debug) continue;
            System.out.println("    unwrappedPredListMember: " + object4);
        }
        this.wbsWrapperPathToPredListMap.put(this.currentElementPath, object2);
        if (debug) {
            System.out.println("    __wrapperPredList: " + object2);
        }
        ++this.task_uid;
        return task;
    }

    private String getBriefDescription(WorkBreakdownElement workBreakdownElement) {
        TaskDescriptor taskDescriptor;
        Task task;
        if (workBreakdownElement == null) {
            return null;
        }
        String string = workBreakdownElement.getBriefDescription();
        if ((string == null || string.trim().length() <= 0) && workBreakdownElement instanceof TaskDescriptor && (task = (taskDescriptor = (TaskDescriptor)workBreakdownElement).getTask()) != null) {
            MethodElement methodElement = ConfigurationHelper.getCalculatedElement((MethodElement)task, (MethodConfiguration)this.processConfig);
            if (debug) {
                System.out.println("$$$ realizedElement = " + methodElement);
            }
            EAttribute eAttribute = UmaPackage.eINSTANCE.getMethodElement_BriefDescription();
            Object object = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)methodElement, (EStructuralFeature)eAttribute, (MethodConfiguration)this.processConfig);
            string = object.toString();
            if (debug) {
                System.out.println("$$$ realized brief desc = " + string);
            }
        }
        return string;
    }

    private void addAssignment(String string, int n, Project project) {
        Assignment assignment = this.projectFactory.createAssignment();
        assignment.setUID(BigInteger.valueOf(this.assign_uid));
        assignment.setTaskUID(BigInteger.valueOf(n));
        BigInteger bigInteger = (BigInteger)this.rolesToUidMap.get(string);
        assignment.setResourceUID(bigInteger);
        project.getAssignments().getAssignment().add((Object)assignment);
        ++this.assign_uid;
    }

    private List getRolesForTaskD(TaskDescriptor taskDescriptor) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RoleDescriptor roleDescriptor2 = (RoleDescriptor)ConfigurationHelper.getCalculatedElement((MethodElement)taskDescriptor.getPerformedPrimarilyBy(), (MethodConfiguration)this.breakdownElementFilter.getMethodConfiguration());
        if (roleDescriptor2 != null) {
            arrayList.add(this.getDisplayName((MethodElement)roleDescriptor2));
        }
        List list = ConfigurationHelper.getCalculatedElements((List)taskDescriptor.getAdditionallyPerformedBy(), (MethodConfiguration)this.breakdownElementFilter.getMethodConfiguration());
        for (RoleDescriptor roleDescriptor2 : list) {
            arrayList.add(this.getDisplayName((MethodElement)roleDescriptor2));
        }
        return arrayList;
    }

    private List getRolesForTask(Task task) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Role role2 = task.getPerformedBy();
        if (role2 != null) {
            arrayList.add(this.getDisplayName((MethodElement)role2));
        }
        List list = task.getAdditionallyPerformedBy();
        for (Role role2 : list) {
            arrayList.add(this.getDisplayName((MethodElement)role2));
        }
        return arrayList;
    }

    private boolean calculateRollupRoles(IStructuredContentProvider iStructuredContentProvider, BreakdownElement breakdownElement, List list) {
        boolean bl = false;
        Object[] objectArray = iStructuredContentProvider.getElements((Object)breakdownElement);
        int n = 0;
        while (n < objectArray.length) {
            Object object;
            Object object2 = objectArray[n];
            if (object2 instanceof Activity) {
                bl = !this.exportOnlyPlannedElements || ((Activity)object2).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(iStructuredContentProvider, (BreakdownElement)object2, list);
            } else if (object2 instanceof ActivityWrapperItemProvider) {
                object = TngUtil.unwrap((Object)object2);
                if (object instanceof Activity) {
                    bl = !this.exportOnlyPlannedElements || ((Activity)object).getIsPlanned().booleanValue() ? true : this.calculateRollupRoles(iStructuredContentProvider, (BreakdownElement)object, list);
                }
            } else if (object2 instanceof TaskDescriptor) {
                object = (TaskDescriptor)object2;
                if (!this.exportOnlyPlannedElements || object.getIsPlanned().booleanValue()) {
                    bl = true;
                } else {
                    list.addAll(this.getRolesForTaskD((TaskDescriptor)object2));
                }
            } else if (object2 instanceof TaskDescriptorWrapperItemProvider && (object = TngUtil.unwrap((Object)object2)) instanceof TaskDescriptor) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)object;
                if (!this.exportOnlyPlannedElements || taskDescriptor.getIsPlanned().booleanValue()) {
                    bl = true;
                } else {
                    list.addAll(this.getRolesForTaskD((TaskDescriptor)object));
                }
            }
            ++n;
        }
        return bl;
    }

    private void storeTaskPredecessors(WorkBreakdownElement workBreakdownElement) {
        if (workBreakdownElement == null) {
            return;
        }
        List list = workBreakdownElement.getLinkToPredecessor();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null && list.size() > 0) {
            for (WorkOrder workOrder : list) {
                String string;
                WorkBreakdownElement workBreakdownElement2 = workOrder.getPred();
                if (debug) {
                    System.out.println("    localPredListMember: " + workBreakdownElement2);
                }
                if (workBreakdownElement2 == null || (string = workBreakdownElement2.getGuid()) == null) continue;
                arrayList.add(string);
            }
        }
        if (debug) {
            System.out.println("   local predlist for " + workBreakdownElement.getName() + " = " + ((Object)arrayList).toString());
        }
        this.wbsWapperPathToLocalPredListMap.put(this.currentElementPath, arrayList);
    }

    protected void generateLinks(Process process, Project project) throws Exception {
        EList eList = project.getTasks().getTask();
        for (org.eclipse.epf.msproject.Task task : eList) {
            BigInteger bigInteger = task.getUID();
            if (bigInteger.intValue() == 0) continue;
            String string = (String)this.taskUidToWbsWapperPathMap.get(bigInteger);
            HashMap<String, WorkOrder> hashMap = this.getPredGuidToWOMap(this.taskToWbeMap.get(task));
            ArrayList arrayList = (ArrayList)this.wbsWrapperPathToPredListMap.get(string);
            if (arrayList == null) continue;
            ArrayList<MethodElement> arrayList2 = new ArrayList<MethodElement>();
            for (MethodElement methodElement : arrayList) {
                String string2 = methodElement.getGuid();
                BigInteger bigInteger2 = (BigInteger)this.wbsGuidToTaskUidMap.get(string2);
                if (bigInteger2 == null || bigInteger2.intValue() == bigInteger.intValue()) continue;
                if (debug) {
                    System.out.println("$$$ taskUid = " + bigInteger + ", wbsPathStr = " + string);
                    System.out.println("    localPredList: " + arrayList);
                    System.out.println("    found pred guid: " + string2);
                }
                arrayList2.add(methodElement);
                PredecessorLink predecessorLink = this.projectFactory.createPredecessorLink();
                task.getPredecessorLink().add((Object)predecessorLink);
                predecessorLink.setPredecessorUID(bigInteger2);
                BigInteger bigInteger3 = this.getLinkTypeInt(hashMap.get(string2));
                if (bigInteger3 != null) {
                    predecessorLink.setType(bigInteger3);
                }
                predecessorLink.setCrossProject(false);
                predecessorLink.setLinkLag(new BigInteger("0"));
                predecessorLink.setLagFormat(new BigInteger("7"));
            }
            arrayList.removeAll(arrayList2);
        }
    }

    private BigInteger getLinkTypeInt(WorkOrder workOrder) {
        WorkOrderType workOrderType = workOrder.getLinkType();
        if (workOrderType == WorkOrderType.FINISH_TO_START_LITERAL) {
            return new BigInteger("1");
        }
        if (workOrderType == WorkOrderType.START_TO_START_LITERAL) {
            return new BigInteger("3");
        }
        if (workOrderType == WorkOrderType.FINISH_TO_FINISH_LITERAL) {
            return new BigInteger("0");
        }
        if (workOrderType == WorkOrderType.START_TO_FINISH_LITERAL) {
            return new BigInteger("2");
        }
        return null;
    }

    private HashMap<String, WorkOrder> getPredGuidToWOMap(WorkBreakdownElement workBreakdownElement) {
        HashMap<String, WorkOrder> hashMap = new HashMap<String, WorkOrder>();
        if (workBreakdownElement != null) {
            List list = workBreakdownElement.getLinkToPredecessor();
            int n = list == null ? 0 : list.size();
            int n2 = 0;
            while (n2 < n) {
                WorkOrder workOrder = (WorkOrder)list.get(n2);
                hashMap.put(workOrder.getPred().getGuid(), workOrder);
                ++n2;
            }
        }
        return hashMap;
    }

    protected String getElementURL(MethodElement methodElement) {
        if (methodElement == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        try {
            string = ResourceHelper.getElementPath((MethodElement)methodElement);
            string2 = ResourceHelper.getFileName((MethodElement)methodElement, (String)".html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
        if (string != null && string2 != null) {
            string = string.replace('\\', '/');
            string2 = string2.replace('\\', '/');
            String string3 = String.valueOf(this.contentFolderName) + "/" + string + string2;
            return String.valueOf(this.abTargetDir) + File.separator + string3;
        }
        return "";
    }

    protected String getDisplayName(MethodElement methodElement) {
        String string = null;
        if (methodElement instanceof BreakdownElement) {
            string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)methodElement));
        } else if (methodElement instanceof DescribableElement) {
            string = ((DescribableElement)methodElement).getPresentationName();
        }
        if (string == null || string.length() == 0) {
            string = methodElement.getName();
        }
        return XMLUtil.escapeAttr((String)string);
    }

    protected boolean publishConfiguration(String string, MethodConfiguration methodConfiguration, PublishOptions publishOptions) throws Exception {
        PublishManager publishManager = null;
        try {
            publishManager = new PublishManager();
            publishManager.init(string, methodConfiguration, (PublishOptions)new PublishHTMLOptions(publishOptions));
            ExportMSPXMLOperation exportMSPXMLOperation = new ExportMSPXMLOperation((AbstractPublishManager)publishManager);
            PublishProgressMonitorDialog publishProgressMonitorDialog = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), publishManager.getViewBuilder());
            boolean bl = UserInteractionHelper.runWithProgress((IRunnableWithProgress)exportMSPXMLOperation, (IRunnableContext)publishProgressMonitorDialog, (boolean)true, (String)ExportMSPResources.exportMSPWizard_title);
            if (exportMSPXMLOperation.getException() != null) {
                throw exportMSPXMLOperation.getException();
            }
            boolean bl2 = bl && !publishProgressMonitorDialog.getProgressMonitor().isCanceled();
            return bl2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (publishManager != null) {
                publishManager.dispose();
                publishManager = null;
            }
        }
    }

    private static void printMSProject(Project project) {
        Object object;
        Object object22;
        System.out.println("\n$$$ read-in project = " + project);
        EList eList = project.getTasks().getTask();
        for (Object object22 : eList) {
            System.out.println("$$$ a task = " + object22);
        }
        Iterator iterator = project.getResources().getResource();
        object22 = iterator.iterator();
        while (object22.hasNext()) {
            object = (Resource)object22.next();
            System.out.println("$$$ a resource = " + object);
        }
        object22 = project.getAssignments().getAssignment();
        object = object22.iterator();
        while (object.hasNext()) {
            Assignment assignment = (Assignment)object.next();
            System.out.println("$$$ an assignment = " + assignment);
        }
        System.out.println("$$$===\n");
    }

    protected HashMap<org.eclipse.epf.msproject.Task, WorkBreakdownElement> getTaskToWbeMap() {
        return this.taskToWbeMap;
    }

    protected void setProjectExtendedAttributes(Project project) {
    }

    protected void generateWPDs(MethodConfiguration methodConfiguration) {
    }
}

