/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.commands.Command;

public class ChangeHeightCommand
extends Command {
    private Node node;
    private Point newLocation;
    private Point oldLocation;
    private int newHeight;
    private int oldHeight;
    private static final String LABEL = "Change Height Command";

    public ChangeHeightCommand(Node node, Point point, int n) {
        super(LABEL);
        this.setNode(node);
        this.setNewLocation(point.getCopy());
        this.newHeight = n;
    }

    public boolean canExecute() {
        return this.node != null && this.newLocation != null && (this.newHeight != this.oldHeight || !this.node.getLocation().equals((Object)this.newLocation));
    }

    public void execute() {
        this.oldLocation = this.node.getLocation();
        this.oldHeight = this.node.getHeight();
        this.redo();
    }

    public void redo() {
        this.node.setLocation(this.newLocation);
        this.node.setHeight(this.newHeight);
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void setNewLocation(Point point) {
        this.newLocation = point;
    }

    public void undo() {
        this.node.setHeight(this.oldHeight);
        this.node.setLocation(this.oldLocation);
    }
}

