/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.commands;

import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.epf.authoring.gef.util.Validation;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.commands.Command;

public class CreateLinkCommand
extends Command {
    private Link link;
    private Node source;
    private Node target;
    private Point targetEndPoint;
    private Point sourceEndPoint;
    private static final String LABEL = AuthoringUIResources.gef_createLinkCommand_label;

    public CreateLinkCommand(Link link, Node node) {
        super(LABEL);
        this.link = link;
        this.source = node;
    }

    public boolean canExecute() {
        boolean bl;
        boolean bl2 = bl = this.source != null && this.target != null && this.link != null;
        if (!bl) {
            return bl;
        }
        String string = Validation.checkConnect(this.source, this.target, this.link);
        return string == null;
    }

    public void execute() {
        if (this.source == this.target) {
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(-10, 10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(-10, -10)));
            this.link.getBendpoints().add((Object)new AbsoluteBendpoint(this.source.getLocation().getTranslated(10, -10)));
        }
        this.link.setTargetEndPoint(this.targetEndPoint);
        this.link.setSourceEndPoint(this.sourceEndPoint);
        this.link.setSource(this.source);
        this.link.setTarget(this.target);
    }

    public void setTarget(Node node) {
        this.target = node;
    }

    public void setTargetEndPoint(Point point) {
        this.targetEndPoint = point;
    }

    public void setSourceEndPoint(Point point) {
        this.sourceEndPoint = point;
    }

    public Point getTargetEndPoint() {
        return this.targetEndPoint;
    }

    public Point getSourceEndPoint() {
        return this.sourceEndPoint;
    }

    public void undo() {
        this.link.setSourceEndPoint(null);
        this.link.setTargetEndPoint(null);
        this.link.setSource(null);
        this.link.setTarget(null);
        if (this.source == this.target) {
            this.link.getBendpoints().clear();
        }
    }
}

