/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.Property;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ValidatingFreeTextEditManager
extends DirectEditManager {
    Font scaledFont;
    protected VerifyListener verifyListener;
    protected Label activityLabel;

    public ValidatingFreeTextEditManager(GraphicalEditPart graphicalEditPart, Class clazz, CellEditorLocator cellEditorLocator, Label label) {
        super(graphicalEditPart, clazz, cellEditorLocator);
        this.activityLabel = label;
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean bl) {
        GraphNode graphNode;
        String string;
        Font font = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (font != null) {
            font.dispose();
        }
        if (bl && ((string = ((Property)(graphNode = ((Node)this.getEditPart().getModel()).getGraphNode()).getProperty().get(0)).getValue()) == null || string.trim().length() == 0)) {
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), AuthoringUIResources.gef_validatingFreeTextEditManager_bringDownPrompt));
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                Text text = (Text)ValidatingFreeTextEditManager.this.getCellEditor().getControl();
                String string = text.getText();
                String string2 = string.substring(0, verifyEvent.start);
                String string3 = string.substring(verifyEvent.end, string.length());
                GC gC = new GC((Drawable)text);
                Point point = gC.textExtent(String.valueOf(string2) + verifyEvent.text + string3);
                gC.dispose();
                if (point.x != 0) {
                    point = text.computeSize(point.x, -1);
                }
                ValidatingFreeTextEditManager.this.getCellEditor().getControl().setSize(point.x, point.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String string = this.activityLabel.getText();
        this.getCellEditor().setValue((Object)string);
        text.selectAll();
        IFigure iFigure = this.getEditPart().getFigure();
        this.scaledFont = iFigure.getFont();
        FontData fontData = this.scaledFont.getFontData()[0];
        Dimension dimension = new Dimension(0, fontData.getHeight());
        this.activityLabel.translateToAbsolute((Translatable)dimension);
        fontData.setHeight(dimension.height);
        this.scaledFont = new Font(null, fontData);
        text.setFont(this.scaledFont);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.getCellEditor() != null) {
            Text text = (Text)this.getCellEditor().getControl();
            text.removeVerifyListener(this.verifyListener);
            this.verifyListener = null;
        }
    }

    protected String validate(String string) {
        return null;
    }

    protected void commit() {
        String string = this.validate((String)this.getCellEditor().getValue());
        if (string != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NamedNodeEditPart)this.getEditPart(), string));
            return;
        }
        super.commit();
    }

    static class PromptEdit
    implements Runnable {
        private NodeEditPart part;
        private String msg;

        PromptEdit(NodeEditPart nodeEditPart, String string) {
            this.part = nodeEditPart;
            this.msg = string;
        }

        public void run() {
            String string = DiagramUIResources.diagram_errorDialog_title_text0;
            String string2 = DiagramUIResources.diagram_node_property_value_problem_msg;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, string2, this.msg);
            this.part.performDirectEdit();
        }
    }
}

