/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.List;
import org.eclipse.epf.authoring.gef.util.DiagramEditorUtil;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.providers.MethodEditorPageProvider;
import org.eclipse.epf.authoring.ui.providers.ProcessEditorPageProvider;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationApplicator;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.CopyAttachmentsToNewLocation;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.preference.IPreferenceStore;

public class AuthoringUIService {
    private static AuthoringUIService instance = new AuthoringUIService();
    private boolean started = false;

    private AuthoringUIService() {
        LibraryService.getInstance().addListener(new ILibraryServiceListener(){

            public void libraryCreated(MethodLibrary methodLibrary) {
            }

            public void libraryOpened(MethodLibrary methodLibrary) {
            }

            public void libraryReopened(MethodLibrary methodLibrary) {
            }

            public void libraryClosed(MethodLibrary methodLibrary) {
            }

            public void librarySet(MethodLibrary methodLibrary) {
                if (methodLibrary != null) {
                    AuthoringUIService.this.start();
                }
                LibraryUIUtil.updateShellTitle();
            }

            public void configurationSet(MethodConfiguration methodConfiguration) {
            }
        });
    }

    public static AuthoringUIService getInstance() {
        return instance;
    }

    public synchronized void start() {
        if (!this.started) {
            LibraryUIPreferences.applyDefaultValuesForBreakdownElementAttributes();
            ProcessAuthoringConfigurator.INSTANCE.getClass();
            MethodElementAddCommand.setResourceManager((MethodElementAddCommand.ResourceManager)new CopyAttachmentsToNewLocation());
            EditorChooser.getInstance();
            MethodEditorPageProvider.getInstance().loadProviders();
            ProcessEditorPageProvider.getInstance().loadProviders();
            Providers.setConfiguratorFactory((IConfiguratorFactory)new IConfiguratorFactory(){

                public IConfigurator createConfigurator(MethodConfiguration methodConfiguration) {
                    return new ProcessConfigurator(methodConfiguration, null, true);
                }
            });
            Providers.setConfigurationApplicator((IConfigurationApplicator)new ConfigurationApplicator());
            Providers.setPreferenceStore((IPreferenceStore)LibraryPlugin.getDefault().getPreferenceStore());
            Providers.setAuthoringPlugin((AbstractPlugin)AuthoringUIPlugin.getDefault());
            List list = GraphicalDataManager.getInstance().getCommandListeners();
            list.addAll(DiagramEditorUtil.getInstance().getVaryCommandListeners());
            for (ICommandListener iCommandListener : list) {
                Providers.registerCommandListener((ICommandListener)iCommandListener);
            }
            RefreshJob.getInstance().start();
            this.started = true;
        }
    }

    public synchronized void stop() {
        if (this.started) {
            RefreshJob.getInstance().stop();
            this.started = false;
        }
    }
}

