/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.MethodAddImageDialog;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MethodAddImageAction
extends RichTextAction {
    public MethodAddImageAction(IRichText iRichText) {
        super(iRichText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_ADD_IMAGE);
        this.setToolTipText(RichTextResources.addImageAction_toolTipText);
        this.setEnabled(true);
    }

    public void execute(IRichText iRichText) {
        if (iRichText != null && iRichText instanceof IMethodRichText) {
            MethodAddImageDialog methodAddImageDialog = new MethodAddImageDialog(Display.getCurrent().getActiveShell(), ((IMethodRichText)iRichText).getMethodElement());
            methodAddImageDialog.open();
            if (methodAddImageDialog.getReturnCode() == 0 && methodAddImageDialog.getFileToCopy() != null) {
                try {
                    String string = NetUtil.decodedFileUrl((String)ResourceHelper.getURLForAttachment((Shell)Display.getCurrent().getActiveShell(), (File)methodAddImageDialog.getFileToCopy(), (MethodElement)((IMethodRichText)iRichText).getMethodElement(), (boolean)true));
                    if (string == null) {
                        return;
                    }
                    if (iRichText instanceof RichTextEditor) {
                        ((RichTextEditor)iRichText).setFocus();
                        ((RichTextEditor)iRichText).addImage(string, "" + methodAddImageDialog.getHeight(), "" + methodAddImageDialog.getWidth(), methodAddImageDialog.getAltTag());
                    } else {
                        iRichText.executeCommand("addImage", new String[]{string, "" + methodAddImageDialog.getHeight(), "" + methodAddImageDialog.getWidth(), methodAddImageDialog.getAltTag()});
                    }
                }
                catch (IOException iOException) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)iOException);
                }
            }
        }
    }

    public boolean disableInSourceMode() {
        return false;
    }
}

