/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.wizards.NewPluginWizard;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class NewPluginAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;

    public NewPluginAction() {
    }

    public NewPluginAction(String string) {
        super(string);
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.window = iWorkbenchWindow;
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void run() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.noOpenLibraryError_msg);
            return;
        }
        Shell shell = Display.getCurrent().getActiveShell();
        IStatus iStatus = UserInteractionHelper.checkModify((EObject)methodLibrary, (Shell)shell);
        if (!iStatus.isOK()) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.newPluginWizard_createError, iStatus);
            return;
        }
        final IWorkbench iWorkbench = this.window != null ? (this.window.getWorkbench() == null ? PlatformUI.getWorkbench() : this.window.getWorkbench()) : PlatformUI.getWorkbench();
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                NewPluginAction.execute(iWorkbench, null);
            }
        });
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void dispose() {
    }

    public static void execute(IWorkbench iWorkbench, ISelection iSelection) {
        NewPluginWizard newPluginWizard = new NewPluginWizard();
        if (iSelection instanceof IStructuredSelection || iSelection == null) {
            newPluginWizard.init(iWorkbench, (IStructuredSelection)iSelection);
        }
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)newPluginWizard);
        wizardDialog.create();
        wizardDialog.open();
        if (!PerspectiveListUtil.isAuthoringPerspective()) {
            PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
        }
    }
}

