/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IModifyingAction;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class OutdentAction
extends CommandActionHandler
implements IWorkbenchPartAction,
IModifyingAction {
    private static final String LABEL = AuthoringUIResources.ProcessEditor_Action_Outdent;
    private ProcessEditor editor;

    public OutdentAction(String string) {
        super(null, string);
    }

    public OutdentAction() {
        this(LABEL);
        this.setImageDescriptor(RichTextImages.IMG_DESC_OUTDENT);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_OUTDENT);
        this.setToolTipText(LABEL);
    }

    public boolean updateSelection(IStructuredSelection iStructuredSelection) {
        Object object;
        boolean bl = false;
        if (iStructuredSelection.size() == 1 && (object = iStructuredSelection.getFirstElement()) instanceof Activity) {
            bl = super.updateSelection(iStructuredSelection);
        }
        this.setEnabled(bl);
        return bl;
    }

    public Command createCommand(Collection collection) {
        if (this.domain instanceof AdapterFactoryEditingDomain) {
            return new OutdentCommand(collection, ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory());
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setActiveWorkbenchPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IEditingDomainProvider) {
            this.domain = ((IEditingDomainProvider)iWorkbenchPart).getEditingDomain();
        }
        if (iWorkbenchPart instanceof ProcessEditor) {
            this.editor = (ProcessEditor)iWorkbenchPart;
        } else if (iWorkbenchPart == null) {
            this.editor = null;
        }
    }

    private void superRun() {
        super.run();
    }

    public void run() {
        BusyIndicator.showWhile((Display)this.editor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                OutdentAction.this.superRun();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OutdentCommand
    extends AbstractCommand
    implements IResourceAwareCommand {
        private static final AdapterFactory[] ADAPTER_FACTORIES = new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()};
        private Collection<BreakdownElement> elements;
        private Set modifiedResources;
        private BreakdownElement element;
        private Activity oldParent;
        private Activity newParent;
        private int oldIndex;
        private int newIndex;
        private List<Object> newChildren;
        private AdapterFactory adapterFactory;

        public OutdentCommand(Collection<BreakdownElement> collection, AdapterFactory adapterFactory) {
            this.elements = collection;
            this.adapterFactory = adapterFactory;
            this.setLabel(LABEL);
        }

        public void dispose() {
            if (this.newChildren != null) {
                this.newChildren.clear();
                this.newChildren = null;
            }
            super.dispose();
        }

        public Collection getModifiedResources() {
            if (this.modifiedResources == null) {
                Process process = null;
                Resource resource = this.elements.iterator();
                while (process == null && resource.hasNext()) {
                    BreakdownElement breakdownElement = resource.next();
                    process = TngUtil.getOwningProcess((BreakdownElement)breakdownElement);
                }
                if (process != null && (resource = process.eResource()) != null) {
                    this.modifiedResources = Collections.singleton(process.eResource());
                }
                if (this.modifiedResources == null) {
                    this.modifiedResources = Collections.EMPTY_SET;
                }
            }
            return this.modifiedResources;
        }

        protected boolean prepare() {
            Object object;
            this.element = this.elements.iterator().next();
            this.oldParent = this.element.getSuperActivities();
            if (this.oldParent == null) {
                return false;
            }
            this.oldIndex = this.oldParent.getBreakdownElements().indexOf(this.element);
            HashMap hashMap = new HashMap();
            AdapterFactory[] adapterFactoryArray = this.element instanceof Activity ? ADAPTER_FACTORIES : new AdapterFactory[]{this.adapterFactory};
            int n = 0;
            while (n < adapterFactoryArray.length) {
                int n2;
                AdapterFactory object2 = adapterFactoryArray[n];
                object = (ITreeItemContentProvider)object2.adapt((Notifier)this.oldParent, ITreeItemContentProvider.class);
                ArrayList arrayList = new ArrayList(object.getChildren((Object)this.oldParent));
                int n3 = arrayList.indexOf(this.element);
                int n4 = n3 + 1;
                if (n4 < (n2 = arrayList.size())) {
                    int n5 = n4;
                    while (n5 < n2) {
                        Object e = arrayList.get(n5);
                        if (ProcessUtil.isInherited(e)) {
                            return false;
                        }
                        ++n5;
                    }
                    hashMap.put(arrayList, n4);
                }
                ++n;
            }
            if (!(this.element instanceof Activity) && !hashMap.isEmpty()) {
                return false;
            }
            this.newParent = this.oldParent.getSuperActivities();
            if (this.newParent != null) {
                this.newIndex = this.newParent.getBreakdownElements().indexOf(this.oldParent) + 1;
                if (!hashMap.isEmpty()) {
                    this.newChildren = new UniqueEList();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object = (List)entry.getKey();
                        this.newChildren.addAll(object.subList((Integer)entry.getValue(), object.size()));
                    }
                    if (!DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)((VariabilityElement)this.element), this.newChildren, (boolean)true)) {
                        return false;
                    }
                }
                return DependencyChecker.checkCircularForMovingVariabilityElement((VariabilityElement)this.newParent, (Collection)Collections.singleton(this.element), (boolean)true);
            }
            return false;
        }

        public void execute() {
            this.newParent.getBreakdownElements().add(this.newIndex, this.element);
            if (this.element instanceof Activity) {
                ProcessPackage processPackage = (ProcessPackage)this.newParent.eContainer();
                processPackage.getChildPackages().add(this.element.eContainer());
                if (this.newChildren != null) {
                    ((Activity)this.element).getBreakdownElements().addAll(this.newChildren);
                    for (Object object : this.newChildren) {
                        if (!(object instanceof Activity)) continue;
                        processPackage.getChildPackages().add(((Activity)object).eContainer());
                    }
                }
            }
        }

        public void redo() {
            this.execute();
        }

        public void undo() {
            this.oldParent.getBreakdownElements().add(this.oldIndex, this.element);
            if (this.element instanceof Activity) {
                ProcessPackage processPackage = (ProcessPackage)this.oldParent.eContainer();
                processPackage.getChildPackages().add(this.element.eContainer());
                if (this.newChildren != null) {
                    ((Activity)this.element).getBreakdownElements().removeAll(this.newChildren);
                    for (Object object : this.newChildren) {
                        if (!(object instanceof Activity)) continue;
                        processPackage.getChildPackages().add(((Activity)object).eContainer());
                    }
                }
            }
        }

        public Collection getAffectedObjects() {
            return this.elements;
        }
    }
}

